/*
 * Decompiled with CFR 0.152.
 */
package com.micronova.util;

import com.micronova.util.BeanUtil;
import com.micronova.util.NestedMap;
import com.micronova.util.StringUtil;
import com.micronova.util.TypeUtil;
import com.micronova.util.cc.html.Parser;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XMLUtil {
    private static final Pattern patternEncode;
    private static final Map replacementMapEncode;
    private static final Pattern patternDecode;
    private static final Map replacementMapDecode;

    public static String decode(String string) {
        return StringUtil.applyPattern(string, patternDecode, replacementMapDecode);
    }

    public static String encode(String string) {
        return XMLUtil.encode(string, null);
    }

    public static String encode(String string, Pattern pattern) {
        if (pattern == null) {
            pattern = patternEncode;
        }
        return StringUtil.applyPattern(string, pattern, replacementMapEncode);
    }

    public static final Source createSource(Object object) throws Exception {
        Source source = null;
        if (object instanceof Node) {
            source = new DOMSource((Node)object);
        } else if (object instanceof String) {
            source = new StreamSource(new StringReader(object.toString()));
        } else if (object instanceof InputSource) {
            source = new SAXSource((InputSource)object);
        } else if (object instanceof InputStream) {
            source = new StreamSource((InputStream)object);
        } else if (object instanceof Reader) {
            source = new StreamSource((Reader)object);
        } else if (object instanceof URL) {
            source = new StreamSource(((URL)object).toString());
        }
        return source;
    }

    public static final Object output(Source source, NestedMap nestedMap) throws Exception {
        if (source != null) {
            Object object;
            Object object2;
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            if (nestedMap != null) {
                object2 = nestedMap.entrySet().iterator();
                while (object2.hasNext()) {
                    object = (Map.Entry)object2.next();
                    transformer.setOutputProperty(object.getKey().toString(), object.getValue().toString());
                }
            }
            object2 = new StringWriter();
            object = new StreamResult((Writer)object2);
            transformer.transform(source, (Result)object);
            return ((StringWriter)object2).toString();
        }
        return null;
    }

    public static final Document parse(Object object, NestedMap nestedMap) throws Exception {
        Document document = null;
        if (object != null) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            if (nestedMap != null) {
                BeanUtil.fill(documentBuilderFactory, nestedMap);
            } else {
                documentBuilderFactory.setNamespaceAware(true);
                documentBuilderFactory.setIgnoringComments(true);
                documentBuilderFactory.setIgnoringElementContentWhitespace(true);
                documentBuilderFactory.setExpandEntityReferences(true);
                documentBuilderFactory.setCoalescing(true);
                documentBuilderFactory.setValidating(false);
            }
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Reader reader = object instanceof Reader ? (Reader)object : new StringReader(object.toString());
            document = documentBuilder.parse(new InputSource(reader));
        }
        return document;
    }

    private static Map getParseHtmlMap(Object object) {
        HashMap<String, Boolean> hashMap = null;
        if (object != null) {
            if (object instanceof Map) {
                hashMap = (HashMap<String, Boolean>)object;
            } else {
                List list = TypeUtil.isStringList(object, ',', '\\');
                if (list != null && list.size() > 0) {
                    hashMap = new HashMap<String, Boolean>();
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        hashMap.put(iterator.next().toString().toLowerCase(), Boolean.TRUE);
                    }
                }
            }
        }
        return hashMap;
    }

    private static int getParseHtmlStrategy(String string) {
        int n = 0;
        if ("data".equals(string)) {
            n = 1;
        } else if ("none".equals(string)) {
            n = 2;
        } else if ("single".equals(string)) {
            n = 0;
        }
        return n;
    }

    public static Document parseHtml(Object object, NestedMap nestedMap) throws Exception {
        Document document = null;
        Reader reader = null;
        try {
            String string = nestedMap.getString("prefix", "");
            int n = XMLUtil.getParseHtmlStrategy(nestedMap.getString("strategy"));
            String string2 = nestedMap.getString("rootName", "root");
            Map map = XMLUtil.getParseHtmlMap(nestedMap.get("exclude"));
            Map map2 = XMLUtil.getParseHtmlMap(nestedMap.get("include"));
            reader = object instanceof Reader ? (Reader)object : new StringReader(object.toString());
            Parser parser = new Parser(reader);
            document = parser.buildDocument(string, n, string2, map, map2);
        }
        catch (Exception exception) {
            try {
                reader.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw exception;
        }
        return document;
    }

    static {
        patternDecode = Pattern.compile("(&amp;|&quot;|&lt;|&gt;|&apos;|&#034;|&#039;|&#123;|&#125;)");
        replacementMapDecode = new HashMap();
        replacementMapDecode.put("&amp;", "&");
        replacementMapDecode.put("&quot;", "\"");
        replacementMapDecode.put("&#034;", "\"");
        replacementMapDecode.put("&apos;", "'");
        replacementMapDecode.put("&#039;", "'");
        replacementMapDecode.put("&lt;", "<");
        replacementMapDecode.put("&gt;", ">");
        replacementMapDecode.put("&#123;", "{");
        replacementMapDecode.put("&#125;", "}");
        patternEncode = Pattern.compile("[&\"'<>{}]");
        replacementMapEncode = new HashMap();
        replacementMapEncode.put("&", "&amp;");
        replacementMapEncode.put("\"", "&quot;");
        replacementMapEncode.put("'", "&#039;");
        replacementMapEncode.put("<", "&lt;");
        replacementMapEncode.put(">", "&gt;");
        replacementMapEncode.put("{", "&#123;");
        replacementMapEncode.put("}", "&#125;");
    }
}

