/*
 * Decompiled with CFR 0.152.
 */
package com.micronova.util;

import com.micronova.util.NestedMap;
import com.micronova.util.TypeUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLMap {
    public static final String TYPEATTRIBUTE = "typeAttribute";
    public static final String INDEXATTRIBUTE = "indexAttribute";
    public static final String DEFAULTTYPE = "defaultType";
    public static final String MAPTYPE = "mapType";
    public static final String LISTTYPE = "listType";
    public static final String ITEMNAME = "itemName";
    public static final String LISTNAME = "listName";
    public static final String NAMEPREFIX = "namePrefix";
    public static final String NAMESPACE = "namespace";
    public static final String ROOTNAME = "rootName";
    public static final String NAMEMAP = "nameMap";
    public static final String ROOTATTRIBUTE = "rootAttribute";
    public static final String HASATTRIBUTE = "hasAttribute";
    public static final String ATTRIBUTE = "^";
    public static final Map defaultControlMap = new HashMap();

    protected static final Map getControlMap(Map map, String string) {
        Map map2 = null;
        if (map != null) {
            map2 = (Map)map.get(string);
        }
        if (map2 == null) {
            map2 = (Map)defaultControlMap.get(string);
        }
        return map2;
    }

    protected static final String getControlString(Map map, String string) {
        String string2 = null;
        if (map != null) {
            string2 = (String)map.get(string);
        }
        if (string2 == null) {
            string2 = (String)defaultControlMap.get(string);
        }
        return string2;
    }

    protected static final Element addAttribute(Element element, Map map) {
        if (map != null) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                element.setAttribute(entry.getKey().toString(), entry.getValue().toString());
            }
        }
        return element;
    }

    public static final Document encode(Object object) throws Exception {
        return XMLMap.encode(object, null);
    }

    public static final Document encode(Object object, Map map) throws Exception {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        String string = XMLMap.getControlString(map, ROOTNAME);
        Element element = XMLMap.buildMapNode(document, string, object, XMLMap.getControlMap(map, ATTRIBUTE), map);
        document.appendChild(element);
        return document;
    }

    protected static final Element buildMapNode(Document document, String string, Object object, Map map, Map map2) {
        String string2 = string;
        String string3 = XMLMap.getControlString(map2, NAMEPREFIX);
        if (!TypeUtil.isEmpty(string3)) {
            string2 = string3 + string2;
        }
        Element element = document.createElement(string2);
        String string4 = XMLMap.getControlString(map2, TYPEATTRIBUTE);
        if (object instanceof Map) {
            Map map3 = (Map)((Map)object).get(ATTRIBUTE);
            String string5 = XMLMap.getControlString(map2, MAPTYPE);
            if (!TypeUtil.isEmpty(string4) && !TypeUtil.isEmpty(string5)) {
                element.setAttribute(string4, string5);
            }
            TreeMap treeMap = new TreeMap((Map)object);
            Iterator iterator = treeMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object2;
                Object object3;
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                Object v = entry.getValue();
                if (k == null || ATTRIBUTE.equals(object3 = k.toString())) continue;
                if (v instanceof List) {
                    object2 = XMLMap.getControlString(map2, LISTNAME);
                    object3 = "*".equals(object2) ? string : object2;
                }
                object2 = null;
                if (map3 != null) {
                    object2 = (Map)map3.get(object3);
                }
                Element element2 = XMLMap.buildMapNode(document, (String)object3, v, (Map)object2, map2);
                element.appendChild(element2);
            }
        } else if (object instanceof List) {
            String string6 = XMLMap.getControlString(map2, LISTTYPE);
            String string7 = XMLMap.getControlString(map2, INDEXATTRIBUTE);
            if (!TypeUtil.isEmpty(string4) && !TypeUtil.isEmpty(string6)) {
                element.setAttribute(string4, string6);
            }
            int n = 0;
            Iterator iterator = ((List)object).iterator();
            String string8 = XMLMap.getControlString(map2, ITEMNAME);
            while (iterator.hasNext()) {
                Object e = iterator.next();
                Element element3 = XMLMap.buildMapNode(document, string8, e, map, map2);
                if (!TypeUtil.isEmpty(string7)) {
                    element3.setAttribute(string7, Integer.toString(n));
                }
                element.appendChild(element3);
                ++n;
            }
        } else if (object != null) {
            String string9 = XMLMap.getControlString(map2, DEFAULTTYPE);
            if (!TypeUtil.isEmpty(string4) && !TypeUtil.isEmpty(string9)) {
                element.setAttribute(string4, string9);
            }
            Text text = document.createTextNode(object.toString());
            element.appendChild(text);
        }
        XMLMap.addAttribute(element, map);
        return element;
    }

    public static Object decode(Node node) throws Exception {
        return XMLMap.decode(node, null);
    }

    public static String getNodeName(Node node, String string) {
        String string2 = null;
        String string3 = node.getNamespaceURI();
        String string4 = node.getLocalName();
        string2 = string4 != null ? string4 : node.getNodeName();
        if (!"_".equals(string2) && !"*".equals(string)) {
            if (string3 != null) {
                if (!string3.equals(string)) {
                    string2 = string3 + "|" + string2;
                }
            } else if (string != null && !string.equals("")) {
                string2 = "|" + string2;
            }
        }
        return string2;
    }

    public static NestedMap getAttributeMap(Node node, String string) throws Exception {
        int n;
        NestedMap nestedMap = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null && (n = namedNodeMap.getLength()) > 0) {
            nestedMap = new NestedMap();
            while (--n >= 0) {
                Attr attr = (Attr)namedNodeMap.item(n);
                if (attr == null) continue;
                String string2 = XMLMap.getNodeName(attr, string);
                nestedMap.put(string2, attr.getValue());
            }
        }
        return nestedMap;
    }

    public static Object decode(Node node, Map map) throws Exception {
        return XMLMap.decode(node, map, "/");
    }

    public static Object decode(Node node, Map map, String string) throws Exception {
        NestedMap nestedMap = null;
        String string2 = null;
        node.normalize();
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        String string3 = XMLMap.getControlString(map, NAMESPACE);
        String string4 = XMLMap.getControlString(map, HASATTRIBUTE);
        Map map2 = XMLMap.getControlMap(map, NAMEMAP);
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            short s = node2.getNodeType();
            if (s == 1) {
                String string5;
                Object object;
                if (nestedMap == null) {
                    nestedMap = new NestedMap();
                }
                String string6 = XMLMap.getNodeName(node2, string3);
                NestedMap nestedMap2 = null;
                if (TypeUtil.isTrue(string4) && (object = node2.getAttributes()) != null) {
                    nestedMap2 = XMLMap.getAttributeMap(node2, string3);
                }
                if ((string5 = XMLMap.getControlString(map2, (String)(object = string + string6 + "/"))) == null && (string5 = XMLMap.getControlString(map2, string6)) == null) {
                    string5 = string6;
                }
                if ("_".equals(string5)) {
                    NodeList nodeList2 = node2.getChildNodes();
                    int n2 = nodeList2.getLength();
                    for (int j = 0; j < n2; ++j) {
                        Object object2;
                        Node node3 = nodeList2.item(j);
                        NestedMap nestedMap3 = XMLMap.getAttributeMap(node3, string3);
                        String string7 = "*";
                        if (nestedMap3 != null) {
                            string7 = nestedMap3.getString("index", string7);
                        }
                        if ((object2 = XMLMap.decode(node3, map, (String)object)) == null) continue;
                        nestedMap.put("@_." + string7, object2);
                        if (!TypeUtil.isTrue(string4) || nestedMap3 == null) continue;
                        nestedMap.put("@^._." + string7, nestedMap3);
                    }
                    continue;
                }
                nestedMap.put(string5, XMLMap.decode(node2, map, (String)object));
                if (nestedMap2 == null) continue;
                nestedMap.put("@^." + string5, nestedMap2);
                continue;
            }
            if (s != 3) continue;
            string2 = string2 == null ? node2.getNodeValue() : string2 + node2.getNodeValue();
        }
        if (nestedMap != null) {
            return nestedMap;
        }
        return string2;
    }

    static {
        defaultControlMap.put(TYPEATTRIBUTE, null);
        defaultControlMap.put(INDEXATTRIBUTE, "index");
        defaultControlMap.put(DEFAULTTYPE, "string");
        defaultControlMap.put(MAPTYPE, "map");
        defaultControlMap.put(LISTTYPE, "list");
        defaultControlMap.put(LISTNAME, "_");
        defaultControlMap.put(ITEMNAME, "item");
        defaultControlMap.put(ROOTNAME, "root");
        defaultControlMap.put(NAMESPACE, "*");
    }
}

