/*
 * Decompiled with CFR 0.152.
 */
package com.micronova.util;

import com.micronova.util.NumberUtil;
import com.micronova.util.SparseList;
import com.micronova.util.TypeUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class StringUtil {
    public static final char DEFAULTESCAPE = '\\';

    public static final List split(StringBuffer stringBuffer, char c, char c2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = stringBuffer.length();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            char c3 = stringBuffer.charAt(i);
            if (bl) {
                if (c3 != c) {
                    stringBuffer2.append(c2);
                }
                stringBuffer2.append(c3);
                bl = false;
                continue;
            }
            if (c3 == c2) {
                bl = true;
                continue;
            }
            if (c3 == c) {
                arrayList.add(stringBuffer2.toString());
                stringBuffer2.setLength(0);
                continue;
            }
            stringBuffer2.append(c3);
        }
        if (stringBuffer2.length() != 0) {
            arrayList.add(stringBuffer2.toString());
        }
        return arrayList;
    }

    public static final List split(String string, char c, char c2) {
        return StringUtil.split(new StringBuffer(string), c, c2);
    }

    public static final List split(StringBuffer stringBuffer, char c) {
        return StringUtil.split(stringBuffer, c, '\\');
    }

    public static final List split(String string, char c) {
        return StringUtil.split(string, c, '\\');
    }

    public static final String join(List list, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (bl) {
                stringBuffer.append(string);
            }
            stringBuffer.append(iterator.next());
            bl = true;
        }
        return stringBuffer.toString();
    }

    public static final void decodeBackslash(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        int n = stringBuffer.length();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            char c = stringBuffer.charAt(i);
            if (c == '\\') {
                if (!bl) {
                    bl = true;
                    continue;
                }
                stringBuffer2.append(c);
                bl = false;
                continue;
            }
            if (bl) {
                switch (c) {
                    case 'n': {
                        stringBuffer2.append('\n');
                        break;
                    }
                    case 'r': {
                        stringBuffer2.append('\r');
                        break;
                    }
                    case 't': {
                        stringBuffer2.append('\t');
                        break;
                    }
                    case 'b': {
                        stringBuffer2.append('\b');
                    }
                }
                bl = false;
                continue;
            }
            stringBuffer2.append(c);
        }
    }

    public static final String encodeBackslash(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        StringBuffer stringBuffer2 = new StringBuffer();
        StringUtil.encodeBackslash(stringBuffer, stringBuffer2);
        return stringBuffer2.toString();
    }

    public static final void encodeBackslash(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        int n = stringBuffer.length();
        block7: for (int i = 0; i < n; ++i) {
            char c = stringBuffer.charAt(i);
            switch (c) {
                case '\n': {
                    stringBuffer2.append("\\n");
                    continue block7;
                }
                case '\r': {
                    stringBuffer2.append("\\r");
                    continue block7;
                }
                case '\t': {
                    stringBuffer2.append("\\t");
                    continue block7;
                }
                case '\b': {
                    stringBuffer2.append("\\b");
                    continue block7;
                }
                case '\\': {
                    stringBuffer2.append("\\\\");
                    continue block7;
                }
                default: {
                    stringBuffer2.append(c);
                }
            }
        }
    }

    public static final String decodeBackslash(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        StringBuffer stringBuffer2 = new StringBuffer();
        StringUtil.decodeBackslash(stringBuffer, stringBuffer2);
        return stringBuffer2.toString();
    }

    public static byte[] compressGZIP(byte[] byArray) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        gZIPOutputStream.write(byArray, 0, byArray.length);
        gZIPOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] decompressGZIP(byte[] byArray) throws Exception {
        int n;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = gZIPInputStream.read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        gZIPInputStream.close();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] compressZip(byte[] byArray) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
        zipOutputStream.putNextEntry(new ZipEntry("ZIP"));
        zipOutputStream.write(byArray, 0, byArray.length);
        zipOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] decompressZip(byte[] byArray) throws Exception {
        int n;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ZipInputStream zipInputStream = new ZipInputStream(byteArrayInputStream);
        zipInputStream.getNextEntry();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = zipInputStream.read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        zipInputStream.close();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static final String toBinaryString(byte[] byArray) throws Exception {
        return new String(byArray, "iso-8859-1");
    }

    public static final byte[] fromBinaryString(String string) throws Exception {
        return string.getBytes("iso-8859-1");
    }

    public static final String compressGZIP(String string) throws Exception {
        return StringUtil.toBinaryString(StringUtil.compressGZIP(StringUtil.fromBinaryString(string)));
    }

    public static final String decompressGZIP(String string) throws Exception {
        return StringUtil.toBinaryString(StringUtil.decompressGZIP(StringUtil.fromBinaryString(string)));
    }

    public static final String compressZip(String string) throws Exception {
        return StringUtil.toBinaryString(StringUtil.compressZip(StringUtil.fromBinaryString(string)));
    }

    public static final String decompressZip(String string) throws Exception {
        return StringUtil.toBinaryString(StringUtil.decompressZip(StringUtil.fromBinaryString(string)));
    }

    public static final String encodeBase64(byte[] byArray) throws Exception {
        return new BASE64Encoder().encode(byArray);
    }

    public static final byte[] decodeBase64(String string) throws Exception {
        return new BASE64Decoder().decodeBuffer(string);
    }

    public static final StringBuffer encodeHex(byte[] byArray, StringBuffer stringBuffer) {
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(NumberUtil.toHexString((256 + byArray[i]) % 256, "00"));
        }
        return stringBuffer;
    }

    public static final String encodeHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        return StringUtil.encodeHex(byArray, stringBuffer).toString();
    }

    public static final byte[] decodeHex(StringBuffer stringBuffer, byte[] byArray) throws Exception {
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)Integer.parseInt(stringBuffer.substring(n, n + 2), 16);
            n += 2;
        }
        return byArray;
    }

    public static final byte[] decodeHex(String string) throws Exception {
        int n = string.length();
        if (n % 2 == 0) {
            int n2 = n / 2;
            byte[] byArray = new byte[string.length() / 2];
            return StringUtil.decodeHex(new StringBuffer(string), byArray);
        }
        throw new Exception("string length must be even");
    }

    public static final List toCharacterList(String string) throws Exception {
        return TypeUtil.isList(string.toString().toCharArray());
    }

    public static final String fromCharacterList(List list) throws Exception {
        int n = list.size();
        char[] cArray = new char[n];
        int n2 = n;
        while (--n2 >= 0) {
            cArray[n2] = ((Character)list.get(n2)).charValue();
        }
        return new String(cArray);
    }

    public static void applyPattern(CharSequence charSequence, StringBuffer stringBuffer, Pattern pattern, Map map) {
        Matcher matcher = pattern.matcher(charSequence);
        while (matcher.find()) {
            String string = matcher.group();
            if (map == null) {
                matcher.appendReplacement(stringBuffer, "");
                continue;
            }
            String string2 = (String)map.get(string);
            if (string2 == null) {
                string2 = string;
            }
            matcher.appendReplacement(stringBuffer, string2);
        }
        matcher.appendTail(stringBuffer);
    }

    public static final String applyPattern(String string, Pattern pattern, Map map) {
        StringBuffer stringBuffer = new StringBuffer(string);
        StringBuffer stringBuffer2 = new StringBuffer();
        StringUtil.applyPattern(stringBuffer, stringBuffer2, pattern, map);
        return stringBuffer2.toString();
    }

    public static List decompose(CharSequence charSequence, Pattern pattern, List list, int n, boolean bl, boolean bl2) {
        Matcher matcher = pattern.matcher(charSequence);
        int n2 = 0;
        int n3 = 0;
        while (matcher.find()) {
            int n4 = matcher.start();
            n3 = matcher.end();
            if (n4 >= n2 && bl2) {
                list.add(charSequence.subSequence(n2, n4));
            }
            if (bl) {
                if (n >= 0) {
                    list.add(matcher.group(n));
                } else {
                    SparseList sparseList = new SparseList();
                    for (int i = 0; i <= matcher.groupCount(); ++i) {
                        sparseList.set(i, matcher.group(i));
                    }
                    list.add(sparseList);
                }
            }
            n2 = n3;
        }
        if (bl2) {
            list.add(charSequence.subSequence(n3, charSequence.length()));
        }
        return list;
    }

    public static void decompose(CharSequence charSequence, Pattern pattern, List list, int n) {
        StringUtil.decompose(charSequence, pattern, list, n, true, true);
    }

    public static List decompose(String string, Pattern pattern, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        ArrayList arrayList = new ArrayList();
        StringUtil.decompose(stringBuffer, pattern, arrayList, n);
        return arrayList;
    }

    public static List decompose(String string, Pattern pattern) {
        return StringUtil.decompose(string, pattern, 0);
    }

    public static void split(CharSequence charSequence, Pattern pattern, List list, int n) {
        StringUtil.decompose(charSequence, pattern, list, n, false, true);
    }

    public static List split(String string, Pattern pattern, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        ArrayList arrayList = new ArrayList();
        StringUtil.split(stringBuffer, pattern, arrayList, n);
        return arrayList;
    }

    public static List split(String string, Pattern pattern) {
        return StringUtil.split(string, pattern, 0);
    }

    public static void matchAll(CharSequence charSequence, Pattern pattern, List list, int n) {
        StringUtil.decompose(charSequence, pattern, list, n, true, false);
    }

    public static List matchAll(String string, Pattern pattern, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        ArrayList arrayList = new ArrayList();
        StringUtil.matchAll(stringBuffer, pattern, arrayList, n);
        return arrayList;
    }

    public static List matchAll(String string, Pattern pattern) {
        return StringUtil.matchAll(string, pattern, 0);
    }

    public static List matchingGroups(String string, Pattern pattern) {
        SparseList sparseList = new SparseList();
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            for (int i = 0; i <= matcher.groupCount(); ++i) {
                sparseList.set(i, matcher.group(i));
            }
        }
        return sparseList;
    }

    public static String capitalize(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (stringBuffer.length() > 0) {
            char c = stringBuffer.charAt(0);
            if (Character.isLowerCase(c)) {
                stringBuffer.setCharAt(0, Character.toUpperCase(c));
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public static String reverse(String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = stringBuffer.length();
        int n3 = n = n2 / 2;
        int n4 = n2 - n;
        while (--n3 >= 0) {
            char c = stringBuffer.charAt(n3);
            stringBuffer.setCharAt(n3, stringBuffer.charAt(n4));
            stringBuffer.setCharAt(n4, c);
            ++n4;
        }
        return stringBuffer.toString();
    }

    public static String multiply(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = n;
        while (--n2 >= 0) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String match(CharSequence charSequence, Pattern pattern, int n) {
        Matcher matcher = pattern.matcher(charSequence);
        if (matcher.find()) {
            return matcher.group(n);
        }
        return null;
    }

    public static String match(String string, Pattern pattern) {
        return StringUtil.match(string, pattern, 0);
    }

    public static Map countWords(String string, Pattern pattern) {
        String[] stringArray = pattern.split(string);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        int n = stringArray.length;
        while (--n >= 0) {
            String string2 = stringArray[n];
            Integer n2 = (Integer)hashMap.get(string2);
            n2 = n2 == null ? new Integer(1) : new Integer(n2 + 1);
            hashMap.put(string2, n2);
        }
        return hashMap;
    }

    public static String substring(String string, int n, int n2) {
        if (string != null) {
            int n3 = string.length();
            if (n < 0) {
                n = n3 + n;
            }
            if (n2 <= 0) {
                n2 = n3 + n2;
            }
            if (n < 0) {
                n = 0;
            }
            if (n2 > n3) {
                n2 = n3;
            }
            string = n2 <= n ? "" : string.substring(n, n2);
        }
        return string;
    }

    public static String substring(String string, int n) {
        return StringUtil.substring(string, n, 0);
    }

    public static String replaceCharacters(String string, char[] cArray, char[] cArray2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.length();
        while (--n >= 0) {
            char c = stringBuffer.charAt(n);
            int n2 = cArray.length;
            while (--n2 >= 0) {
                if (cArray[n2] != c) continue;
                stringBuffer.setCharAt(n, cArray2[n2]);
            }
        }
        return stringBuffer.toString();
    }
}

