/*
 * Decompiled with CFR 0.152.
 */
package com.micronova.util;

import com.micronova.util.MapBean;
import com.micronova.util.SparseList;
import com.micronova.util.TypeUtil;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class NestedMap
extends MapBean {
    public static final char SEPARATOR = '.';
    public static final char ESCAPE = '_';
    public static final char NESTED = '@';
    public static final char NONNESTED = '#';
    public static final String ENCODED = "_encoded";
    public static final String CLEAR = "_clear";
    public static final String PARAM = "_param";
    public static final String SOURCE = "_source";
    public static final String LIST = "";
    public static final String LISTSIZE = "_listSize";
    public static final String LISTACTUALSIZE = "_listActualSize";
    public static final String KEYLIST = "_keyList";
    public static final String ENTRYLIST = "_entryList";
    public static final String VALUELIST = "_valueList";
    public static final String KEYLISTSORTED = "_keyListSorted";
    public static final String ENTRYLISTSORTED = "_entryListSorted";
    public static final String ENCODEDSORTED = "_encodedSorted";
    public static final String ENCODING = "_encoding";
    public static final String CREATESUBMAP = "CREATESUBMAP";
    public static final String CREATESUBLIST = "CREATESUBLIST";
    public static final String LISTKEY = "_";
    protected String _encoding = "utf-8";
    protected static final String UNSUPPORTED = "UNSUPPORTED";
    protected NestedMap _secondary;

    protected NestedMap getSecondaryMap(boolean bl) {
        NestedMap nestedMap = this._secondary;
        if (nestedMap == null && bl) {
            this._secondary = nestedMap = new NestedMap();
        }
        return nestedMap;
    }

    protected Object getSecondary(Object object) {
        NestedMap nestedMap = this.getSecondaryMap(false);
        if (nestedMap == null) {
            return null;
        }
        return nestedMap.get(object);
    }

    protected Object putSecondary(Object object, Object object2) {
        NestedMap nestedMap = this.getSecondaryMap(true);
        return nestedMap.put(object, object2);
    }

    public void copySecondary(NestedMap nestedMap) {
        NestedMap nestedMap2 = nestedMap.getSecondaryMap(false);
        if (nestedMap2 != null) {
            NestedMap nestedMap3 = this.getSecondaryMap(true);
            nestedMap3.copy(nestedMap2);
        }
    }

    public void clearSecondary() {
        this._secondary = null;
    }

    public void clear() {
        this.clearSecondary();
        super.clear();
    }

    protected Object getSpecial(String string) {
        Object object = UNSUPPORTED;
        if (LIST.equals(string)) {
            object = this.getSubList();
        } else if (PARAM.equals(string)) {
            try {
                object = this.exportParams();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                object = null;
            }
        } else if (ENCODED.equals(string)) {
            try {
                object = NestedMap.encodeMap(this.exportParams(), this._encoding, false);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                object = null;
            }
        } else if (ENCODEDSORTED.equals(string)) {
            try {
                object = NestedMap.encodeMap(this.exportParams(), this._encoding, true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                object = null;
            }
        } else if (LISTSIZE.equals(string)) {
            List list = this.getSubList();
            object = new Integer(list.size());
        } else if (LISTACTUALSIZE.equals(string)) {
            List list = this.getSubList();
            object = new Integer(TypeUtil.getActualSize(list));
        } else if (KEYLIST.equals(string)) {
            object = this.makeList(this.keySet());
        } else if (ENTRYLIST.equals(string)) {
            object = this.makeList(this.entrySet());
        } else if (VALUELIST.equals(string)) {
            object = this.makeList(this.values());
        } else if (KEYLISTSORTED.equals(string)) {
            object = this.makeList(new TreeMap(this).keySet());
        } else if (ENTRYLISTSORTED.equals(string)) {
            object = this.makeList(new TreeMap(this).entrySet());
        } else if (ENCODING.equals(string)) {
            object = this._encoding;
        }
        return object;
    }

    public static String encodeString(String string, String string2) throws Exception {
        return URLEncoder.encode(string, string2);
    }

    public static String decodeString(String string, String string2) throws Exception {
        return URLDecoder.decode(string, string2);
    }

    public void copy(NestedMap nestedMap) {
        Iterator iterator = nestedMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object k = entry.getKey();
            this.putMapObject(k, entry.getValue());
        }
        this.copySecondary(nestedMap);
    }

    public void copyFromSource(Object object) throws Exception {
        block4: {
            block5: {
                block3: {
                    if (!(object instanceof Map)) break block3;
                    Map map = (Map)object;
                    Iterator iterator = map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        Object k = entry.getKey();
                        this.putMapObject(k, entry.getValue());
                    }
                    break block4;
                }
                if (!(object instanceof String)) break block5;
                this.importParams((String)object);
                break block4;
            }
            List list = TypeUtil.isList(object);
            if (list == null) break block4;
            Iterator iterator = list.iterator();
            List list2 = this.getSubList();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof Map) {
                    NestedMap nestedMap = new NestedMap();
                    nestedMap.copyFromSource(e);
                    list2.add(nestedMap);
                    continue;
                }
                list2.add(e);
            }
        }
    }

    public NestedMap() {
    }

    public NestedMap(Object object) throws Exception {
        this.copyFromSource(object);
    }

    protected List createList() {
        return (List)this.getObject(this, CREATESUBLIST);
    }

    protected NestedMap createMap() {
        return (NestedMap)this.getObject(this, CREATESUBMAP);
    }

    public List getSubList(boolean bl) {
        List list = (List)this.getMapObject(LISTKEY);
        if (list == null && bl) {
            list = this.createList();
            this.putMapObject(LISTKEY, list);
        }
        return list;
    }

    public List getSubList() {
        return this.getSubList(true);
    }

    public NestedMap getSubMap(Object object, boolean bl) {
        NestedMap nestedMap = (NestedMap)this.get(object);
        if (nestedMap == null && bl) {
            nestedMap = this.createMap();
            this.put(object, nestedMap);
        }
        return nestedMap;
    }

    public NestedMap getSubMap(Object object) {
        return this.getSubMap(object, true);
    }

    public NestedMap getSubMap(List list, int n, boolean bl) {
        NestedMap nestedMap = null;
        if (list != null && (nestedMap = (NestedMap)list.get(n)) == null && bl) {
            nestedMap = this.createMap();
            list.set(n, nestedMap);
        }
        return nestedMap;
    }

    public NestedMap getSubMap(List list, int n) {
        return this.getSubMap(list, n, true);
    }

    public NestedMap getSubMap(int n, boolean bl) {
        return this.getSubMap(this.getSubList(bl), n, bl);
    }

    public NestedMap getSubMap(int n) {
        return this.getSubMap(n, true);
    }

    public Object getElement(String string) {
        return this.getElement(string, false);
    }

    protected Object getElement(String string, boolean bl) {
        String string2 = string;
        Object var4_4 = null;
        String string3 = null;
        int n = string.indexOf(46);
        if (n >= 0) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        if (bl) {
            List list = (List)this.get(LISTKEY);
            if (TypeUtil.isEmptyString(string2)) {
                return list;
            }
            int n2 = Integer.parseInt(string2);
            if (n2 < 0) {
                n2 = list.size() + n2;
            }
            Object e = list.get(n2);
            if (TypeUtil.isEmptyString(string3)) {
                return e;
            }
            return ((NestedMap)e).getElement(string3, false);
        }
        Object object = this.get(string2);
        if (TypeUtil.isEmptyString(string3)) {
            return object;
        }
        if (LISTKEY.equals(string2)) {
            return this.getElement(string3, true);
        }
        return ((NestedMap)object).getElement(string3, false);
    }

    public void setElement(String string, Object object) {
        this.setElement(string, object, false);
    }

    protected void setElement(String string, Object object, boolean bl) {
        String string2 = string;
        Object var5_5 = null;
        String string3 = null;
        int n = string.indexOf(46);
        if (n >= 0) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        if (bl) {
            List list = this.getSubList();
            int n2 = list.size();
            int n3 = -1;
            boolean bl2 = false;
            boolean bl3 = false;
            if (LIST.equals(string2)) {
                string2 = "*";
            }
            if (string2.startsWith("*")) {
                bl2 = true;
                if ((string2 = string2.substring(1)).startsWith("*")) {
                    bl3 = true;
                    string2 = string2.substring(1);
                }
            }
            if (string2.length() == 0) {
                n3 = n2;
            } else {
                n3 = Integer.parseInt(string2);
                if (n3 < 0) {
                    n3 = n2 + n3;
                }
            }
            if (object == REMOVE) {
                object = null;
            }
            if (TypeUtil.isEmptyString(string3)) {
                if (bl2) {
                    if (object != null) {
                        if (n3 == n2) {
                            list.add(object);
                        } else {
                            list.add(n3, object);
                        }
                    } else if (n2 > 0 && !bl3) {
                        if (n3 == n2) {
                            list.remove(n2 - 1);
                        } else {
                            list.remove(n3);
                        }
                    }
                } else {
                    list.set(n3, object);
                }
            } else {
                NestedMap nestedMap = this.getSubMap(list, n3);
                nestedMap.setElement(string3, object);
            }
        } else if (LISTKEY.equals(string2)) {
            if (TypeUtil.isEmptyString(string3)) {
                this.putMapObject(string2, object);
            } else {
                this.setElement(string3, object, true);
            }
        } else if (TypeUtil.isEmptyString(string3)) {
            this.put(string2, object);
        } else {
            Object object2 = this.get(string2);
            if (object2 == null || object2 instanceof NestedMap) {
                NestedMap nestedMap = this.getSubMap(string2);
                nestedMap.setElement(string3, object);
            }
        }
    }

    public void decode(Map map) throws Exception {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string == null || string.equals(ENCODED)) continue;
            Object v = map.get(string);
            this.setElement(string, v);
        }
    }

    protected void encode(String string, NestedMap nestedMap) {
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            String string2 = (String)iterator.next();
            if (string2 == null) continue;
            if (string2.equals(LISTKEY)) {
                object = this.getSubList();
                int n = object.size();
                while (--n >= 0) {
                    Object e = object.get(n);
                    if (e == null) continue;
                    if (e instanceof NestedMap) {
                        ((NestedMap)e).encode(string + '_' + '.' + n + '.', nestedMap);
                        continue;
                    }
                    nestedMap.putMapObject(string + '_' + '.' + n, e);
                }
                continue;
            }
            object = this.getMapObject(string2);
            if (object == null) continue;
            if (object instanceof NestedMap) {
                ((NestedMap)object).encode(string + string2 + '.', nestedMap);
                continue;
            }
            nestedMap.putMapObject(string + string2, object);
        }
    }

    public Map exportParams() throws Exception {
        NestedMap nestedMap = new NestedMap();
        this.encode(LIST, nestedMap);
        return nestedMap;
    }

    public void importParams(String string) throws Exception {
        if (string != null) {
            string = string.replaceAll("[\\s]", LIST);
            HashMap hashMap = new HashMap(NestedMap.decodeMap(string, this._encoding));
            this.decode(hashMap);
        }
    }

    public void importParams(Map map) throws Exception {
        String string = (String)map.get(ENCODED);
        this.importParams(string);
        this.decode(map);
    }

    public Object getObject(Object object, Object object2) {
        if (object2 == CREATESUBMAP) {
            return new NestedMap();
        }
        if (object2 == CREATESUBLIST) {
            return new SparseList();
        }
        Object object3 = null;
        if (object2 != null) {
            String string = object2.toString();
            int n = 0;
            if (string.length() > 0) {
                n = string.charAt(0);
            }
            if (n == 64) {
                object3 = this.getElement(string.substring(1));
            } else if (n == 95) {
                String string2 = string.substring(1);
                Object object4 = this.getSpecial(string2);
                object3 = object4 != UNSUPPORTED ? object4 : this.getSecondary(string2);
            } else {
                if (n == 35) {
                    string = string.substring(1);
                }
                object3 = super.getObject(object, string);
            }
        }
        return object3;
    }

    protected List makeList(Collection collection) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public Object putObject(Object object, Object object2, Object object3) {
        if (object2 != null) {
            String string = object2.toString();
            int n = 0;
            if (string.length() > 0) {
                n = string.charAt(0);
            }
            if (n == 64) {
                this.setElement(string.substring(1), object3);
                return null;
            }
            if (n == 95) {
                if (ENCODED.equals(string = string.substring(1))) {
                    try {
                        this.importParams(object3.toString());
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                    return null;
                }
                if (SOURCE.equals(string)) {
                    try {
                        this.copyFromSource(object3);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                    return null;
                }
                if (PARAM.equals(string)) {
                    try {
                        this.importParams((Map)object3);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                    return null;
                }
                if (CLEAR.equals(string)) {
                    this.clear();
                    return null;
                }
                if (ENCODING.equals(string)) {
                    this._encoding = (String)object3;
                    return null;
                }
                if (!LIST.equals(string)) {
                    return this.putSecondary(string, object3);
                }
            } else if (n == 35) {
                object2 = string.substring(1);
            }
        }
        if (object3 == null) {
            object3 = REMOVE;
        }
        return super.putObject(object, object2, object3);
    }

    public static String encodeMap(Map map, String string, boolean bl) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        AbstractMap abstractMap = bl ? new TreeMap(map) : new HashMap(map);
        boolean bl2 = false;
        Iterator iterator = abstractMap.entrySet().iterator();
        while (iterator.hasNext()) {
            String string2;
            Map.Entry entry = iterator.next();
            Object k = entry.getKey();
            Object v = entry.getValue();
            String string3 = k != null ? k.toString() : LIST;
            String string4 = string2 = v != null ? v.toString() : LIST;
            if (bl2) {
                stringBuffer.append("&");
            }
            stringBuffer.append(NestedMap.encodeString(string3, string));
            stringBuffer.append("=");
            stringBuffer.append(NestedMap.encodeString(string2, string));
            bl2 = true;
        }
        return stringBuffer.toString();
    }

    public static NestedMap decodeMap(String string, String string2) throws Exception {
        NestedMap nestedMap = new NestedMap();
        String[] stringArray = string.split("&");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split("=", 2);
            if (stringArray2.length != 2) continue;
            String string3 = NestedMap.decodeString(stringArray2[0], string2);
            String string4 = NestedMap.decodeString(stringArray2[1], string2);
            if (LIST.equals(string3)) {
                string3 = null;
            }
            if (string3 == null || string4 == null) continue;
            nestedMap.setElement(string3, string4);
        }
        return nestedMap;
    }
}

