/*
 * Decompiled with CFR 0.152.
 */
package com.micronova.util;

import com.micronova.util.ByteArrayDataSource;
import com.micronova.util.NestedMap;
import com.micronova.util.NetUtil;
import com.micronova.util.StringUtil;
import com.micronova.util.TypeUtil;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.URLDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;

public class MailTransport {
    public static final String URL = "url";
    public static final String TO = "to";
    public static final String CC = "cc";
    public static final String BCC = "bcc";
    public static final String FROM = "from";
    public static final String REPLYTO = "replyTo";
    public static final String SUBJECT = "subject";
    public static final String TYPE = "type";
    public static final String SENTDATE = "sentDate";
    public static final String HEADER = "header";
    public static final String FILENAME = "fileName";
    public static final String DATASOURCE = "dataSource";
    public static final String CONTENT = "content";

    protected static InternetAddress makeAddress(Object object) throws Exception {
        if (object instanceof InternetAddress) {
            return (InternetAddress)object;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            String string = (String)map.get("address");
            String string2 = (String)map.get("personal");
            String string3 = (String)map.get("charset");
            return new InternetAddress(string, string2, string3);
        }
        return new InternetAddress((String)object);
    }

    protected static List getAddressList(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof NestedMap) {
            return ((NestedMap)object).getSubList(false);
        }
        List list = TypeUtil.isList(object);
        if (list == null) {
            list = StringUtil.split(object.toString(), ',');
        }
        return list;
    }

    protected static void setAddress(Message message, String string, Object object) throws Exception {
        List list = MailTransport.getAddressList(object);
        if (list != null) {
            int n = list.size();
            Address[] addressArray = null;
            if (n > 0) {
                addressArray = new Address[n];
                int n2 = n;
                while (--n2 >= 0) {
                    addressArray[n2] = MailTransport.makeAddress(list.get(n2));
                }
            }
            if (string == REPLYTO) {
                message.setReplyTo(addressArray);
            } else if (string == FROM) {
                message.setFrom(null);
                message.addFrom(addressArray);
            } else if (string == TO) {
                message.setRecipients(Message.RecipientType.TO, addressArray);
            } else if (string == CC) {
                message.setRecipients(Message.RecipientType.CC, addressArray);
            } else if (string == BCC) {
                message.setRecipients(Message.RecipientType.BCC, addressArray);
            }
        }
    }

    public static void setReplyTo(MimeMessage mimeMessage, String string, Object object) throws Exception {
        List list = MailTransport.getAddressList(object);
        if (list != null) {
            int n = list.size();
            Address[] addressArray = new Address[n];
            int n2 = n;
            while (--n2 >= 0) {
                Object e = list.get(n2);
                InternetAddress internetAddress = MailTransport.makeAddress(e);
                addressArray[n2] = internetAddress;
            }
            mimeMessage.setReplyTo(addressArray);
        }
    }

    public static void setSentDate(MimeMessage mimeMessage, Object object) throws Exception {
        if (object != null) {
            if (object instanceof Date) {
                mimeMessage.setSentDate((Date)object);
            } else {
                Long l = TypeUtil.isLong(object);
                if (l != null) {
                    mimeMessage.setSentDate(new Date(l));
                }
            }
        }
    }

    public static void buildPart(MimePart mimePart, NestedMap nestedMap) throws Exception {
        Object object;
        String string;
        Object object2;
        Object object3;
        Object object4;
        NestedMap nestedMap2 = (NestedMap)nestedMap.get(HEADER);
        if (nestedMap2 != null) {
            object4 = nestedMap2.getSubList(false);
            if (object4 != null) {
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    object2 = object3.next();
                    if (object2 instanceof Map) {
                        string = (String)((Map)object2).get("name");
                        object = (String)((Map)object2).get("value");
                        if (string == null || object == null) continue;
                        mimePart.addHeader(string, (String)object);
                        continue;
                    }
                    if (!(object2 instanceof String)) continue;
                    mimePart.addHeaderLine(object2.toString());
                }
            }
            object3 = nestedMap2.entrySet().iterator();
            while (object3.hasNext()) {
                object2 = object3.next();
                string = object2.getKey();
                object = object2.getValue();
                if (object == object4) continue;
                mimePart.setHeader(string.toString(), object.toString());
            }
        }
        object4 = nestedMap.get(TYPE);
        object3 = nestedMap.getSubList(false);
        if (object3 == null || object3.isEmpty()) {
            Object object5;
            object2 = TypeUtil.isString(nestedMap.get(CONTENT));
            if (object2 == null) {
                object2 = "";
            }
            string = null;
            if (object4 != null) {
                if (object4 instanceof Map) {
                    string = NetUtil.encodeMime((Map)object4);
                } else if (object4 instanceof String) {
                    string = (String)object4;
                }
            }
            if (object2 != null) {
                object = string != null ? string : "text/plain; charset=iso-8859-1";
                object5 = nestedMap.getString(FILENAME);
                ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource((String)object, (String)object5, ((String)object2).getBytes("iso-8859-1"));
                mimePart.setDataHandler(new DataHandler((DataSource)byteArrayDataSource));
            }
            if ((object = nestedMap.get(DATASOURCE)) != null) {
                if (object instanceof DataSource) {
                    mimePart.setDataHandler(new DataHandler((DataSource)object));
                } else {
                    object5 = new URL(object.toString());
                    mimePart.setDataHandler(new DataHandler((DataSource)new URLDataSource((URL)object5)));
                    mimePart.setFileName(nestedMap.getString(FILENAME, ((URL)object5).getFile().replaceAll("/?[^/]*/", "")));
                }
                if (string != null) {
                    mimePart.setHeader("Content-Type", string);
                }
            }
        } else {
            object2 = new MimeMultipart();
            string = "related";
            string = object4 instanceof Map ? (String)((Map)object4).get("subtype") : (String)object4;
            object2.setSubType(string);
            object = object3.iterator();
            while (object.hasNext()) {
                NestedMap nestedMap3 = (NestedMap)object.next();
                MimeBodyPart mimeBodyPart = new MimeBodyPart();
                MailTransport.buildPart((MimePart)mimeBodyPart, nestedMap3);
                object2.addBodyPart((BodyPart)mimeBodyPart);
            }
            mimePart.setContent((Multipart)object2);
        }
    }

    public static void send(Session session, Transport transport, NestedMap nestedMap) throws Exception {
        MimeMessage mimeMessage = new MimeMessage(session);
        MailTransport.buildPart((MimePart)mimeMessage, nestedMap);
        String string = nestedMap.getString(SUBJECT, "");
        mimeMessage.setSubject(string);
        MailTransport.setAddress((Message)mimeMessage, TO, nestedMap.get(TO));
        MailTransport.setAddress((Message)mimeMessage, CC, nestedMap.get(CC));
        MailTransport.setAddress((Message)mimeMessage, BCC, nestedMap.get(BCC));
        MailTransport.setAddress((Message)mimeMessage, REPLYTO, nestedMap.get(REPLYTO));
        MailTransport.setAddress((Message)mimeMessage, FROM, nestedMap.get(FROM));
        MailTransport.setSentDate(mimeMessage, nestedMap.get(SENTDATE));
        Transport.send((Message)mimeMessage);
    }
}

