/*
 * Decompiled with CFR 0.152.
 */
package com.micronova.util;

import com.micronova.util.NestedMap;
import com.micronova.util.NetUtil;
import com.micronova.util.TypeUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MethodNotSupportedException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class MailFolder {
    public static final String HEADER = "header";
    public static final String HEADERMAP = "headerMap";
    public static final String CONTENT = "content";
    public static final String MAXCONTENTSIZE = "maxContentSize";
    public static final String MAXPARTSIZE = "maxPartSize";
    public static final String CONTENTASSTRING = "contentAsString";
    public static final String RECEIVEDDATE = "receivedDate";
    public static final String MESSAGENUMBER = "messageNumber";
    public static final String SUBJECT = "subject";
    public static final String EXCEPTION = "exception";
    public static final String SENTDATE = "sentDate";
    public static final String TO = "to";
    public static final String CC = "cc";
    public static final String BCC = "bcc";
    public static final String REPLYTO = "replyTo";
    public static final String FROM = "from";
    public static final String FLAGS = "flags";
    public static final String NAME = "name";
    public static final String VALUE = "value";
    public static final String FULLNAME = "fullName";
    public static final String URLNAME = "urlName";
    public static final String MESSAGECOUNT = "messageCount";
    public static final String ADDRESS = "address";
    public static final String PERSONAL = "personal";
    public static final String DESCRIPTION = "description";
    public static final String DISPOSITION = "disposition";
    public static final String FILENAME = "fileName";
    public static final String LINECOUNT = "lineCount";
    public static final String SIZE = "size";
    public static final String CONTENTTYPE = "contentType";
    public static final String TYPE = "type";
    public static final String PARTNAME = "partName";
    public static final String PART = "_part";
    public static final String FOLDER = "_folder";
    public static final int[] ALLMESSAGES = new int[0];

    private static void setAddress(NestedMap nestedMap, InternetAddress internetAddress) {
        nestedMap.put(ADDRESS, internetAddress.getAddress());
        nestedMap.put(PERSONAL, internetAddress.getPersonal());
    }

    private static void setAddresses(NestedMap nestedMap, String string, Address[] addressArray) throws Exception {
        if (addressArray != null) {
            NestedMap nestedMap2 = new NestedMap();
            nestedMap.put(string, nestedMap2);
            List list = nestedMap2.getSubList();
            for (int i = 0; i < addressArray.length; ++i) {
                InternetAddress internetAddress = (InternetAddress)addressArray[i];
                if (internetAddress == null) continue;
                list.add(internetAddress);
            }
        }
    }

    public static String makePartMap(NestedMap nestedMap, Part part, Map map) throws Exception {
        String string = null;
        nestedMap.put(PART, part);
        nestedMap.put(DESCRIPTION, part.getDescription());
        nestedMap.put(FILENAME, part.getFileName());
        nestedMap.put(LINECOUNT, new Long(part.getLineCount()));
        nestedMap.put(SIZE, new Long(part.getSize()));
        nestedMap.put(CONTENTTYPE, part.getContentType());
        nestedMap.put(TYPE, NetUtil.parseMime(part.getContentType()));
        String[] stringArray = part.getHeader("Content-Disposition");
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                NestedMap nestedMap2 = (NestedMap)NetUtil.parseMime(stringArray[i]);
                nestedMap.put(DISPOSITION, nestedMap2);
                string = (String)nestedMap2.get("@parameter.name");
            }
        }
        if (map != null) {
            String string2;
            Object object;
            Object object2;
            Enumeration enumeration;
            Object object3;
            if (!TypeUtil.isFalse(map.get(HEADER))) {
                NestedMap nestedMap3 = new NestedMap();
                nestedMap.put(HEADER, nestedMap3);
                boolean bl = !TypeUtil.isFalse(map.get(HEADERMAP));
                object3 = nestedMap3.getSubList();
                enumeration = part.getAllHeaders();
                while (enumeration.hasMoreElements()) {
                    object2 = (Header)enumeration.nextElement();
                    NestedMap nestedMap4 = new NestedMap();
                    object = object2.getName();
                    string2 = object2.getValue();
                    nestedMap4.put(NAME, object);
                    nestedMap4.put(VALUE, string2);
                    object3.add(nestedMap4);
                    if (!bl || object == null || string2 == null) continue;
                    nestedMap3.put(object, string2);
                }
            }
            if (!TypeUtil.isFalse(map.get(CONTENT))) {
                Integer n = TypeUtil.isInteger(map.get(MAXPARTSIZE));
                int n2 = 0;
                if (n != null) {
                    n2 = n;
                }
                if (n2 <= 0 || part.getSize() < n2) {
                    object3 = part.getContent();
                    if (object3 instanceof Multipart) {
                        enumeration = (Multipart)object3;
                        object2 = nestedMap.getSubList();
                        for (int i = 0; i < enumeration.getCount(); ++i) {
                            object = new NestedMap();
                            string2 = MailFolder.makePartMap((NestedMap)object, (Part)enumeration.getBodyPart(i), map);
                            object2.add(object);
                            if (string2 == null) continue;
                            NestedMap nestedMap5 = nestedMap.getSubMap(PARTNAME);
                            nestedMap5.put(string2, object);
                        }
                    } else {
                        int n3 = part.getSize();
                        object2 = TypeUtil.isInteger(map.get(MAXCONTENTSIZE));
                        int n4 = 0;
                        if (object2 != null) {
                            n4 = (Integer)object2;
                        }
                        if ((n4 <= 0 || n3 < n4) && n3 > 0) {
                            if (TypeUtil.isTrue(map.get(CONTENTASSTRING))) {
                                object3 = TypeUtil.isString(object3);
                            }
                            nestedMap.put(CONTENT, object3);
                        }
                    }
                }
            }
        }
        return string;
    }

    public static Map readMessages(Folder folder, int[] nArray, Map map) throws Exception {
        Message[] messageArray = null;
        if (nArray == ALLMESSAGES) {
            messageArray = folder.getMessages();
        } else if (nArray != null) {
            messageArray = folder.getMessages(nArray);
        }
        return MailFolder.makeFolderMap(folder, messageArray, map);
    }

    private static Map makeMessageMap(Message message, Map map) {
        NestedMap nestedMap = new NestedMap();
        int n = message.getMessageNumber();
        nestedMap.put(MESSAGENUMBER, new Long(n));
        try {
            if (map != null) {
                Date date;
                Date date2;
                String string = message.getSubject();
                if (string != null) {
                    nestedMap.put(SUBJECT, string);
                }
                if ((date2 = message.getSentDate()) != null) {
                    nestedMap.put(SENTDATE, date2);
                }
                if ((date = message.getReceivedDate()) != null) {
                    nestedMap.put(RECEIVEDDATE, date);
                }
                MailFolder.setAddresses(nestedMap, TO, message.getRecipients(Message.RecipientType.TO));
                MailFolder.setAddresses(nestedMap, CC, message.getRecipients(Message.RecipientType.CC));
                MailFolder.setAddresses(nestedMap, BCC, message.getRecipients(Message.RecipientType.BCC));
                MailFolder.setAddresses(nestedMap, REPLYTO, message.getReplyTo());
                MailFolder.setAddresses(nestedMap, FROM, message.getFrom());
                MailFolder.makePartMap(nestedMap, (Part)message, map);
            }
        }
        catch (Exception exception) {
            nestedMap.put(EXCEPTION, exception);
        }
        return nestedMap;
    }

    private static Map makeFolderMap(Folder folder, Message[] messageArray, Map map) throws Exception {
        NestedMap nestedMap = new NestedMap();
        nestedMap.put(FOLDER, folder);
        nestedMap.put(NAME, folder.getName());
        nestedMap.put(FULLNAME, folder.getFullName());
        nestedMap.put(URLNAME, folder.getURLName());
        nestedMap.put(MESSAGECOUNT, new Integer(folder.getMessageCount()));
        if (messageArray != null) {
            List list = nestedMap.getSubList();
            for (int i = 0; i < messageArray.length; ++i) {
                Message message = messageArray[i];
                Map map2 = MailFolder.makeMessageMap(message, map);
                list.add(map2);
            }
        }
        return nestedMap;
    }

    public static void deleteMessages(Folder folder, int[] nArray) throws Exception {
        if (nArray != null) {
            Message[] messageArray = folder.getMessages(nArray);
            int n = messageArray.length;
            while (--n >= 0) {
                Message message = messageArray[n];
                message.setFlag(Flags.Flag.DELETED, true);
            }
            try {
                folder.expunge();
            }
            catch (MethodNotSupportedException methodNotSupportedException) {
                // empty catch block
            }
        }
    }

    public static NestedMap decodeMultipart(InputStream inputStream, String string, NestedMap nestedMap) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Content-Type:" + string + "\r\n\r\n");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(stringBuffer.toString().getBytes("ISO-8859-1"));
        SequenceInputStream sequenceInputStream = new SequenceInputStream(byteArrayInputStream, inputStream);
        MimeMessage mimeMessage = new MimeMessage(null, (InputStream)sequenceInputStream);
        NestedMap nestedMap2 = new NestedMap();
        MailFolder.makePartMap(nestedMap2, (Part)mimeMessage, new NestedMap((Object)nestedMap));
        return nestedMap2;
    }
}

