/*
 * Decompiled with CFR 0.152.
 */
package com.micronova.util;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public class IOUtil {
    public static final int DEFAULTBUFFERSIZE = 2048;

    public static final void tryClose(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final void tryClose(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final void tryClose(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final void tryClose(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final int copy(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws Exception {
        int n;
        int n2 = 0;
        int n3 = byArray.length;
        while ((n = inputStream.read(byArray, 0, n3)) > 0) {
            outputStream.write(byArray, 0, n);
            n2 += n;
        }
        return n2;
    }

    public static final int copy(Reader reader, Writer writer, char[] cArray) throws Exception {
        int n;
        int n2 = 0;
        int n3 = cArray.length;
        while ((n = reader.read(cArray, 0, n3)) > 0) {
            writer.write(cArray, 0, n);
            n2 += n;
        }
        return n2;
    }

    public static final int copy(InputStream inputStream, OutputStream outputStream) throws Exception {
        return IOUtil.copy(inputStream, outputStream, new byte[2048]);
    }

    public static final int copy(Reader reader, Writer writer) throws Exception {
        return IOUtil.copy(reader, writer, new char[2048]);
    }

    public static final byte[] readAll(InputStream inputStream, byte[] byArray, int n) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        IOUtil.copy(inputStream, byteArrayOutputStream, byArray);
        return byteArrayOutputStream.toByteArray();
    }

    public static final byte[] readAll(InputStream inputStream, int n) throws Exception {
        return IOUtil.readAll(inputStream, new byte[2048], n);
    }

    public static final byte[] readAll(InputStream inputStream) throws Exception {
        return IOUtil.readAll(inputStream, 2048);
    }

    public static final char[] readAll(Reader reader, char[] cArray, int n) throws Exception {
        CharArrayWriter charArrayWriter = new CharArrayWriter(n);
        IOUtil.copy(reader, charArrayWriter, cArray);
        return charArrayWriter.toCharArray();
    }

    public static final char[] readAll(Reader reader, int n) throws Exception {
        return IOUtil.readAll(reader, new char[2048], n);
    }

    public static final char[] readAll(Reader reader) throws Exception {
        return IOUtil.readAll(reader, 2048);
    }
}

