/*
 * Decompiled with CFR 0.152.
 */
package com.micronova.jsp.tag;

import com.micronova.jsp.tag.MapTag;
import com.micronova.util.MailTransport;
import com.micronova.util.NestedMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.URLName;

public class MailTag
extends MapTag {
    protected String _url;
    protected Properties _properties;
    protected Transport _transport;
    protected Session _session;

    public void init() {
        super.init();
        this._url = null;
        this._transport = null;
        this._export = null;
        this._properties = null;
        this._session = null;
    }

    public Transport getTransport() {
        return this._transport;
    }

    public Session getSession() {
        return this._session;
    }

    public MailTag getTransportSource() {
        MailTag mailTag = null;
        if (this._transport != null) {
            return this;
        }
        String string = this._url;
        if (string == null) {
            mailTag = (MailTag)((Object)this.getAncestorTag("com.micronova.jsp.tag.MailTag"));
            if (mailTag != null) {
                return mailTag.getTransportSource();
            }
        } else {
            try {
                Properties properties = this._properties;
                if (properties == null) {
                    properties = new Properties();
                }
                URLName uRLName = new URLName(string);
                String string2 = uRLName.getProtocol();
                String string3 = uRLName.getHost();
                int n = uRLName.getPort();
                if (string2 != null) {
                    properties.setProperty("mail.transport.protocol", string2);
                    if (string3 != null) {
                        properties.setProperty("mail." + string2 + ".host", string3);
                        properties.setProperty("mail.host", string3);
                    }
                    if (n >= 0) {
                        properties.setProperty("mail." + string2 + ".port", "" + n);
                    }
                }
                Session session = Session.getInstance((Properties)properties);
                Transport transport = session.getTransport(uRLName);
                transport.connect();
                this._session = session;
                this._transport = transport;
                mailTag = this;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return mailTag;
    }

    public void closeTransport() {
        Transport transport = this._transport;
        if (transport != null) {
            this._transport = null;
            try {
                transport.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected void cleanup() {
        this.closeTransport();
        super.cleanup();
    }

    public void setUrl(Object object) throws Exception {
        this._url = (String)this.evaluateAttribute("url", object, String.class);
        this.closeTransport();
    }

    public void setProperties(Object object) throws Exception {
        NestedMap nestedMap = (NestedMap)new NestedMap(object).get("__param");
        Properties properties = new Properties();
        Iterator iterator = nestedMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            properties.put(entry.getKey().toString(), entry.getValue().toString());
        }
        this._properties = properties;
    }

    public Object processValue(Object object) throws Exception {
        NestedMap nestedMap;
        if (object != null && !(nestedMap = (NestedMap)object).isEmpty()) {
            String string = nestedMap.getString("from");
            MailTag mailTag = this.getTransportSource();
            Transport transport = mailTag.getTransport();
            Session session = mailTag.getSession();
            MailTransport.send(session, transport, nestedMap);
        }
        return object;
    }
}

