/*
 * Decompiled with CFR 0.152.
 */
package com.micronova.util.codec;

import com.micronova.util.Cache;
import com.micronova.util.NestedMap;
import com.micronova.util.TimedCache;
import com.micronova.util.TypeUtil;
import com.micronova.util.codec.Codec;
import com.micronova.util.codec.CodecThread;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

public class CodecSystem
extends Codec {
    private static int _uniqueId = 0;

    public static Object sleep(Object object) throws Exception {
        return CodecThread.sleep(object);
    }

    public static Object yield() {
        return CodecThread.yield();
    }

    public static Object invoke(Object object) throws Exception {
        NestedMap nestedMap = new NestedMap(object);
        return TypeUtil.invoke(nestedMap);
    }

    public static Object invoke(Object object, Object object2) throws Exception {
        NestedMap nestedMap = new NestedMap(object2);
        return TypeUtil.invoke(object, nestedMap);
    }

    public static synchronized Object uniqueId() throws Exception {
        return new Integer(_uniqueId++);
    }

    public static Object runtime(Object object) {
        Boolean bl;
        Boolean bl2;
        Integer n;
        Integer n2;
        NestedMap nestedMap = TypeUtil.isNestedMap(object);
        Runtime runtime = Runtime.getRuntime();
        if (nestedMap.get("gc") != null) {
            runtime.gc();
        }
        if (nestedMap.get("runFinalization") != null) {
            runtime.runFinalization();
        }
        if ((n2 = TypeUtil.isInteger(nestedMap.get("halt"))) != null) {
            runtime.halt(n2);
        }
        if ((n = TypeUtil.isInteger(nestedMap.get("exit"))) != null) {
            runtime.exit(n);
        }
        if ((bl2 = TypeUtil.isBoolean(nestedMap.get("traceInstruactions"))) != null) {
            runtime.traceInstructions(bl2);
        }
        if ((bl = TypeUtil.isBoolean(nestedMap.get("traceMethodCalls"))) != null) {
            runtime.traceMethodCalls(bl);
        }
        nestedMap.put("freeMemory", new Long(runtime.freeMemory()));
        nestedMap.put("maxMemory", new Long(runtime.maxMemory()));
        nestedMap.put("totalMemory", new Long(runtime.totalMemory()));
        nestedMap.put("availableProcessors", new Long(runtime.availableProcessors()));
        return nestedMap;
    }

    public static Object runtime() throws Exception {
        return CodecSystem.runtime(null);
    }

    public static Object setProperty(Object object, Object object2) throws Exception {
        return System.setProperty(object.toString(), object2.toString());
    }

    public static Object setProperties(Object object) throws Exception {
        if (object != null) {
            NestedMap nestedMap = TypeUtil.isNestedMap(object);
            Iterator iterator = nestedMap.exportParams().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                System.setProperty(entry.getKey().toString(), entry.getValue().toString());
            }
        }
        return object;
    }

    public static Object getProperty(Object object) throws Exception {
        return System.getProperty(object.toString());
    }

    public static Object getProperties() throws Exception {
        return TypeUtil.isNestedMap(System.getProperties()).exportParams();
    }

    public static Object currentTimeMillis() throws Exception {
        return new Long(System.currentTimeMillis());
    }

    public static Object currentTime() throws Exception {
        return new Date(System.currentTimeMillis());
    }

    public static Object createCache(Object object) throws Exception {
        NestedMap nestedMap = new NestedMap(object);
        int n = nestedMap.getInt("initialCapacity", 16);
        float f = nestedMap.getFloat("loadFactor", 0.75f);
        String string = nestedMap.getString("type", "LRU");
        int n2 = nestedMap.getInt("maxSize", 16);
        long l = nestedMap.getLong("lifespan", -1L);
        if (l < 0L) {
            return new Cache(n, f, string.equals("LRU"), n2);
        }
        return new TimedCache(n, f, string.equals("LRU"), n2, l);
    }
}

