/*
 * Decompiled with CFR 0.152.
 */
package com.micronova.util;

import com.micronova.util.IOUtil;
import com.micronova.util.NestedMap;
import com.micronova.util.SparseObject;
import com.micronova.util.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.mail.internet.MimeMessage;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;

public class TypeUtil {
    private static final Map PRIMITIVETYPE = new HashMap();
    public static final String OBJECT = "object";
    public static final String CLASS = "class";
    public static final String METHOD = "method";
    public static final String TYPE = "type";
    public static final String VALUE = "value";
    public static final String OBJECTPROPERTY = "objectProperty";
    static /* synthetic */ Class class$java$lang$Object;

    public static final Double isDouble(Object object) {
        if (object != null) {
            if (object instanceof Double) {
                return (Double)object;
            }
            try {
                return Double.valueOf(object.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static final Float isFloat(Object object) {
        if (object != null) {
            if (object instanceof Float) {
                return (Float)object;
            }
            try {
                return Float.valueOf(object.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static final Long isLong(Object object) {
        if (object != null) {
            if (object instanceof Long) {
                return (Long)object;
            }
            try {
                return new Long(TypeUtil.isDouble(object).longValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static final Integer isInteger(Object object) {
        if (object != null) {
            if (object instanceof Integer) {
                return (Integer)object;
            }
            try {
                return new Integer(TypeUtil.isLong(object).intValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static final Short isShort(Object object) {
        if (object != null) {
            if (object instanceof Short) {
                return (Short)object;
            }
            try {
                return new Short(TypeUtil.isLong(object).shortValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static final Byte isByte(Object object) {
        if (object != null) {
            if (object instanceof Byte) {
                return (Byte)object;
            }
            try {
                return new Byte(TypeUtil.isLong(object).byteValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static final String isString(Object object) {
        if (object != null) {
            try {
                if (object instanceof InputStream) {
                    return StringUtil.toBinaryString(IOUtil.readAll((InputStream)object));
                }
                if (object instanceof Reader) {
                    return new String(IOUtil.readAll((Reader)object));
                }
                if (object instanceof Node) {
                    Node node = (Node)object;
                    Transformer transformer = TransformerFactory.newInstance().newTransformer();
                    transformer.setOutputProperty("omit-xml-declaration", "yes");
                    StringWriter stringWriter = new StringWriter();
                    DOMSource dOMSource = new DOMSource(node);
                    StreamResult streamResult = new StreamResult(stringWriter);
                    transformer.transform(dOMSource, streamResult);
                    return stringWriter.toString();
                }
                if (object instanceof MimeMessage) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ((MimeMessage)object).writeTo((OutputStream)byteArrayOutputStream);
                    return byteArrayOutputStream.toString();
                }
                return object.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static final Boolean isBoolean(Object object) {
        if (object != null) {
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            try {
                return Boolean.valueOf(object.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static final boolean isTrue(Object object) {
        Boolean bl = TypeUtil.isBoolean(object);
        return bl != null && bl != false;
    }

    public static final boolean isFalse(Object object) {
        Boolean bl = TypeUtil.isBoolean(object);
        return bl != null && bl == false;
    }

    public static final Character isCharacter(Object object) {
        if (object != null) {
            if (object instanceof Character) {
                return (Character)object;
            }
            String string = object.toString();
            if (string.length() > 0) {
                return new Character(string.charAt(0));
            }
        }
        return null;
    }

    public static final Object[] isArray(Object object) {
        if (object != null) {
            if (object instanceof Object[]) {
                return (Object[])object;
            }
            if (object instanceof Collection) {
                return ((Collection)object).toArray();
            }
            if (object.getClass().isArray()) {
                int n = Array.getLength(object);
                Object[] objectArray = new Object[n];
                while (--n >= 0) {
                    objectArray[n] = Array.get(object, n);
                }
                return objectArray;
            }
        }
        return null;
    }

    public static final String[] isStringArray(Object object) {
        String[] stringArray;
        block2: {
            block4: {
                block3: {
                    stringArray = null;
                    if (object == null) break block2;
                    if (!(object instanceof String[])) break block3;
                    stringArray = (String[])object;
                    break block2;
                }
                if (!(object instanceof Object[])) break block4;
                Object[] objectArray = (Object[])object;
                int n = objectArray.length;
                stringArray = new String[n];
                int n2 = n;
                while (--n2 >= 0) {
                    Object object2 = objectArray[n2];
                    stringArray[n2] = object2 != null ? object2.toString() : null;
                }
                break block2;
            }
            if (!(object instanceof List)) break block2;
            List list = (List)object;
            int n = list.size();
            stringArray = new String[n];
            int n3 = n;
            while (--n3 >= 0) {
                Object e = list.get(n3);
                stringArray[n3] = e != null ? e.toString() : null;
            }
        }
        return stringArray;
    }

    public static final List isList(Object object) {
        if (object != null) {
            if (object instanceof List) {
                return (List)object;
            }
            Object[] objectArray = TypeUtil.isArray(object);
            if (objectArray != null) {
                return Arrays.asList(objectArray);
            }
        }
        return null;
    }

    public static final List isStringList(Object object, char c, char c2) {
        List list = null;
        if (object != null) {
            list = object instanceof List ? (List)object : StringUtil.split(object.toString(), c, c2);
        }
        return list;
    }

    public static final Collection isCollection(Object object) {
        if (object instanceof Collection) {
            return (Collection)object;
        }
        return TypeUtil.isList(object);
    }

    public static final URI isURI(Object object) {
        URI uRI = null;
        if (object != null) {
            try {
                uRI = object instanceof URI ? (URI)object : new URI(object.toString());
            }
            catch (Exception exception) {
                uRI = null;
            }
        }
        return uRI;
    }

    public static final URL isURL(Object object, URL uRL) {
        URL uRL2 = null;
        if (object != null) {
            try {
                uRL2 = new URL(uRL, object.toString());
            }
            catch (Exception exception) {
                uRL2 = null;
            }
        }
        return uRL2;
    }

    public static final URL isURL(Object object) {
        URL uRL = null;
        if (object != null) {
            try {
                uRL = new URL(object.toString());
            }
            catch (Exception exception) {
                uRL = null;
            }
        }
        return uRL;
    }

    public static final File isFile(Object object, Object object2) {
        File file = null;
        if (object != null) {
            try {
                file = object instanceof URI ? new File((URI)object) : (object instanceof File ? (File)object : new File(object.toString()));
                if (object2 != null) {
                    file = new File(TypeUtil.isFile(object2), file.toString());
                }
            }
            catch (Exception exception) {
                file = null;
            }
        }
        return file;
    }

    public static final File isFile(Object object) {
        return TypeUtil.isFile(object, null);
    }

    public static final NestedMap isNestedMap(Object object) {
        if (object instanceof NestedMap) {
            return (NestedMap)object;
        }
        try {
            return new NestedMap(object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static final Locale isLocale(Object object) {
        if (object instanceof Locale) {
            return (Locale)object;
        }
        NestedMap nestedMap = TypeUtil.isNestedMap(object);
        String string = nestedMap.getString("language", "");
        String string2 = nestedMap.getString("country", "");
        String string3 = nestedMap.getString("variant", "");
        return new Locale(string, string2, string3);
    }

    public static final TimeZone isTimeZone(Object object) {
        if (object instanceof TimeZone) {
            return (TimeZone)object;
        }
        NestedMap nestedMap = TypeUtil.isNestedMap(object);
        String string = nestedMap.getString("id", "");
        if (string == null) {
            return TimeZone.getDefault();
        }
        return TimeZone.getTimeZone(string);
    }

    public static final Calendar isCalendar(Object object, String string, Locale locale) throws Exception {
        Calendar calendar = null;
        if (object != null) {
            if (object instanceof Calendar) {
                calendar = (Calendar)object;
            } else {
                if (locale == null) {
                    locale = Locale.getDefault();
                }
                calendar = Calendar.getInstance(locale);
                Date date = TypeUtil.isDate(object, string, locale);
                calendar.setTime(date);
            }
        }
        return calendar;
    }

    public static final Date isDate(Object object, String string, Locale locale) throws Exception {
        Date date = null;
        if (object != null) {
            if (object instanceof Date) {
                date = (Date)object;
            } else if (object instanceof Calendar) {
                date = ((Calendar)object).getTime();
            } else if (object instanceof Number) {
                Long l = TypeUtil.isLong(object);
                date = new Date();
                date.setTime(l);
            } else {
                SimpleDateFormat simpleDateFormat = string == null ? new SimpleDateFormat() : new SimpleDateFormat(string, locale);
                ParsePosition parsePosition = new ParsePosition(0);
                String string2 = object.toString();
                date = simpleDateFormat.parse(string2, parsePosition);
                if (parsePosition.getIndex() != string2.length()) {
                    date = null;
                }
            }
        }
        return date;
    }

    public static final Number isNumber(Object object, String string, Locale locale) throws Exception {
        Number number = null;
        if (object != null) {
            if (object instanceof Number) {
                number = (Number)object;
            } else {
                DecimalFormat decimalFormat = string == null ? new DecimalFormat() : new DecimalFormat(string, new DecimalFormatSymbols(locale));
                ParsePosition parsePosition = new ParsePosition(0);
                String string2 = object.toString();
                number = decimalFormat.parse(string2, parsePosition);
                if (parsePosition.getIndex() != string2.length()) {
                    number = null;
                }
            }
        }
        return number;
    }

    public static final int length(Object object) {
        if (object != null) {
            if (object instanceof String) {
                return object.toString().length();
            }
            if (object instanceof Collection) {
                return ((Collection)object).size();
            }
            if (object.getClass().isArray()) {
                return Array.getLength(object);
            }
        }
        return -1;
    }

    public static final int size(Object object) {
        return TypeUtil.length(object);
    }

    public static final int getActualSize(Object object) {
        if (object instanceof SparseObject) {
            return ((SparseObject)object).getActualSize();
        }
        return TypeUtil.size(object);
    }

    public static final boolean isEmptyString(Object object) {
        return object == null || "".equals(object);
    }

    public static final boolean isEmpty(Object object) {
        if (TypeUtil.isEmptyString(object)) {
            return true;
        }
        if (object instanceof Collection) {
            return ((Collection)object).isEmpty();
        }
        if (object.getClass().isArray()) {
            return Array.getLength(object) == 0;
        }
        return false;
    }

    public static final Object isClass(Object object, Class clazz) {
        if (clazz.isInstance(object)) {
            return object;
        }
        try {
            if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                return Boolean.valueOf(object.toString());
            }
            if (clazz == Byte.TYPE || clazz == Byte.class) {
                return Byte.valueOf(object.toString());
            }
            if (clazz == Short.TYPE || clazz == Short.class) {
                return Short.valueOf(object.toString());
            }
            if (clazz == Integer.TYPE || clazz == Integer.class) {
                return Integer.valueOf(object.toString());
            }
            if (clazz == Long.TYPE || clazz == Long.class) {
                return Long.valueOf(object.toString());
            }
            if (clazz == Float.TYPE || clazz == Float.class) {
                return Float.valueOf(object.toString());
            }
            if (clazz == Double.TYPE || clazz == Double.class) {
                return Double.valueOf(object.toString());
            }
            if (clazz == Character.TYPE || clazz == Character.class) {
                return new Character(object.toString().charAt(0));
            }
            if (clazz == String.class) {
                return object.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static final Pattern isPattern(Object object) {
        Pattern pattern = null;
        try {
            if (object instanceof Pattern) {
                pattern = (Pattern)object;
            } else if (!TypeUtil.isEmptyString(object)) {
                pattern = Pattern.compile(object.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pattern;
    }

    public static final Class forName(String string, String string2) throws Exception {
        Class<?> clazz;
        int n;
        int n2 = 0;
        while ((n = string.lastIndexOf("[]")) != -1) {
            ++n2;
            string = string.substring(0, n);
        }
        Class<?> clazz2 = null;
        clazz2 = string.indexOf(46) >= 0 ? Class.forName(string) : ((clazz = (Class<?>)PRIMITIVETYPE.get(string)) != null ? clazz : Class.forName(string2 + string));
        if (n2 == 0) {
            return clazz2;
        }
        return Array.newInstance(clazz2, new int[n2]).getClass();
    }

    public static final Class forName(String string) throws Exception {
        return TypeUtil.forName(string, "java.lang.");
    }

    public static final Object invoke(Object object, Class clazz, String string, Class[] classArray, Object[] objectArray) throws Exception {
        if (clazz == null) {
            clazz = object.getClass();
        }
        if ("*".equals(string)) {
            Constructor<?> constructor = clazz.getConstructor(classArray);
            return constructor.newInstance(objectArray);
        }
        if (string.startsWith(".")) {
            Field field = clazz.getDeclaredField(string.substring(1));
            return field.get(object);
        }
        Method method = clazz.getMethod(string, classArray);
        return method.invoke(object, objectArray);
    }

    public static Object invoke(NestedMap nestedMap) throws Exception {
        Object object;
        Object var1_1 = null;
        Object object2 = nestedMap.get(OBJECT);
        List list = nestedMap.getSubList(false);
        Class[] classArray = null;
        Object[] objectArray = null;
        if (list != null) {
            int n = list.size();
            classArray = new Class[n];
            objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                Class<?> clazz;
                object = list.get(i);
                Object object3 = null;
                Object object4 = object;
                if (object instanceof Map) {
                    clazz = (Map)object;
                    object3 = clazz.get(TYPE);
                    object4 = clazz.get(VALUE);
                }
                Class<?> clazz2 = clazz = class$java$lang$Object == null ? TypeUtil.class$("java.lang.Object") : class$java$lang$Object;
                if (object3 instanceof String) {
                    clazz = TypeUtil.forName(object3.toString());
                } else if (object3 instanceof Class) {
                    clazz = (Class)object3;
                } else if (object3 != null) {
                    clazz = object3.getClass();
                } else if (object4 != null) {
                    clazz = object4.getClass();
                }
                classArray[i] = clazz;
                objectArray[i] = TypeUtil.isClass(object4, clazz);
            }
        }
        String string = (String)nestedMap.get(METHOD);
        Class clazz = null;
        object = nestedMap.get(CLASS);
        if (object != null) {
            clazz = object instanceof Class ? (Class)object : TypeUtil.forName(object.toString());
        }
        return TypeUtil.invoke(object2, clazz, string, classArray, objectArray);
    }

    public static Object invoke(Object object, NestedMap nestedMap, String string) throws Exception {
        nestedMap.put(string, object);
        return TypeUtil.invoke(nestedMap);
    }

    public static Object invoke(Object object, NestedMap nestedMap) throws Exception {
        return TypeUtil.invoke(object, nestedMap, nestedMap.getString(OBJECTPROPERTY, OBJECT));
    }

    public static List subList(List list, int n, int n2) {
        if (list != null) {
            int n3 = list.size();
            if (n < 0) {
                n = n3 + n;
            }
            if (n2 < 0) {
                n2 = n3 + n2;
            }
            if (n < 0) {
                n = 0;
            }
            if (n2 > n3) {
                n2 = n3;
            }
            list = n2 <= n ? new ArrayList() : list.subList(n, n2);
        }
        return list;
    }

    static {
        PRIMITIVETYPE.put("boolean", Boolean.TYPE);
        PRIMITIVETYPE.put("char", Character.TYPE);
        PRIMITIVETYPE.put("byte", Byte.TYPE);
        PRIMITIVETYPE.put("short", Short.TYPE);
        PRIMITIVETYPE.put("int", Integer.TYPE);
        PRIMITIVETYPE.put("long", Long.TYPE);
        PRIMITIVETYPE.put("float", Float.TYPE);
        PRIMITIVETYPE.put("double", Double.TYPE);
    }
}

