/*
 * Decompiled with CFR 0.152.
 */
package com.micronova.util;

import com.micronova.util.NestedMap;
import com.micronova.util.TypeUtil;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;

public class BeanUtil {
    public static String encode(Object object) throws Exception {
        if (object != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XMLEncoder xMLEncoder = new XMLEncoder(byteArrayOutputStream);
            xMLEncoder.writeObject(object);
            xMLEncoder.close();
            return byteArrayOutputStream.toString();
        }
        return null;
    }

    public static Object decode(String string) throws Exception {
        Object object = null;
        if (string != null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("utf-8"));
            XMLDecoder xMLDecoder = new XMLDecoder(byteArrayInputStream);
            object = xMLDecoder.readObject();
            xMLDecoder.close();
            return object;
        }
        return null;
    }

    public static final Object getBeanProperty(Object object, String string) throws Exception {
        PropertyDescriptor[] propertyDescriptorArray = Introspector.getBeanInfo(object.getClass()).getPropertyDescriptors();
        int n = propertyDescriptorArray.length;
        while (--n >= 0) {
            String string2 = propertyDescriptorArray[n].getName();
            if (!string.equals(string2)) continue;
            Method method = propertyDescriptorArray[n].getReadMethod();
            return method.invoke(object, (Object[])null);
        }
        throw new Exception("bean property " + string + " not found");
    }

    public static final Object getProperty(Object object, String string) throws Exception {
        Class<?> clazz = object.getClass();
        if (object instanceof Map) {
            return ((Map)object).get(string);
        }
        if (object instanceof List) {
            List list = (List)object;
            int n = Integer.parseInt(string);
            if (n < 0) {
                n = list.size() + n;
            }
            return list.get(n);
        }
        if (clazz.isArray()) {
            int n = Integer.parseInt(string);
            if (n < 0) {
                n = Array.getLength(object) + n;
            }
            return Array.get(object, n);
        }
        return BeanUtil.getBeanProperty(object, string);
    }

    public static final Object setBeanProperty(Object object, String string, Object object2) throws Exception {
        PropertyDescriptor[] propertyDescriptorArray = Introspector.getBeanInfo(object.getClass()).getPropertyDescriptors();
        int n = propertyDescriptorArray.length;
        while (--n >= 0) {
            String string2 = propertyDescriptorArray[n].getName();
            if (!string.equals(string2)) continue;
            Method method = propertyDescriptorArray[n].getWriteMethod();
            Class<?>[] classArray = method.getParameterTypes();
            Object object3 = TypeUtil.isClass(object2, classArray[0]);
            return method.invoke(object, object3);
        }
        throw new Exception("bean property " + string + " not found");
    }

    public static final Object setProperty(Object object, String string, Object object2) throws Exception {
        Class<?> clazz = object.getClass();
        if (object instanceof Map) {
            return ((Map)object).put(string, object2);
        }
        if (object instanceof List) {
            List list = (List)object;
            Object object3 = null;
            int n = list.size();
            int n2 = -1;
            boolean bl = false;
            boolean bl2 = false;
            if ("".equals(string)) {
                string = "*";
            }
            if (string.startsWith("*")) {
                bl = true;
                if ((string = string.substring(1)).startsWith("*")) {
                    bl2 = true;
                    string = string.substring(1);
                }
            }
            if (string.length() == 0) {
                n2 = n;
            } else {
                n2 = Integer.parseInt(string);
                if (n2 < 0) {
                    n2 = n + n2;
                }
            }
            if (bl) {
                if (object2 != null) {
                    if (n2 == n) {
                        list.add(object2);
                    } else {
                        list.add(n2, object2);
                    }
                } else if (n > 0 && !bl2) {
                    object3 = n2 == n ? list.remove(n - 1) : list.remove(n2);
                }
            } else {
                object3 = list.set(n2, object2);
            }
            return object3;
        }
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            int n = Integer.parseInt(string);
            if (n < 0) {
                n = Array.getLength(object) + n;
            }
            Object object4 = Array.get(object, n);
            Array.set(object, n, TypeUtil.isClass(object2, clazz2));
            return object4;
        }
        return BeanUtil.setBeanProperty(object, string, object2);
    }

    public static Object fill(Object object, Map map) throws Exception {
        if (object != null) {
            PropertyDescriptor[] propertyDescriptorArray = Introspector.getBeanInfo(object.getClass()).getPropertyDescriptors();
            Object[] objectArray = new Object[1];
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                Object object2;
                String string = propertyDescriptorArray[i].getName();
                Object v = map.get(string);
                if (v == null) continue;
                Method method = propertyDescriptorArray[i].getWriteMethod();
                Class<?>[] classArray = method.getParameterTypes();
                objectArray[0] = object2 = TypeUtil.isClass(v, classArray[0]);
                method.invoke(object, objectArray);
            }
        }
        return object;
    }

    public static NestedMap getMap(Object object) throws Exception {
        PropertyDescriptor[] propertyDescriptorArray = Introspector.getBeanInfo(object.getClass()).getPropertyDescriptors();
        NestedMap nestedMap = new NestedMap();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            Method method;
            String string = propertyDescriptorArray[i].getName();
            Object object2 = nestedMap.get(string);
            if (object2 != null || (method = propertyDescriptorArray[i].getReadMethod()) == null) continue;
            object2 = method.invoke(object, (Object[])null);
            nestedMap.put(string, object2);
        }
        return nestedMap;
    }
}

