/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.property.descriptor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public final class PropDescriptors implements IPropertyIDConstants {

	private static PropDescriptors inst = null;

	private Map propNameMap = new HashMap(), eventNameMap = new HashMap();

	private List eventPropIDs = new ArrayList();

	// eCxgPropertyDescriptor
	private IPropertyDescriptor NAME, TEXT, CLASSNAME, TYPE, ISREQUIRED, DISABLE, ROWS,
			AUTOUP, ORIENTATION, STYLE, PROP, LIMINF, LIMSUP, WITHIMG, REVERSECLOSE,
			TAILLECURS, OVERFLOW, MODELIM, ALT, ENABLE;

	// private EventPropertyDescriptor ONCLICK, ONDBLCLICK, ONSETDISPLAY,
	// ONBLUR, ONFOCUS,
	// ONCELLEDIT, ONCELLWRITE;

	private IPropertyDescriptor TITLE, POSITION, DRAGGABLE, AUTORESIZEPARENT, DYNAMIC,
			INITIAL, IMAGEOUT, IMAGEON, ALTERNATETEXT, IMAGEDISABLED, BOOLFLOATLEFT,
			BOOLFLOATRIGHT;

	private IPropertyDescriptor BACKGROUNDCOLOR, WIDTHTABNAME, NOACTIVETAB, AUTOREDIMTAB,
			ISCLOSABLE, DRAGGABLEITEM;

	private IPropertyDescriptor URL, BOOLWITHLABEL, ARRVALUE, SUBMITONLOAD,
			ALWAYSREFRESH, CODEWIDTH, GROUP, CHECKED, VALUE, RANG, TABENTETE, TABTYPECOL,
			LINEHEIGHT, MULTISELECT, ACTIFCLIC, SORTABLE, WIDTHLASTCELL, SWITCHABLE,
			WRITABLE, SORTCOL, SORTTYPE;

	private IPropertyDescriptor CELLACTIVE, BNAVIG, BOOLPRINT, BOOLSELACTIVE, WITHROOT,
			ROOTOPEN, ROOTNODE, WITHT, BAUTORESIZECONTENU, DATATYPE, INITVALUE,
			ACCESSKEY, NBCHAR, TABINDEX, HEIGHTITEM, TABDATA, SUGGEST, AUTORESIZABLEH,
			AUTORESIZABLEW, DRAGGABLENODE, STEXT, SICON, SICON2, OPEN, RELOAD, TYPEINFO,
			ONCLICKATTR;

	// private IPropertyDescriptor ICON, ICON2, OPEN, RELOAD, TYPEINFO,
	// TREENODEONCLICK;

	private IPropertyDescriptor FIELDTYPE, DICTID, MINCHARS, AFTERUPDATEELEMENT,
			APPENDABLE, IMEMODE, PRINTTITLE, AUTORESIZECONTENU, BOOLMAXI, CONTENU,
			MODECONTAINER, BSANSBTONCLOSE, SUFFFOND;

	public static IPropertyDescriptor LEFT = new TextPropertyDescriptor(PROP_LEFT, "left"),
			TOP = new TextPropertyDescriptor(PROP_TOP, "top"),
			WIDTH = new TextPropertyDescriptor(PROP_WIDTH, "width"),
			HEIGHT = new TextPropertyDescriptor(PROP_HEIGHT, "height");

	private List COMPONENT_COMMON_PROPERTYDESC = new ArrayList();

	public IPropertyDescriptor[] COMMON_PROPERTYDESC_ARRAY;

	private IPropertyDescriptor[] mergeWithCompProperty(IPropertyDescriptor[] descs) {
		return mergeProperty(descs, COMMON_PROPERTYDESC_ARRAY);
	}

	private IPropertyDescriptor[] mergeProperty(IPropertyDescriptor[] desc1,
			IPropertyDescriptor[] desc2) {
		// Kv̒z̃Xy[Xallocate
		IPropertyDescriptor[] result = new IPropertyDescriptor[desc1.length
				+ desc2.length];
		// R|[lgʂPropertyDescriptorresult
		System.arraycopy(desc1, 0, result, 0, desc1.length);

		// descsresultɃRs[
		System.arraycopy(desc2, 0, result, desc1.length, desc2.length);
		return result;
	}

	// eR|[lgPropertyDescriptor[]
	public IPropertyDescriptor[] LABEL_PROPDESC, BUTTON_PROPDESC, FRAME_PROPDESC,
			IMAGE_PROPDESC, TEXT_PROPDESC;

	public IPropertyDescriptor[] RADIO_PROPDESC, CHECKBOX_PROPDESC, COMBO_PROPDESC,
			COMBOITEM_PROPDESC, GRID_PROPDESC, GRIDHEADER_PROPDESC, GRIDLINE_PROPDESC;

	public IPropertyDescriptor[] SPLITTER_PROPDESC, DIVSPLIT_PROPDESC,
			TABFOLDER_PROPDESC, TABITEM_PROPDESC, CODELIB_PROPDESC, TREEVIEW_PROPDESC,
			DIVHTML_PROPDESC, POPUP_PROPDESC, TREENODE_PROPDESC;

	public IPropertyDescriptor[] EF_PROPDESC, AC_PROPDESC;

	private PropDescriptors() {

		eventPropIDs.add(PROP_ONCLICK);
		eventPropIDs.add(PROP_ONDBLCLICK);
		eventPropIDs.add(PROP_ONSETDISPLAY);
		eventPropIDs.add(PROP_ONBLUR);
		eventPropIDs.add(PROP_ONFOCUS);
		eventPropIDs.add(PROP_ONCELLEDIT);
		eventPropIDs.add(PROP_ONCELLWRITE);
		eventPropIDs.add(PROP_ONMOUSEDOWN);
		eventPropIDs.add(PROP_ONMOUSEUP);
		eventPropIDs.add(PROP_ONMOUSEOVER);
		eventPropIDs.add(PROP_ONMOUSEMOVE);

		propNameMap.put(PROP_ID, "id");
		propNameMap.put(PROP_NAME, "name");
		propNameMap.put(PROP_TEXT, "text");
		propNameMap.put(PROP_CLASSNAME, "className");
		propNameMap.put(PROP_ONCLICK, "onclick");
		propNameMap.put(PROP_ONDBLCLICK, "ondbleclick");
		propNameMap.put(PROP_ONSETDISPLAY, "onsetdisplay");
		propNameMap.put(PROP_ONBLUR, "onblur");
		propNameMap.put(PROP_ONFOCUS, "onfocus");
		propNameMap.put(PROP_ONCELLEDIT, "oncelledit");
		propNameMap.put(PROP_ONCELLWRITE, "oncellwrite");
		propNameMap.put(PROP_ONMOUSEDOWN, "onmousedown");
		propNameMap.put(PROP_ONMOUSEUP, "onmouseup");
		propNameMap.put(PROP_ONMOUSEOVER, "onmouseover");
		propNameMap.put(PROP_ONMOUSEMOVE, "onmousemove");
		propNameMap.put(PROP_TITLE, "title");
		propNameMap.put(PROP_POSITION, "position");
		propNameMap.put(PROP_DRAGGABLE, "draggable");
		propNameMap.put(PROP_DYNAMIC, "dynamic");
		propNameMap.put(PROP_PRINTTITLE, "printTitle");
		propNameMap.put(PROP_AUTORESIZECONTENU, "autoResizeContenu");
		propNameMap.put(PROP_BOOLPRINT, "boolPrint");
		propNameMap.put(PROP_BOOLMAXI, "boolMaxi");
		propNameMap.put(PROP_INITIAL, "initial");
		propNameMap.put(PROP_ORIENTATION, "orientation");
		propNameMap.put(PROP_BACKGROUNDCOLOR, "backgroundColor");
		propNameMap.put(PROP_WIDTHTABNAME, "widthTabName");
		propNameMap.put(PROP_NOACTIVETAB, "noActiveTab");
		propNameMap.put(PROP_AUTOREDIMTAB, "autoRedimTab");
		propNameMap.put(PROP_ISCLOSABLE, "isClosable");
		propNameMap.put(PROP_DRAGGABLEITEM, "draggableItem");
		propNameMap.put(PROP_TYPE, "type");
		propNameMap.put(PROP_DATATYPE, "datatype");
		propNameMap.put(PROP_INITVALUE, "initValue");
		propNameMap.put(PROP_ACCESSKEY, "accessKey");
		propNameMap.put(PROP_NBCHAR, "nbchar");
		propNameMap.put(PROP_TABINDEX, "tabIndex");
		propNameMap.put(PROP_ISREQUIRED, "isRequired");
		propNameMap.put(PROP_DISABLE, "disable");
		propNameMap.put(PROP_AUTOUP, "autoUp");
		propNameMap.put(PROP_ROWS, "rows");
		propNameMap.put(PROP_URL, "url");
		propNameMap.put(PROP_BOOLWITHLABEL, "boolWithLabel");
		propNameMap.put(PROP_ARRVALUE, "arrValue");
		propNameMap.put(PROP_SUBMITONLOAD, "submitOnload");
		propNameMap.put(PROP_ALWAYSREFRESH, "alwaysRefresh");
		propNameMap.put(PROP_CODEWIDTH, "codeWidth");
		propNameMap.put(PROP_STYLE, "style");
		propNameMap.put(PROP_PROP, "prop");
		propNameMap.put(PROP_LIMINF, "limInf");
		propNameMap.put(PROP_LIMSUP, "limSup");
		propNameMap.put(PROP_WITHIMG, "withImg");
		propNameMap.put(PROP_REVERSECLOSE, "reverseClose");
		propNameMap.put(PROP_TAILLECURS, "tailleCurs");
		propNameMap.put(PROP_OVERFLOW, "overflow");
		propNameMap.put(PROP_MODELIM, "modeLim");
		propNameMap.put(PROP_ALT, "alt");
		propNameMap.put(PROP_ENABLE, "enable");
		propNameMap.put(PROP_GROUP, "group");
		propNameMap.put(PROP_CHECKED, "checked");
		propNameMap.put(PROP_VALUE, "value");
		propNameMap.put(PROP_RANG, "rang");
		propNameMap.put(PROP_TABENTETE, "TabEntete");
		propNameMap.put(PROP_TABTYPECOL, "tabTypeCol");
		propNameMap.put(PROP_LINEHEIGHT, "lineHeight");
		propNameMap.put(PROP_MULTISELECT, "multiSelect");
		propNameMap.put(PROP_ACTIFCLIC, "actifClic");
		propNameMap.put(PROP_CELLACTIVE, "cellActive");
		propNameMap.put(PROP_BNAVIG, "bNavig");
		propNameMap.put(PROP_SORTABLE, "sortable");
		propNameMap.put(PROP_WIDTHLASTCELL, "widthLastCell");
		propNameMap.put(PROP_SWITCHABLE, "switchable");
		propNameMap.put(PROP_AUTORESIZEPARENT, "autoResizeParent");
		propNameMap.put(PROP_WRITABLE, "writable");
		propNameMap.put(PROP_GRIDCOMBO, "gridCombo");
		propNameMap.put(PROP_SORTCOL, "sortCol");
		propNameMap.put(PROP_SORTTYPE, "sortType");

		propNameMap.put(PROP_BOOLSELACTIVE, "boolSelActive");
		propNameMap.put(PROP_WITHROOT, "withRoot");
		propNameMap.put(PROP_ROOTOPEN, "rootOpen");
		propNameMap.put(PROP_WITHT, "withT");
		propNameMap.put(PROP_AUTORESIZABLEH, "autoResizableH");
		propNameMap.put(PROP_AUTORESIZABLEW, "autoResizableW");
		propNameMap.put(PROP_DRAGGABLENODE, "draggableNode");
		propNameMap.put(PROP_ROOTNODE, "rootNode");

		propNameMap.put(PROP_OPEN, "open");
		propNameMap.put(PROP_RELOAD, "reload");
		propNameMap.put(PROP_TYPEINFO, "typeInfo");
		propNameMap.put(PROP_WIDTH, "width");
		propNameMap.put(PROP_IMAGEON, "imageOn");
		propNameMap.put(PROP_IMAGEOUT, "imageOut");
		propNameMap.put(PROP_ALTERNATETEXT, "alternateText");
		propNameMap.put(PROP_IMAGEDISABLED, "imageDisabled");
		propNameMap.put(PROP_BOOLFLOATLEFT, "boolFloatLeft");
		propNameMap.put(PROP_BOOLFLOATRIGHT, "boolFloatRight");
		propNameMap.put(PROP_HEIGHTITEM, "heightItem");
		propNameMap.put(PROP_TABDATA, "tabData");
		propNameMap.put(PROP_SUGGEST, "suggest");
		propNameMap.put(PROP_HTML, "html");

		propNameMap.put(PROP_CONTENU, "contenu");
		propNameMap.put(PROP_MODECONTAINER, "modeContainer");
		propNameMap.put(PROP_BSANSBTONCLOSE, "bSansBtonClose");
		propNameMap.put(PROP_SUFFFOND, "suffFond");

		propNameMap.put(PROP_STEXT, "sText");
		propNameMap.put(PROP_SICON, "sIcon");
		propNameMap.put(PROP_SICON2, "sIcon2");
		propNameMap.put(PROP_ONCLICKATTR, "onclick");

		// gi
		propNameMap.put(PROP_BAUTORESIZECONTENU, "bAutoResizeContenu");
		propNameMap.put(PROP_FIELDTYPE, "fieldType");
		propNameMap.put(PROP_DICTID, "dictId");
		propNameMap.put(PROP_MINCHARS, "minChars");
		propNameMap.put(PROP_AFTERUPDATEELEMENT, "afterUpdateElement");
		propNameMap.put(PROP_APPENDABLE, "appendable");
		propNameMap.put(PROP_IMEMODE, "imeMode");
		// gi

		eventNameMap.put(PROP_ONCLICK, "onclick");
		eventNameMap.put(PROP_ONDBLCLICK, "ondbleclick");
		eventNameMap.put(PROP_ONSETDISPLAY, "onsetdisplay");
		eventNameMap.put(PROP_ONBLUR, "onblur");
		eventNameMap.put(PROP_ONFOCUS, "onfocus");
		eventNameMap.put(PROP_ONCELLEDIT, "oncelledit");
		eventNameMap.put(PROP_ONCELLWRITE, "oncellwrite");
		eventNameMap.put(PROP_ONMOUSEDOWN, "onmousedown");
		eventNameMap.put(PROP_ONMOUSEUP, "onmouseup");
		eventNameMap.put(PROP_ONMOUSEOVER, "onmouseover");
		eventNameMap.put(PROP_ONMOUSEMOVE, "onmousemove");

		NAME = new MaskatTextPropertyDescriptor(PROP_NAME, (String) propNameMap
				.get(PROP_NAME));

		TEXT = new MaskatTextPropertyDescriptor(PROP_TEXT, (String) propNameMap
				.get(PROP_TEXT));
		CLASSNAME = new MaskatTextPropertyDescriptor(PROP_CLASSNAME, (String) propNameMap
				.get(PROP_CLASSNAME));
		TYPE = new MaskatTextPropertyDescriptor(PROP_TYPE, (String) propNameMap
				.get(PROP_TYPE));
		ISREQUIRED = new MaskatTextPropertyDescriptor(PROP_ISREQUIRED,
				(String) propNameMap.get(PROP_ISREQUIRED));
		DISABLE = new MaskatTextPropertyDescriptor(PROP_DISABLE, (String) propNameMap
				.get(PROP_DISABLE));
		AUTOUP = new MaskatTextPropertyDescriptor(PROP_AUTOUP, (String) propNameMap
				.get(PROP_AUTOUP));
		ROWS = new MaskatTextPropertyDescriptor(PROP_ROWS, (String) propNameMap
				.get(PROP_ROWS));
		DATATYPE = new MaskatTextPropertyDescriptor(PROP_DATATYPE, (String) propNameMap
				.get(PROP_DATATYPE));
		INITVALUE = new MaskatTextPropertyDescriptor(PROP_INITVALUE, (String) propNameMap
				.get(PROP_INITVALUE));
		ACCESSKEY = new MaskatTextPropertyDescriptor(PROP_ACCESSKEY, (String) propNameMap
				.get(PROP_ACCESSKEY));
		NBCHAR = new MaskatTextPropertyDescriptor(PROP_NBCHAR, (String) propNameMap
				.get(PROP_NBCHAR));
		TABINDEX = new MaskatTextPropertyDescriptor(PROP_TABINDEX, (String) propNameMap
				.get(PROP_TABINDEX));
		ORIENTATION = new MaskatTextPropertyDescriptor(PROP_ORIENTATION,
				(String) propNameMap.get(PROP_ORIENTATION));
		STYLE = new MaskatTextPropertyDescriptor(PROP_STYLE, (String) propNameMap
				.get(PROP_STYLE));
		PROP = new MaskatTextPropertyDescriptor(PROP_PROP, (String) propNameMap
				.get(PROP_PROP));
		LIMINF = new MaskatTextPropertyDescriptor(PROP_LIMINF, (String) propNameMap
				.get(PROP_LIMINF));
		LIMSUP = new MaskatTextPropertyDescriptor(PROP_LIMSUP, (String) propNameMap
				.get(PROP_LIMSUP));
		WITHIMG = new MaskatTextPropertyDescriptor(PROP_WITHIMG, (String) propNameMap
				.get(PROP_WITHIMG));
		REVERSECLOSE = new MaskatTextPropertyDescriptor(PROP_REVERSECLOSE,
				(String) propNameMap.get(PROP_REVERSECLOSE));
		TAILLECURS = new MaskatTextPropertyDescriptor(PROP_TAILLECURS,
				(String) propNameMap.get(PROP_TAILLECURS));
		OVERFLOW = new MaskatTextPropertyDescriptor(PROP_OVERFLOW, (String) propNameMap
				.get(PROP_OVERFLOW));
		MODELIM = new MaskatTextPropertyDescriptor(PROP_MODELIM, (String) propNameMap
				.get(PROP_MODELIM));
		ALT = new MaskatTextPropertyDescriptor(PROP_ALT, (String) propNameMap
				.get(PROP_ALT));
		ENABLE = new MaskatTextPropertyDescriptor(PROP_ENABLE, (String) propNameMap
				.get(PROP_ENABLE));
		URL = new MaskatTextPropertyDescriptor(PROP_URL, (String) propNameMap
				.get(PROP_URL));
		BOOLWITHLABEL = new MaskatTextPropertyDescriptor(PROP_BOOLWITHLABEL,
				(String) propNameMap.get(PROP_BOOLWITHLABEL));
		ARRVALUE = new MaskatTextPropertyDescriptor(PROP_ARRVALUE, (String) propNameMap
				.get(PROP_ARRVALUE));
		SUBMITONLOAD = new MaskatTextPropertyDescriptor(PROP_SUBMITONLOAD,
				(String) propNameMap.get(PROP_SUBMITONLOAD));
		ALWAYSREFRESH = new MaskatTextPropertyDescriptor(PROP_ALWAYSREFRESH,
				(String) propNameMap.get(PROP_ALWAYSREFRESH));
		CODEWIDTH = new MaskatTextPropertyDescriptor(PROP_CODEWIDTH, (String) propNameMap
				.get(PROP_CODEWIDTH));
		GROUP = new MaskatTextPropertyDescriptor(PROP_GROUP, (String) propNameMap
				.get(PROP_GROUP));
		CHECKED = new MaskatTextPropertyDescriptor(PROP_CHECKED, (String) propNameMap
				.get(PROP_CHECKED));
		VALUE = new MaskatTextPropertyDescriptor(PROP_VALUE, (String) propNameMap
				.get(PROP_VALUE));
		RANG = new MaskatTextPropertyDescriptor(PROP_RANG, (String) propNameMap
				.get(PROP_RANG));
		TABENTETE = new MaskatTextPropertyDescriptor(PROP_TABENTETE, (String) propNameMap
				.get(PROP_TABENTETE));
		TABTYPECOL = new MaskatTextPropertyDescriptor(PROP_TABTYPECOL,
				(String) propNameMap.get(PROP_TABTYPECOL));
		LINEHEIGHT = new MaskatTextPropertyDescriptor(PROP_LINEHEIGHT,
				(String) propNameMap.get(PROP_LINEHEIGHT));
		MULTISELECT = new MaskatTextPropertyDescriptor(PROP_MULTISELECT,
				(String) propNameMap.get(PROP_MULTISELECT));
		ACTIFCLIC = new MaskatTextPropertyDescriptor(PROP_ACTIFCLIC, (String) propNameMap
				.get(PROP_ACTIFCLIC));
		SORTABLE = new MaskatTextPropertyDescriptor(PROP_SORTABLE, (String) propNameMap
				.get(PROP_SORTABLE));
		WIDTHLASTCELL = new MaskatTextPropertyDescriptor(PROP_WIDTHLASTCELL,
				(String) propNameMap.get(PROP_WIDTHLASTCELL));
		SWITCHABLE = new MaskatTextPropertyDescriptor(PROP_SWITCHABLE,
				(String) propNameMap.get(PROP_SWITCHABLE));
		WRITABLE = new MaskatTextPropertyDescriptor(PROP_WRITABLE, (String) propNameMap
				.get(PROP_WRITABLE));
		SORTCOL = new MaskatTextPropertyDescriptor(PROP_SORTCOL, (String) propNameMap
				.get(PROP_SORTCOL));
		SORTTYPE = new MaskatTextPropertyDescriptor(PROP_SORTTYPE, (String) propNameMap
				.get(PROP_SORTTYPE));

		CELLACTIVE = new MaskatTextPropertyDescriptor(PROP_CELLACTIVE,
				(String) propNameMap.get(PROP_CELLACTIVE));
		BNAVIG = new MaskatTextPropertyDescriptor(PROP_BNAVIG, (String) propNameMap
				.get(PROP_BNAVIG));
		BOOLPRINT = new MaskatTextPropertyDescriptor(PROP_BOOLPRINT, (String) propNameMap
				.get(PROP_BOOLPRINT));
		BOOLSELACTIVE = new MaskatTextPropertyDescriptor(PROP_BOOLSELACTIVE,
				(String) propNameMap.get(PROP_BOOLSELACTIVE));
		WITHROOT = new MaskatTextPropertyDescriptor(PROP_WITHROOT, (String) propNameMap
				.get(PROP_WITHROOT));
		ROOTOPEN = new MaskatTextPropertyDescriptor(PROP_ROOTOPEN, (String) propNameMap
				.get(PROP_ROOTOPEN));
		WITHT = new MaskatTextPropertyDescriptor(PROP_WITHT, (String) propNameMap
				.get(PROP_WITHT));
		AUTORESIZABLEH = new MaskatTextPropertyDescriptor(PROP_AUTORESIZABLEH,
				(String) propNameMap.get(PROP_AUTORESIZABLEH));
		AUTORESIZABLEW = new MaskatTextPropertyDescriptor(PROP_AUTORESIZABLEW,
				(String) propNameMap.get(PROP_AUTORESIZABLEW));
		DRAGGABLENODE = new MaskatTextPropertyDescriptor(PROP_DRAGGABLENODE,
				(String) propNameMap.get(PROP_DRAGGABLENODE));
		ROOTNODE = new MaskatTextPropertyDescriptor(PROP_ROOTNODE, (String) propNameMap
				.get(PROP_ROOTNODE));
		BAUTORESIZECONTENU = new MaskatTextPropertyDescriptor(PROP_BAUTORESIZECONTENU,
				(String) propNameMap.get(PROP_BAUTORESIZECONTENU));
		FIELDTYPE = new MaskatTextPropertyDescriptor(PROP_FIELDTYPE, (String) propNameMap
				.get(PROP_FIELDTYPE));
		DICTID = new MaskatTextPropertyDescriptor(PROP_DICTID, (String) propNameMap
				.get(PROP_DICTID));
		MINCHARS = new MaskatTextPropertyDescriptor(PROP_MINCHARS, (String) propNameMap
				.get(PROP_MINCHARS));
		AFTERUPDATEELEMENT = new MaskatTextPropertyDescriptor(PROP_AFTERUPDATEELEMENT,
				(String) propNameMap.get(PROP_AFTERUPDATEELEMENT));
		APPENDABLE = new MaskatTextPropertyDescriptor(PROP_APPENDABLE,
				(String) propNameMap.get(PROP_APPENDABLE));
		IMEMODE = new MaskatTextPropertyDescriptor(PROP_IMEMODE, (String) propNameMap
				.get(PROP_IMEMODE));
		// HTML = new MaskatTextPropertyDescriptor(PROP_HTML, (String)
		// propNameMap
		// .get(PROP_HTML));

		// ICON = new MaskatTextPropertyDescriptor(PROP_ICON, (String)
		// propNameMap
		// .get(PROP_ICON));
		// ICON2 = new MaskatTextPropertyDescriptor(PROP_ICON2, (String)
		// propNameMap
		// .get(PROP_ICON2));
		// OPEN = new MaskatTextPropertyDescriptor(PROP_OPEN, (String)
		// propNameMap
		// .get(PROP_OPEN));
		// RELOAD = new MaskatTextPropertyDescriptor(PROP_RELOAD, (String)
		// propNameMap
		// .get(PROP_RELOAD));
		// TYPEINFO = new MaskatTextPropertyDescriptor(PROP_TYPEINFO, (String)
		// propNameMap
		// .get(PROP_TYPEINFO));
		// TREENODEONCLICK = new
		// MaskatTextPropertyDescriptor(PROP_TREENODEONCLICK,
		// (String) propNameMap.get(PROP_TREENODEONCLICK));
		WIDTH = new MaskatTextPropertyDescriptor(PROP_WIDTH, (String) propNameMap
				.get(PROP_WIDTH));

		/*
		 * ONCLICK = new EventPropertyDescriptor(PROP_ONCLICK, (String)
		 * propNameMap .get(PROP_ONCLICK));
		 * 
		 * ONDBLCLICK = new EventPropertyDescriptor(PROP_ONDBLCLICK, (String)
		 * propNameMap .get(PROP_ONDBLCLICK));
		 * 
		 * ONSETDISPLAY = new EventPropertyDescriptor(PROP_ONSETDISPLAY,
		 * (String) propNameMap.get(PROP_ONSETDISPLAY));
		 * 
		 * ONBLUR = new EventPropertyDescriptor(PROP_ONBLUR, (String)
		 * propNameMap .get(PROP_ONBLUR));
		 * 
		 * ONFOCUS = new EventPropertyDescriptor(PROP_ONFOCUS, (String)
		 * propNameMap .get(PROP_ONFOCUS));
		 * 
		 * ONCELLEDIT = new EventPropertyDescriptor(PROP_ONCELLEDIT, (String)
		 * propNameMap .get(PROP_ONCELLEDIT));
		 * 
		 * ONCELLWRITE = new EventPropertyDescriptor(PROP_ONCELLWRITE, (String)
		 * propNameMap .get(PROP_ONCELLWRITE));
		 */

		TITLE = new MaskatTextPropertyDescriptor(PROP_TITLE, (String) propNameMap
				.get(PROP_TITLE));

		POSITION = new MaskatTextPropertyDescriptor(PROP_POSITION, (String) propNameMap
				.get(PROP_POSITION));

		DRAGGABLE = new MaskatTextPropertyDescriptor(PROP_DRAGGABLE, (String) propNameMap
				.get(PROP_DRAGGABLE));
		PRINTTITLE = new MaskatTextPropertyDescriptor(PROP_PRINTTITLE,
				(String) propNameMap.get(PROP_PRINTTITLE));
		AUTORESIZECONTENU = new MaskatTextPropertyDescriptor(PROP_AUTORESIZECONTENU,
				(String) propNameMap.get(PROP_AUTORESIZECONTENU));
		BOOLPRINT = new MaskatTextPropertyDescriptor(PROP_BOOLPRINT, (String) propNameMap
				.get(PROP_BOOLPRINT));
		BOOLMAXI = new MaskatTextPropertyDescriptor(PROP_BOOLMAXI, (String) propNameMap
				.get(PROP_BOOLMAXI));

		AUTORESIZEPARENT = new MaskatTextPropertyDescriptor(PROP_AUTORESIZEPARENT,
				(String) propNameMap.get(PROP_AUTORESIZEPARENT));

		DYNAMIC = new MaskatTextPropertyDescriptor(PROP_DYNAMIC, (String) propNameMap
				.get(PROP_DYNAMIC));

		INITIAL = new MaskatTextPropertyDescriptor(PROP_INITIAL, (String) propNameMap
				.get(PROP_INITIAL));

		IMAGEOUT = new MaskatTextPropertyDescriptor(PROP_IMAGEOUT, (String) propNameMap
				.get(PROP_IMAGEOUT));
		IMAGEON = new MaskatTextPropertyDescriptor(PROP_IMAGEON, (String) propNameMap
				.get(PROP_IMAGEON));
		ALTERNATETEXT = new MaskatTextPropertyDescriptor(PROP_ALTERNATETEXT,
				(String) propNameMap.get(PROP_ALTERNATETEXT));
		IMAGEDISABLED = new MaskatTextPropertyDescriptor(PROP_IMAGEDISABLED,
				(String) propNameMap.get(PROP_IMAGEDISABLED));
		BOOLFLOATLEFT = new MaskatTextPropertyDescriptor(PROP_BOOLFLOATLEFT,
				(String) propNameMap.get(PROP_BOOLFLOATLEFT));
		BOOLFLOATRIGHT = new MaskatTextPropertyDescriptor(PROP_BOOLFLOATRIGHT,
				(String) propNameMap.get(PROP_BOOLFLOATRIGHT));
		HEIGHTITEM = new MaskatTextPropertyDescriptor(PROP_HEIGHTITEM,
				(String) propNameMap.get(PROP_HEIGHTITEM));
		TABDATA = new MaskatTextPropertyDescriptor(PROP_TABDATA, (String) propNameMap
				.get(PROP_TABDATA));
		SUGGEST = new MaskatTextPropertyDescriptor(PROP_SUGGEST, (String) propNameMap
				.get(PROP_SUGGEST));

		BACKGROUNDCOLOR = new MaskatTextPropertyDescriptor(PROP_BACKGROUNDCOLOR,
				(String) propNameMap.get(PROP_BACKGROUNDCOLOR));
		WIDTHTABNAME = new MaskatTextPropertyDescriptor(PROP_WIDTHTABNAME,
				(String) propNameMap.get(PROP_WIDTHTABNAME));
		NOACTIVETAB = new MaskatTextPropertyDescriptor(PROP_NOACTIVETAB,
				(String) propNameMap.get(PROP_NOACTIVETAB));
		AUTOREDIMTAB = new MaskatTextPropertyDescriptor(PROP_AUTOREDIMTAB,
				(String) propNameMap.get(PROP_AUTOREDIMTAB));
		ISCLOSABLE = new MaskatTextPropertyDescriptor(PROP_ISCLOSABLE,
				(String) propNameMap.get(PROP_ISCLOSABLE));
		DRAGGABLEITEM = new MaskatTextPropertyDescriptor(PROP_DRAGGABLEITEM,
				(String) propNameMap.get(PROP_DRAGGABLEITEM));

		CONTENU = new MaskatTextPropertyDescriptor(PROP_CONTENU, (String) propNameMap
				.get(PROP_CONTENU));
		MODECONTAINER = new MaskatTextPropertyDescriptor(PROP_MODECONTAINER,
				(String) propNameMap.get(PROP_MODECONTAINER));
		BSANSBTONCLOSE = new MaskatTextPropertyDescriptor(PROP_BSANSBTONCLOSE,
				(String) propNameMap.get(PROP_BSANSBTONCLOSE));
		SUFFFOND = new MaskatTextPropertyDescriptor(PROP_SUFFFOND, (String) propNameMap
				.get(PROP_SUFFFOND));

		STEXT = new MaskatTextPropertyDescriptor(PROP_STEXT, (String) propNameMap
				.get(PROP_STEXT));
		SICON = new MaskatTextPropertyDescriptor(PROP_SICON, (String) propNameMap
				.get(PROP_SICON));
		SICON2 = new MaskatTextPropertyDescriptor(PROP_SICON2, (String) propNameMap
				.get(PROP_SICON2));
		OPEN = new MaskatTextPropertyDescriptor(PROP_OPEN, (String) propNameMap
				.get(PROP_OPEN));
		RELOAD = new MaskatTextPropertyDescriptor(PROP_RELOAD, (String) propNameMap
				.get(PROP_RELOAD));
		TYPEINFO = new MaskatTextPropertyDescriptor(PROP_TYPEINFO, (String) propNameMap
				.get(PROP_TYPEINFO));
		ONCLICKATTR = new MaskatTextPropertyDescriptor(PROP_ONCLICKATTR,
				(String) propNameMap.get(PROP_ONCLICKATTR));

		COMPONENT_COMMON_PROPERTYDESC.add(NAME);
		COMMON_PROPERTYDESC_ARRAY = (IPropertyDescriptor[]) COMPONENT_COMMON_PROPERTYDESC
				.toArray(new IPropertyDescriptor[0]);

		ICellEditorValidator validator = new ICellEditorValidator() {
			public String isValid(Object value) {
				try {
					Integer.parseInt((String) value);
					return null;
				} catch (NumberFormatException e) {
					return "͂ĂB";
				}
			}
		};
		((TextPropertyDescriptor) LEFT).setValidator(validator);
		((TextPropertyDescriptor) TOP).setValidator(validator);
		((TextPropertyDescriptor) WIDTH).setValidator(validator);
		((TextPropertyDescriptor) HEIGHT).setValidator(validator);

		// eR|[lgPropertyDescriptor[]
		LABEL_PROPDESC = mergeWithCompProperty(new IPropertyDescriptor[] { LEFT, TOP,
				TEXT, CLASSNAME });

		BUTTON_PROPDESC = mergeWithCompProperty(new IPropertyDescriptor[] { LEFT, TOP,
				TABINDEX, TITLE, ALT, ENABLE });

		FRAME_PROPDESC = mergeWithCompProperty(new IPropertyDescriptor[] { LEFT, TOP,
				WIDTH, HEIGHT, TITLE, DRAGGABLE, AUTORESIZEPARENT, DYNAMIC, PRINTTITLE,
				AUTORESIZECONTENU, BOOLPRINT, BOOLMAXI });

		IMAGE_PROPDESC = mergeWithCompProperty(new IPropertyDescriptor[] { LEFT, TOP,
				IMAGEOUT, ALTERNATETEXT, IMAGEON, IMAGEDISABLED, BOOLFLOATLEFT,
				BOOLFLOATRIGHT });

		TEXT_PROPDESC = mergeWithCompProperty(new IPropertyDescriptor[] { LEFT, TOP,
				WIDTH, TABINDEX, ISREQUIRED, DISABLE, AUTOUP, ROWS, DATATYPE, INITVALUE,
				ACCESSKEY, NBCHAR });

		RADIO_PROPDESC = mergeWithCompProperty(new IPropertyDescriptor[] { LEFT, TOP,
				GROUP, TABINDEX, TEXT, CLASSNAME, CHECKED, ENABLE });

		CHECKBOX_PROPDESC = mergeWithCompProperty(new IPropertyDescriptor[] { LEFT, TOP,
				TABINDEX, TEXT, CLASSNAME, CHECKED, ENABLE });

		COMBO_PROPDESC = mergeWithCompProperty(new IPropertyDescriptor[] { LEFT, TOP,
				WIDTH, TABINDEX, ENABLE, HEIGHTITEM, TABDATA, SUGGEST });

		COMBOITEM_PROPDESC = new IPropertyDescriptor[] { TEXT, VALUE };

		GRID_PROPDESC = mergeWithCompProperty(new IPropertyDescriptor[] { LEFT, TOP,
				HEIGHT, TABINDEX, LINEHEIGHT, MULTISELECT, ACTIFCLIC, CELLACTIVE, BNAVIG,
				BOOLPRINT, SORTABLE, WIDTHLASTCELL, SWITCHABLE, AUTORESIZEPARENT,
				WRITABLE, RANG, TABENTETE, PRINTTITLE, AUTORESIZECONTENU, TABTYPECOL,
				SORTCOL, SORTTYPE });
		GRIDHEADER_PROPDESC = new IPropertyDescriptor[] { TITLE, TYPE, WIDTH ,new GridCellCombosPropertyDescriptor(PROP_GRIDCOMBO,"gridCellCombo")};

		TREEVIEW_PROPDESC = mergeWithCompProperty(new IPropertyDescriptor[] { LEFT, TOP,
				WIDTH, HEIGHT, TABINDEX, BOOLSELACTIVE, WITHROOT, ROOTOPEN, WITHT,
				AUTORESIZABLEH, AUTORESIZABLEW, DRAGGABLENODE, ROOTNODE });

		SPLITTER_PROPDESC = mergeWithCompProperty(new IPropertyDescriptor[] { LEFT, TOP,
				WIDTH, HEIGHT, ORIENTATION, STYLE, PROP, LIMINF, LIMSUP, WITHIMG,
				REVERSECLOSE, AUTORESIZEPARENT, AUTORESIZABLEH, AUTORESIZABLEW,
				TAILLECURS, AUTORESIZECONTENU, OVERFLOW, MODELIM });

		DIVSPLIT_PROPDESC = new IPropertyDescriptor[] { NAME, BACKGROUNDCOLOR };

		TABFOLDER_PROPDESC = mergeWithCompProperty(new IPropertyDescriptor[] { LEFT, TOP,
				WIDTH, HEIGHT, TABINDEX, WIDTHTABNAME, NOACTIVETAB, AUTOREDIMTAB,
				AUTORESIZEPARENT, ISCLOSABLE, DRAGGABLEITEM, AUTORESIZECONTENU });
		TABITEM_PROPDESC = new IPropertyDescriptor[] {
				new PropertyDescriptor(PROP_NAME, (String) propNameMap.get(PROP_NAME)),
				TITLE };// tabitemnamereadonlyɂ
		CODELIB_PROPDESC = mergeWithCompProperty(new IPropertyDescriptor[] { LEFT, TOP,
				WIDTH, TABINDEX, ENABLE, URL, BOOLWITHLABEL, ARRVALUE, SUBMITONLOAD,
				ALWAYSREFRESH, CODEWIDTH });
		DIVHTML_PROPDESC = mergeWithCompProperty(new IPropertyDescriptor[] { LEFT, TOP,
				CLASSNAME, POSITION });

		POPUP_PROPDESC = mergeWithCompProperty(new IPropertyDescriptor[] { LEFT, TOP,
				WIDTH, HEIGHT, TITLE, CONTENU, MODECONTAINER, BSANSBTONCLOSE, SUFFFOND });

		TREENODE_PROPDESC = mergeWithCompProperty(new IPropertyDescriptor[] { STEXT,
				SICON, SICON2, OPEN, RELOAD, URL, TYPEINFO, ONCLICKATTR });

		EF_PROPDESC = mergeWithCompProperty(new IPropertyDescriptor[] { TITLE, POSITION,
				DRAGGABLE, AUTORESIZEPARENT, BAUTORESIZECONTENU, DYNAMIC, INITIAL });
		AC_PROPDESC = mergeWithCompProperty(new IPropertyDescriptor[] { FIELDTYPE, URL,
				DICTID, MINCHARS, AFTERUPDATEELEMENT, APPENDABLE, IMEMODE, ROWS });
	}

	public static PropDescriptors getInst() {
		if (inst == null) {
			inst = new PropDescriptors();
		}
		return inst;
	}

	/**
	 * Cxg̃vpeBIDł邩ǂ
	 * 
	 * @param id
	 * @return
	 */
	public boolean isEventPropID(Object id) {
		if (eventPropIDs.contains(id))
			return true;
		return false;
	}

	/**
	 * Cxg̃vpeBIDCxgID(onclickAonblurƂ)擾
	 * 
	 * @param id
	 * @return
	 */
	public String getEventID(Object id) {
		if (!isEventPropID(id))
			return null;
		return (String) eventNameMap.get(id);
	}

	public IPropertyDescriptor getNamePropDesc() {
		return NAME;
	}

}
