/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.gef.figure;

import org.eclipse.draw2d.IFigure;

/**
 * Used to give the IFigure a name, which is the model's name. Was used to
 * search for a name-specified figure and switch it visible/invisible.
 * 
 * @author shengshen
 * @deprecated We don't search the tree of figures, instead the tree of
 *             editparts is searched. So it's not necessary to give IFigure a
 *             name.
 */
public interface INamedFigure extends IFigure {

	public String getName();

	public void setName(String name);

}
