/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.gef.editpolicies;

import java.util.Iterator;

import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.GroupRequest;
import org.maskat.framework.screendef.TabFolderDef;
import org.maskat.framework.screendef.TabItemDef;
import org.maskat.ide.gef.commands.DelBasicDefCommand;
import org.maskat.ide.gef.models.TabDef;

public class TabEditPolicy extends ComponentEditPolicy {

	protected Command createDeleteCommand(GroupRequest deleteRequest) {
		TabDef model = (TabDef) getHost().getModel();

		TabFolderDef tabFolderDef = (TabFolderDef) model.getParent();
		Iterator it = tabFolderDef.getTypedChildren(TabItemDef.class);
		for (; it != null && it.hasNext();) {
			TabItemDef tabItemDef = (TabItemDef) it.next();
			if (model.getName().equals(tabItemDef.getName())) {
				return new DelBasicDefCommand(tabFolderDef, tabItemDef);
			}
		}
		return null;
	}
}
