/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.gef.editparts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.maskat.framework.screendef.ComponentDef;
import org.maskat.framework.screendef.IComponentDef;
import org.maskat.framework.screendef.PopupDef;
import org.maskat.framework.screendef.TabFolderDef;
import org.maskat.framework.screendef.TabItemDef;
import org.maskat.ide.gef.editpolicies.MaskatComponentEditPolicy;
import org.maskat.ide.gef.editpolicies.MyXYLayoutEditPolicy;
import org.maskat.ide.gef.figure.TabFolderFigure;
import org.maskat.ide.gef.models.TabDef;

public class TabFolderEditPart extends AbstractGraphicalEditPart implements
		PropertyChangeListener {

	/** JgIĂ^ũCfbNX */
	// private int currentSelectedTabIdx;
	TabFolderFigure tabFolderFigure;

	protected void createEditPolicies() {
		installEditPolicy(EditPolicy.COMPONENT_ROLE, new MaskatComponentEditPolicy());
		installEditPolicy(EditPolicy.LAYOUT_ROLE, new MyXYLayoutEditPolicy());
	}

	protected void switchToPage(String pageName) {
		tabFolderFigure.setAllTabPageInvisible();

		// I𒆂̃^uy[W\
		tabFolderFigure.showNamedTabPage(pageName);
	}

	public void activate() {
		super.activate();
		ComponentDef model = (ComponentDef) getModel();
		model.addPropertyChangeListener(this);
	}

	public void deactivate() {
		ComponentDef model = (ComponentDef) getModel();
		model.removePropertyChangeListener(this);
		super.deactivate();
	}

	protected List getModelChildren() {
		TabFolderDef tabFolder = (TabFolderDef) getModel();
		List children = tabFolder.getComponentChildren();
		List result = new ArrayList();
		for (Iterator it = children.iterator(); it.hasNext();) {
			TabItemDef tabItem = (TabItemDef) it.next();
			TabDef tabDef = new TabDef(tabFolder, tabItem);
			result.add(tabItem);
			result.add(tabDef);
		}
		return result;
	}

	protected IFigure createFigure() {
		tabFolderFigure = new TabFolderFigure();
		tabFolderFigure.setBorder(new CompoundBorder(new LineBorder(),
				new MarginBorder(0)));
		XYLayout layout = new XYLayout();
		tabFolderFigure.setLayoutManager(layout);
		return tabFolderFigure;
	}

	protected void refreshVisuals() {
		// ̎擾
		IComponentDef comp = (IComponentDef) getModel();
		Rectangle constraint = new Rectangle(comp.getLeft(), comp.getTop(),
				comp.getWidth(), comp.getHeight());

		if (getParent().getModel() instanceof PopupDef) {
			constraint.y += 20;
		}

		((GraphicalEditPart) getParent()).setLayoutConstraint(this,
				getFigure(), constraint);
	}

	public void propertyChange(PropertyChangeEvent evt) {
		if ("addChild".equals(evt.getPropertyName())
				|| "removeChild".equals(evt.getPropertyName())) {
			refreshChildren();
		}
		if ("widthTabName".equals(evt.getPropertyName())) {
			// ^u^Cg̕ύXꂽAʏ̃^uĕ`
			for (Iterator it = this.getChildren().iterator(); it != null
					&& it.hasNext();) {
				Object child = it.next();
				if (child instanceof TabEditPart) {
					((TabEditPart) child)
							.selfLayout((String) evt.getNewValue());
				}
			}
		}
		refreshVisuals();
	}
}
