/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PropertyPage;

public class MaskatProjectPropertyPage extends PropertyPage implements
		IWorkbenchPreferencePage {

	IProject project = null;

	// vWFNgvpeBɂ̃L[ŃXL[}ۑtH_Ă
	public static final QualifiedName SCHEMA_FOLDER_PROPERTY = new QualifiedName("name",
			"schema_generate_folder");

	public static final QualifiedName SCHEMA_GENERATE_PROPERTY = new QualifiedName(
			"name", "schema_generate_confirm");

	Text text = null;

	Button btnYes, btnNo, btnConfirm;

	protected Control createContents(Composite parent) {
		Group prefGroup = new Group(parent, SWT.NONE);

		GridLayout layout = new GridLayout();
		layout.numColumns = 1;
		prefGroup.setLayout(layout);
		prefGroup.setText("maskat setting");
		GridData data = new GridData(GridData.FILL_BOTH);
		prefGroup.setLayoutData(data);

		Group schemaGroup = new Group(prefGroup, SWT.NONE);
		layout = new GridLayout();
		layout.numColumns = 3;
		schemaGroup.setLayout(layout);
		data = new GridData(GridData.FILL_HORIZONTAL);
		schemaGroup.setText("XL[}");
		schemaGroup.setLayoutData(data);

		btnYes = new Button(schemaGroup, SWT.RADIO);
		btnYes.setText("");
		btnNo = new Button(schemaGroup, SWT.RADIO | SWT.LEFT);
		btnNo.setText("Ȃ");
		btnConfirm = new Button(schemaGroup, SWT.RADIO);
		btnConfirm.setText("mF");

		try {
			String confirmOption = getProject().getPersistentProperty(
					SCHEMA_GENERATE_PROPERTY);
			if ("0".equals(confirmOption)) {
				btnYes.setSelection(true);
			} else if ("1".equals(confirmOption)) {
				btnNo.setSelection(true);
			} else {
				btnConfirm.setSelection(true);
			}
		} catch (CoreException e1) {
			ErrorDialog.openError(this.getShell(), "PersistentPropertyǂݍ", // ^Cg
					"PersistentPropertyǂݍݏ̎sɎs܂B", // G[bZ[W
					e1.getStatus());
			MaskatIDEPlugin.getDefault().getLog().log(e1.getStatus());
		}

		Label label = new Label(prefGroup, SWT.NONE);
		label.setText("XL[}tH_FiFvWFNgƂ̑΃pXAႦ΁Fuschema\\genvj");
		text = new Text(prefGroup, SWT.SINGLE);
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.widthHint = 200;
		text.setLayoutData(data);
		try {
			String value = getProject().getPersistentProperty(SCHEMA_FOLDER_PROPERTY);
			text.setText(value == null || value.trim().equals("") ? "schema" : value);
		} catch (CoreException e) {
			ErrorDialog.openError(this.getShell(), "PersistentPropertyǂݍ", // ^Cg
					"PersistentPropertyǂݍݏ̎sɎs܂B", // G[bZ[W
					e.getStatus());
			MaskatIDEPlugin.getDefault().getLog().log(e.getStatus());
		}

		return prefGroup;
	}

	public boolean performOk() {
		try {
			getProject().setPersistentProperty(SCHEMA_FOLDER_PROPERTY, text.getText());
			String toConfirm = null;
			if (btnYes.getSelection() == true) {
				toConfirm = "0";
			} else if (btnNo.getSelection() == true) {
				toConfirm = "1";
			} else if (btnConfirm.getSelection() == true) {
				toConfirm = "2";
			}
			getProject().setPersistentProperty(SCHEMA_GENERATE_PROPERTY, toConfirm);
		} catch (CoreException e) {
			ErrorDialog.openError(this.getShell(), "PersistentProperty", // ^Cg
					"PersistentPropertyݏ̎sɎs܂B", // G[bZ[W
					e.getStatus());
			MaskatIDEPlugin.getDefault().getLog().log(e.getStatus());
		}
		return true;
	}

	private IProject getProject() {
		if (this.project == null) {
			project = (IProject) (this.getElement().getAdapter(IProject.class));
		}
		return this.project;
	}

	public void init(IWorkbench workbench) {
	}
}
