/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.framework.screendef.xml;

import java.io.InputStream;
import java.util.Iterator;

import org.apache.commons.digester.RegexMatcher;
import org.apache.commons.digester.SimpleRegexMatcher;
import org.maskat.framework.screendef.ButtonDef;
import org.maskat.framework.screendef.CheckboxDef;
import org.maskat.framework.screendef.CodeLibDef;
import org.maskat.framework.screendef.ComboDef;
import org.maskat.framework.screendef.ComboItemDef;
import org.maskat.framework.screendef.DivHtmlDef;
import org.maskat.framework.screendef.DivSplitDef;
import org.maskat.framework.screendef.FrameDef;
import org.maskat.framework.screendef.GridCellDef;
import org.maskat.framework.screendef.GridDef;
import org.maskat.framework.screendef.GridHeaderDef;
import org.maskat.framework.screendef.GridLineDef;
import org.maskat.framework.screendef.ImageDef;
import org.maskat.framework.screendef.LabelDef;
import org.maskat.framework.screendef.LayoutDef;
import org.maskat.framework.screendef.MaskatDef;
import org.maskat.framework.screendef.PopupDef;
import org.maskat.framework.screendef.RadioDef;
import org.maskat.framework.screendef.RadioGroupDef;
import org.maskat.framework.screendef.RadioMemberDef;
import org.maskat.framework.screendef.SplitterDef;
import org.maskat.framework.screendef.TabFolderDef;
import org.maskat.framework.screendef.TabItemDef;
import org.maskat.framework.screendef.TextDef;
import org.maskat.framework.screendef.TreeNodeDef;
import org.maskat.framework.screendef.TreeViewDef;
import org.maskat.framework.screendef.WindowDef;
import org.maskat.ide.property.GridCellComboProperty;
import org.maskat.xml.MaskatRegexRules;
import org.maskat.xml.digester.MaskatDigester;
import org.maskat.xml.digester.rules.CustomizeComponentRule;

public class LayoutDefParser {

	public static MaskatDef parse(InputStream input) throws Exception {

		MaskatDigester digester = new MaskatDigester();

		// digester.setValidating(false);
		digester.setNamespaceAware(true);
		RegexMatcher m = new SimpleRegexMatcher();
		digester.setRules(new MaskatRegexRules(m));

		digester.addObjectCreate("layoutDef", null, MaskatDef.class);

		digester.addCallMethod("layoutDef/javaScriptGlobal", "addJavaScriptGlobal", 0);

		digester.addObjectCreate("*/layout", null, LayoutDef.class);
		digester.addSetLayoutProperties("*/layout");
		digester.addSetNext("*/layout", "addChild", Object.class.getName());

		digester.addCallMethod("*/desc", "addDesc", 0);

		digester.addObjectCreate("*/divHtml", null, DivHtmlDef.class);
		digester.addCallMethod("*/divHtml", "setHtml", 0);
		digester.addSetLayoutProperties("*/divHtml");
		digester.addSetNext("*/divHtml", "addChild", Object.class.getName());

		digester.addCallMethod("*/javaScript", "addJavaScript", 0);

		digester.addCallMethod("*/layout/objs", "addObjs", 0);

		digester.addObjectCreate("*/window", null, WindowDef.class);
		digester.addSetLayoutProperties("*/window");
		digester.addSetNext("*/window", "addChild", WindowDef.class.getName());

		digester.addObjectCreate("*/frame", null, FrameDef.class);
		digester.addSetLayoutProperties("*/frame");
		digester.addSetNext("*/frame", "addChild", FrameDef.class.getName());

		// digester.addObjectCreate("*/alert", null, AlertDef.class);
		// digester.addSetLayoutProperties("*/alert");
		// digester.addSetNext("*/alert", "addChild", AlertDef.class.getName());

		digester.addObjectCreate("*/button", null, ButtonDef.class);
		digester.addSetLayoutProperties("*/button");
		digester.addSetNext("*/button", "addChild", ButtonDef.class.getName());

		digester.addObjectCreate("*/label", null, LabelDef.class);
		digester.addSetLayoutProperties("*/label");
		digester.addSetNext("*/label", "addChild", LabelDef.class.getName());

		digester.addObjectCreate("*/text", null, TextDef.class);
		digester.addSetLayoutProperties("*/text");
		digester.addSetNext("*/text", "addChild", TextDef.class.getName());

		// gridR|[lg
		digester.addObjectCreate("*/grid", null, GridDef.class);
		digester.addSetLayoutProperties("*/grid");
		digester.addSetNext("*/grid", "addChild", GridDef.class.getName());

		digester.addObjectCreate("*/gridHeader", null, GridHeaderDef.class);
		digester.addSetLayoutProperties("*/gridHeader");
		digester.addSetNext("*/gridHeader", "addChild", GridHeaderDef.class.getName());

		digester.addObjectCreate("*/gridHeader/gridCellCombo", null,
				GridCellComboProperty.class);
		digester.addSetLayoutProperties("*/gridHeader/gridCellCombo");
		digester.addSetNext("*/gridHeader/gridCellCombo", "addChild",
				GridCellComboProperty.class.getName());

		digester.addObjectCreate("*/gridLine", null, GridLineDef.class);
		digester.addSetLayoutProperties("*/gridLine");
		digester.addSetNext("*/gridLine", "addChild", GridLineDef.class.getName());

		digester.addObjectCreate("*/gridCell", null, GridCellDef.class);
		digester.addSetLayoutProperties("*/gridCell");
		digester.addSetNext("*/gridCell", "addChild", GridCellDef.class.getName());
		// gridR|[lg

		digester.addObjectCreate("*/checkbox", null, CheckboxDef.class);
		digester.addSetLayoutProperties("*/checkbox");
		digester.addSetNext("*/checkbox", "addChild", CheckboxDef.class.getName());

		digester.addObjectCreate("*/radio", null, RadioDef.class);
		digester.addSetLayoutProperties("*/radio");
		digester.addSetNext("*/radio", "addChild", RadioDef.class.getName());

		// R{R|[lg
		digester.addObjectCreate("*/combo", null, ComboDef.class);
		digester.addSetLayoutProperties("*/combo");
		digester.addSetNext("*/combo", "addChild", ComboDef.class.getName());

		digester.addObjectCreate("*/combo/comboItem", null, ComboItemDef.class);
		digester.addSetLayoutProperties("*/combo/comboItem");
		digester
				.addSetNext("*/combo/comboItem", "addChild", ComboItemDef.class.getName());
		// R{R|[lg

		// ^uR|[lg
		digester.addObjectCreate("*/tabFolder", null, TabFolderDef.class);
		digester.addSetLayoutProperties("*/tabFolder");
		digester.addSetNext("*/tabFolder", "addChild", TabFolderDef.class.getName());

		digester.addObjectCreate("*/tabItem", null, TabItemDef.class);
		digester.addSetLayoutProperties("*/tabItem");
		digester.addSetNext("*/tabItem", "addChild", TabItemDef.class.getName());
		// ^uR|[lg

		// C[W
		digester.addObjectCreate("*/image", null, ImageDef.class);
		digester.addSetLayoutProperties("*/image");
		digester.addSetNext("*/image", "addChild", ImageDef.class.getName());
		// C[W

		// R[hCu
		digester.addObjectCreate("*/codeLib", null, CodeLibDef.class);
		digester.addSetLayoutProperties("*/codeLib");
		digester.addSetNext("*/codeLib", "addChild", CodeLibDef.class.getName());
		// R[hCu

		// splitter
		digester.addObjectCreate("*/splitter", null, SplitterDef.class);
		digester.addSetLayoutProperties("*/splitter");
		digester.addSetNext("*/splitter", "addChild", SplitterDef.class.getName());

		digester.addObjectCreate("*/divSplit", null, DivSplitDef.class);
		digester.addSetLayoutProperties("*/divSplit");
		digester.addSetNext("*/divSplit", "addChild", DivSplitDef.class.getName());
		// splitter

		// c[
		digester.addObjectCreate("*/treeview", null, TreeViewDef.class);
		digester.addSetLayoutProperties("*/treeview");
		digester.addSetNext("*/treeview", "addChild", TreeViewDef.class.getName());
		// c[

		// c[m[h
		digester.addObjectCreate("*/treeNode", null, TreeNodeDef.class);
		digester.addSetLayoutProperties("*/treeNode");
		digester.addSetNext("*/treeNode", "addChild", TreeNodeDef.class.getName());
		// c[m[h

		// |bvAbv
		digester.addObjectCreate("*/popup", null, PopupDef.class);
		digester.addSetLayoutProperties("*/popup");
		digester.addSetNext("*/popup", "addChild", PopupDef.class.getName());
		// |bvAbv

		digester.addObjectCreate("*/layout/radioGroup", null, RadioGroupDef.class);
		digester.addSetProperties("*/layout/radioGroup");
		digester.addSetNext("*/layout/radioGroup", "addChild", RadioGroupDef.class
				.getName());

		digester.addObjectCreate("*/layout/radioGroup/radioMember", null,
				RadioMemberDef.class);
		digester.addSetProperties("*/layout/radioGroup/radioMember");
		digester.addSetNext("*/layout/radioGroup/radioMember", "addChild",
				RadioMemberDef.class.getName());

		// !! */* [͈ԍŌɒ`邱Ƃ𒍈ӁI!
		digester.addRule("*/*", new CustomizeComponentRule());
		// digester.addSetProperties("*/*");
		digester.addSetNext("*/*", "addChild", Object.class.getName());

		MaskatDef maskatDef = (MaskatDef) digester.parse(input);

		// ł́AdigesterprefixnamespaceURĨ}bvoオ̂
		// MaskatDefɈꎞۑ
		maskatDef.setNamespaces(digester.getNamespaceMap());
		// List layoutList = maskatDef.getLayoutList();
		// if (layoutList == null || layoutList.size() != 1) {
		// throw new Exception("CAEg`XMLɂlayoutvf`ł܂B");
		// }

		Iterator it = maskatDef.getTypedChildren(LayoutDef.class);
		boolean hasLayout = false;
		while (it.hasNext()) {
			hasLayout = true;
			((LayoutDef) it.next()).unpackRadioGroup();
		}
		if (!hasLayout) {
			maskatDef.addChild(new LayoutDef());
		}
		return maskatDef;
	}
}
