/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.framework.screendef.customize;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * The proxy for a customized component. Holds the attribute data for the
 * customized component, and the configuration of the customized component.
 * 
 * @author shengshen
 * 
 */
public class PluginDefProxy {

	/**
	 * The prefix in the xml instance.
	 */
	private String prefix = null;

	/**
	 * The map of the customized component's data.
	 */
	private Map properties;

	/**
	 * Configuration info for the customized component.
	 */
	private IComponentPluginConfig config;

	PluginDefProxy(IComponentPluginConfig config, String prefix) {
		this.config = config;
		this.prefix = prefix;
	}

	public String getPrefix() {
		return prefix;
	}

	public void setPrefix(String prefix) {
		this.prefix = prefix;
	}

	public String getNodeName() {
		return config.getNodeName();
	}

	public String getQName() {
		if (prefix != null)
			return prefix + ":" + config.getNodeName();
		return config.getNodeName();
	}

	void setConfig(IComponentPluginConfig config) {
		this.config = config;
	}

	public String getProperty(String key) {
		if (properties == null)
			return null;
		return (String) properties.get(key);
	}

	public void setProperty(String key, String value) {
		if (properties == null)
			properties = new HashMap();
		properties.put(key, value);
	}

	public Iterator getAttributeNames() {
		// property name should not be used directly as attribute name.
		// for example onclick....
		return config.getAttributeNames();
	}

	public String getNamespace() {
		return config.getNamespace();
	}

	public IContentFactory getContentFactory() {
		return config.getContentFactory();
	}

	public boolean hasEvent(String eventName) {
		return config.hasEvent(eventName);
	}
}