/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.framework.eventdef;

import java.util.Iterator;

import org.maskat.framework.BasicDef;

public class Param extends BasicDef {
	public Param() {
		this(true);
	}

	public Param(boolean enable) {
		this.enable = enable;
	}

	private String rootNode;

	private String ns;

	private String soap;

	private boolean enable;

	// public boolean equals(Object obj) {
	// if (obj == this)
	// return true;
	// if (!(obj instanceof Param))
	// return false;
	//
	// Param o = (Param) obj;
	// if (!CUtil.isStrEqual(rootNode, o.rootNode))
	// return false;
	// if (!CUtil.isStrEqual(ns, o.ns))
	// return false;
	//
	// return super.contentEquals(obj);
	//
	// }

	public boolean isEnable() {
		return enable;
	}

	public void setEnable(boolean enable) {
		this.enable = enable;
	}

	public String getNs() {
		return ns;
	}

	public void setNs(String ns) {
		this.ns = ns;
	}

	public String getRootNode() {
		return rootNode;
	}

	public void setRootNode(String rootNode) {
		this.rootNode = rootNode;
	}

	public Iterator getSourcesIt() {
		return this.getTypedChildren(Source.class);
	}

	public void removeAllSources() {
		this.removeAllByType(Source.class);
	}

	public String getSoap() {
		return soap;
	}

	public void setSoap(String soap) {
		this.soap = soap;
	}

}
