/*
 * Decompiled with CFR 0.152.
 */
package org.maskat.ide.view;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetSorter;
import org.maskat.ide.editors.MaskatEditor;
import org.maskat.ide.editors.MaskatTextEditor;
import org.maskat.ide.view.MaskatEditView;

public class MaskatPropertySheetPage
extends PropertySheetPage {
    private static List names = new ArrayList();
    private static PropertySheetSorter inst;

    static {
        names.add("name");
        names.add("left");
        names.add("top");
        names.add("width");
        names.add("height");
        inst = new MaskatPropertySheetSorter();
    }

    public MaskatPropertySheetPage() {
        this.setSorter(inst);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part instanceof MaskatEditor) {
            MaskatEditor maskatEditor = (MaskatEditor)part;
            if (maskatEditor.editMode == 1) {
                super.selectionChanged(part, selection);
                maskatEditor.setLastSelectionForEdit(selection);
            }
        } else if (part instanceof MaskatEditView) {
            super.selectionChanged(part, selection);
        } else {
            if (part instanceof MaskatTextEditor) {
                return;
            }
            super.selectionChanged(part, (ISelection)StructuredSelection.EMPTY);
        }
    }

    private static class MaskatPropertySheetSorter
    extends PropertySheetSorter {
        private MaskatPropertySheetSorter() {
        }

        private int getIndex(String str) {
            int idx = names.indexOf(str);
            if (idx >= 0) {
                return idx;
            }
            return Integer.MAX_VALUE;
        }

        public int compare(IPropertySheetEntry entryA, IPropertySheetEntry entryB) {
            int idxA = this.getIndex(entryA.getDisplayName());
            int idxB = this.getIndex(entryB.getDisplayName());
            return idxA - idxB;
        }
    }
}

