/*
 * Decompiled with CFR 0.152.
 */
package org.maskat.ide.gef.figure;

import java.util.Iterator;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;
import org.maskat.framework.screendef.GridDef;
import org.maskat.framework.screendef.GridHeaderDef;
import org.maskat.ide.gef.editparts.GridHeaderEditPart;

public class MaskatGridFigure
extends Label {
    private GridDef grid;

    public MaskatGridFigure(GridDef grid) {
        this.grid = grid;
    }

    protected void paintFigure(Graphics graphics) {
        Iterator headersIt;
        super.paintFigure(graphics);
        graphics.translate(this.bounds.x, this.bounds.y);
        if (this.grid.getName() != null) {
            graphics.drawText(this.grid.getName(), 0, 0);
        }
        if ((headersIt = this.grid.getHeadersIt()) != null) {
            int currentX = 0;
            while (headersIt.hasNext()) {
                GridHeaderDef header = (GridHeaderDef)headersIt.next();
                graphics.drawLine(currentX += GridHeaderEditPart.toHeaderDisplayWidth(header.getWidth()), 21, currentX, this.grid.getHeight());
            }
            int lineHeight = 0;
            try {
                lineHeight = Integer.parseInt(this.grid.getLineHeight());
            }
            catch (NumberFormatException numberFormatException) {}
            lineHeight = Math.max(lineHeight, 5);
            int currentY = 41;
            int headerTotalWidth = this.grid.headerTotalWidth();
            while (currentY <= this.grid.getHeight()) {
                graphics.drawLine(0, currentY, headerTotalWidth, currentY);
                currentY += lineHeight;
            }
        }
        graphics.translate(-this.bounds.x, -this.bounds.y);
    }
}

