/*
 * Decompiled with CFR 0.152.
 */
package org.maskat.ide.gef.editparts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.swt.widgets.Display;
import org.maskat.framework.screendef.TabFolderDef;
import org.maskat.ide.gef.editparts.TabFolderEditPart;
import org.maskat.ide.gef.editpolicies.LabelDirectEditPolicy;
import org.maskat.ide.gef.editpolicies.TabEditPolicy;
import org.maskat.ide.gef.figure.TabFigure;
import org.maskat.ide.gef.models.TabDef;
import org.maskat.ide.gef.tools.TextCellEditorLocator;
import org.maskat.ide.gef.tools.TextDirectEditManager;

public class TabEditPart
extends AbstractGraphicalEditPart
implements PropertyChangeListener {
    public static final int minimalTabDisplayWidth = 10;
    TabFigure tabFigure;

    public void activate() {
        super.activate();
        TabDef model = (TabDef)this.getModel();
        model.addPropertyChangeListener(this);
    }

    public void deactivate() {
        TabDef model = (TabDef)this.getModel();
        model.removePropertyChangeListener(this);
        super.deactivate();
    }

    protected IFigure createFigure() {
        final TabDef tab = (TabDef)this.getModel();
        this.tabFigure = new TabFigure(tab.getName());
        this.tabFigure.setText(tab.getTitle());
        this.tabFigure.setBorder((Border)new CompoundBorder((Border)new LineBorder(), (Border)new MarginBorder(0)));
        this.tabFigure.setForegroundColor(Display.getCurrent().getSystemColor(15));
        this.tabFigure.setCursor(Cursors.HAND);
        this.tabFigure.addMouseListener((MouseListener)new MouseListener.Stub(){

            public void mousePressed(MouseEvent me) {
                TabFolderEditPart tabFolder = (TabFolderEditPart)TabEditPart.this.getParent();
                tabFolder.switchToPage(tab.getName());
            }
        });
        return this.tabFigure;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new TabEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new LabelDirectEditPolicy());
    }

    protected void refreshVisuals() {
        TabDef tab = (TabDef)this.getModel();
        TabFolderDef tabFolderDef = (TabFolderDef)tab.getParent();
        this.selfLayout(tabFolderDef.getWidthTabName());
    }

    public void selfLayout(String widthTabName) {
        TabDef tab = (TabDef)this.getModel();
        TabFolderDef tabFolderDef = (TabFolderDef)tab.getParent();
        int idx = tabFolderDef.getTabIdxByName(tab.getName());
        int tabWidth = TabEditPart.toTabDisplayWidth(widthTabName);
        Rectangle constraint = new Rectangle(idx * tabWidth, 0, tabWidth, 15);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)constraint);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("title".equals(evt.getPropertyName())) {
            TabFigure tabFig = (TabFigure)this.getFigure();
            tabFig.setText((String)evt.getNewValue());
        }
    }

    public static int toTabDisplayWidth(String widthTabName) {
        try {
            int width = Integer.parseInt(widthTabName);
            return Math.max(width, 10);
        }
        catch (NumberFormatException numberFormatException) {
            return 10;
        }
    }

    public void performRequest(Request req) {
        if ("open".equals(req.getType())) {
            new TextDirectEditManager((GraphicalEditPart)this, null, new TextCellEditorLocator(this.getFigure())).show();
        }
    }
}

