/*
 * Decompiled with CFR 0.152.
 */
package org.maskat.ide.gef.editparts;

import java.util.Iterator;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.maskat.framework.screendef.GridDef;
import org.maskat.framework.screendef.GridHeaderDef;
import org.maskat.ide.gef.editpolicies.LabelDirectEditPolicy;
import org.maskat.ide.gef.editpolicies.MaskatComponentEditPolicy;
import org.maskat.ide.gef.tools.TextCellEditorLocator;
import org.maskat.ide.gef.tools.TextDirectEditManager;

public class GridHeaderEditPart
extends AbstractGraphicalEditPart {
    public static final int headerHeight = 20;
    public static final int headerTop = 20;
    public static final int minimalHeaderDisplayWidth = 10;

    protected IFigure createFigure() {
        Label label = new Label();
        label.setBorder((Border)new CompoundBorder((Border)new LineBorder(), (Border)new MarginBorder(0)));
        return label;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new MaskatComponentEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new LabelDirectEditPolicy());
    }

    protected void refreshVisuals() {
        ((Label)this.getFigure()).setText(((GridHeaderDef)this.getModel()).getTitle());
        Object model = this.getModel();
        if (model instanceof GridHeaderDef) {
            GridHeaderDef gridHeader = (GridHeaderDef)this.getModel();
            int idx = gridHeader.idxInParent();
            GridDef grid = gridHeader.getParent();
            Iterator headersIt = grid.getHeadersIt();
            if (headersIt != null) {
                int left = 0;
                int i = 0;
                while (i < idx) {
                    int headerWidth = GridHeaderEditPart.toHeaderDisplayWidth(((GridHeaderDef)headersIt.next()).getWidth());
                    left += headerWidth;
                    ++i;
                }
                Rectangle constraint = new Rectangle(left, 20, GridHeaderEditPart.toHeaderDisplayWidth(gridHeader.getWidth()), 20);
                ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)constraint);
            }
        }
    }

    public static int toHeaderDisplayWidth(String headerWidth) {
        try {
            int width = Integer.parseInt(headerWidth);
            return Math.max(width, 10);
        }
        catch (NumberFormatException numberFormatException) {
            return 10;
        }
    }

    public void performRequest(Request req) {
        if ("open".equals(req.getType())) {
            new TextDirectEditManager((GraphicalEditPart)this, null, new TextCellEditorLocator(this.getFigure())).show();
        }
    }
}

