/*
 * Decompiled with CFR 0.152.
 */
package org.maskat.ide.gef.commands;

import org.eclipse.gef.commands.Command;
import org.maskat.framework.IBasicDef;
import org.maskat.framework.eventdef.Component;
import org.maskat.framework.eventdef.Layout;
import org.maskat.framework.screendef.IComponentDef;
import org.maskat.framework.screendef.TabFolderDef;
import org.maskat.framework.screendef.TabItemDef;
import org.maskat.ide.gef.models.TabDef;

public class DelBasicDefCommand
extends Command {
    private IBasicDef parent;
    private IBasicDef child;
    private int idx;
    private Layout layout;
    private Component comp;
    private boolean noAction = false;

    public DelBasicDefCommand(IBasicDef parent, IBasicDef child) {
        this.parent = parent;
        this.child = child;
    }

    public void execute() {
        this.idx = this.parent.getChildIdx(this.child);
        if (this.idx == -1) {
            if ((this.child instanceof TabItemDef || this.child instanceof TabDef) && this.parent instanceof TabFolderDef) {
                this.noAction = true;
                return;
            }
            throw new IllegalStateException("Cannot delete without child-parent relationship.");
        }
        this.parent.removeChild(this.child);
        if (this.child instanceof IComponentDef) {
            IComponentDef comDef = (IComponentDef)this.child;
            Layout[] layouts = comDef.getLayoutDef().getLayoutEvtDefSrc().getDefs();
            int i = 0;
            while (i < layouts.length) {
                Component comp = layouts[i].findComponent(comDef.getName());
                if (layouts[i].findComponent(comDef.getName()) != null) {
                    this.layout = layouts[i];
                    this.comp = comp;
                    layouts[i].removeChild(comp);
                    return;
                }
                ++i;
            }
        }
    }

    public void undo() {
        if (this.noAction) {
            return;
        }
        this.parent.addChildToIdx(this.child, this.idx);
        if (this.layout != null) {
            this.layout.addChild(this.comp);
        }
    }

    public boolean canUndo() {
        return true;
    }
}

