/*
 * Decompiled with CFR 0.152.
 */
package org.maskat.ide.editors.linkeventsrc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.maskat.framework.eventdef.Component;
import org.maskat.framework.eventdef.Event;
import org.maskat.framework.eventdef.IEventDefSource;
import org.maskat.framework.eventdef.Layout;
import org.maskat.framework.eventdef.Param;
import org.maskat.framework.eventdef.Result;
import org.maskat.framework.eventdef.xml.EventDefParser;
import org.maskat.framework.eventdef.xml.EventDefXmlSerializer;
import org.maskat.ide.editors.linkeventsrc.LinkConfig;
import org.maskat.ide.property.ComponentProperty;
import org.maskat.ide.property.LayoutProperty;
import org.xml.sax.SAXException;

public class LinkEventDefSource
implements IEventDefSource {
    private List eventDefs = new ArrayList();
    private List eventFiles = new ArrayList();

    public LinkEventDefSource(IFile layoutFile) {
        IPath path = layoutFile.getProjectRelativePath();
        String layoutFileName = path.lastSegment();
        IPath directory = path.removeLastSegments(1);
        IPath linkFilePath = ((IPath)directory.clone()).append("link.xml");
        IProject project = layoutFile.getProject();
        IFile linkFile = project.getFile(linkFilePath);
        if (linkFile.exists()) {
            InputStream stream = null;
            try {
                try {
                    stream = linkFile.getContents();
                    LinkConfig config = LinkConfig.load(stream);
                    String[] eventFileNames = config.findEventFileNames(layoutFileName);
                    if (eventFileNames != null && eventFileNames.length != 0) {
                        int i = 0;
                        while (i < eventFileNames.length) {
                            IPath eventFilePath = ((IPath)directory.clone()).append(eventFileNames[i]);
                            IFile eventFile = project.getFile(eventFilePath);
                            this.eventFiles.add(eventFile);
                            ++i;
                        }
                    }
                }
                catch (Exception exception) {}
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (this.eventFiles.size() == 0) {
            int index = layoutFileName.lastIndexOf("xml") - 1;
            IPath _eFilePath = ((IPath)directory.clone()).append(String.valueOf(layoutFileName.substring(0, index)) + "_e.xml");
            this.eventFiles.add(project.getFile(_eFilePath));
        }
    }

    public Component findComponent(String componentName) {
        for (Layout layout : this.eventDefs) {
            Component result = layout.findComponent(componentName);
            if (result == null) continue;
            return result;
        }
        Layout layout = (Layout)this.eventDefs.get(0);
        ComponentProperty comp = new ComponentProperty();
        comp.setId(componentName);
        layout.addChild(comp);
        return comp;
    }

    public void load() throws Exception {
        for (IFile eventFile : this.eventFiles) {
            this.eventDefs.add(this.loadOneEventFile(eventFile));
        }
    }

    private Layout loadOneEventFile(IFile eventXmlFile) throws CoreException, IOException, SAXException {
        LayoutProperty layout = new LayoutProperty();
        InputStream eventXmlStream = null;
        try {
            eventXmlFile.refreshLocal(1, null);
            if (eventXmlFile.exists()) {
                eventXmlStream = eventXmlFile.getContents();
                layout = (LayoutProperty)EventDefParser.parse(eventXmlStream);
            }
        }
        finally {
            if (eventXmlStream != null) {
                eventXmlStream.close();
            }
        }
        return layout;
    }

    public String[] save() throws Exception {
        if (this.eventDefs == null) {
            return null;
        }
        ArrayList<String> eventDefString = new ArrayList<String>();
        int i = 0;
        while (i < this.eventDefs.size()) {
            Layout layout = (Layout)this.eventDefs.get(i);
            this.clearDisabledDefElement(layout);
            this.clearBlankComponent(layout);
            layout.shrinkEvent();
            String result = this.marshallObj(layout, (IFile)this.eventFiles.get(i), null);
            eventDefString.add(result);
            layout.prepareEvent();
            ++i;
        }
        return eventDefString.toArray(new String[eventDefString.size()]);
    }

    private String marshallObj(Object obj, IFile file, IProgressMonitor monitor) throws IOException, CoreException, UnsupportedEncodingException, XMLStreamException {
        StringWriter strWriter = new StringWriter(1024);
        EventDefXmlSerializer serializer = new EventDefXmlSerializer(obj, strWriter);
        serializer.write();
        String result = strWriter.toString();
        if (!file.exists()) {
            file.create((InputStream)new ByteArrayInputStream(new byte[0]), false, null);
        }
        file.setContents((InputStream)new ByteArrayInputStream(result.getBytes("UTF-8")), false, false, monitor);
        return result;
    }

    private void clearDisabledDefElement(Layout layout) {
        Iterator it = layout.getAllComponents();
        while (it != null && it.hasNext()) {
            Component comp = (Component)it.next();
            if (!comp.hasEvents()) continue;
            Iterator it2 = comp.getAllEvents();
            while (it2 != null && it2.hasNext()) {
                Event event = (Event)it2.next();
                if (!event.isEnable()) {
                    it2.remove();
                    continue;
                }
                if (!event.getParam().isEnable()) {
                    event.removeAllByType(Param.class);
                }
                if (event.getResult().isEnable()) continue;
                event.removeAllByType(Result.class);
            }
        }
        it = layout.getAllEvents();
        while (it != null && it.hasNext()) {
            Event event = (Event)it.next();
            if (!event.isEnable()) {
                it.remove();
                continue;
            }
            if (!event.getParam().isEnable()) {
                event.removeAllByType(Param.class);
            }
            if (event.getResult().isEnable()) continue;
            event.removeAllByType(Result.class);
        }
    }

    private void clearBlankComponent(Layout layout) {
        ArrayList<Component> compsToDel = new ArrayList<Component>();
        Iterator it = layout.getAllComponents();
        while (it != null && it.hasNext()) {
            Component comp = (Component)it.next();
            if (comp.hasEvents()) continue;
            compsToDel.add(comp);
        }
        int i = 0;
        while (i < compsToDel.size()) {
            layout.removeChild(compsToDel.get(i));
            ++i;
        }
    }

    public Layout[] getDefs() {
        return this.eventDefs.toArray(new Layout[this.eventDefs.size()]);
    }
}

