/*
 * Decompiled with CFR 0.152.
 */
package org.maskat.ide.editors;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Collections;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import org.eclipse.core.resources.IFile;
import org.maskat.framework.eventdef.IEventDefSource;
import org.maskat.framework.screendef.LayoutDef;
import org.maskat.framework.screendef.MaskatDef;
import org.maskat.framework.screendef.xml.LayoutDefParser;
import org.maskat.framework.screendef.xml.LayoutDefXmlSerializer;
import org.maskat.ide.editors.linkeventsrc.LinkEventDefSource;

public class EditorData {
    protected MaskatDef maskatDef = null;
    protected int layoutIdx = 0;
    IEventDefSource eventDefSource;
    private IFile layoutXmlFile;

    EditorData(IFile layoutXmlFile) {
        this.layoutXmlFile = layoutXmlFile;
    }

    LayoutDef getCurrentLayoutDef() {
        return (LayoutDef)this.maskatDef.getChildByTypeIdx(LayoutDef.class, this.layoutIdx);
    }

    void switchLayout(int theIdx) {
        this.layoutIdx = theIdx;
        this.connectLayoutEvent();
    }

    void connectLayoutEvent() {
        LayoutDef layoutDef = this.getCurrentLayoutDef();
        layoutDef.setLayoutEvtDefSrc(this.eventDefSource);
    }

    void loadLayout() throws Exception {
        InputStream inputS = null;
        try {
            if (this.layoutXmlFile.exists()) {
                inputS = this.layoutXmlFile.getContents();
                this.maskatDef = LayoutDefParser.parse(inputS);
            }
        }
        catch (Throwable throwable) {
            try {
                if (inputS != null) {
                    inputS.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (inputS != null) {
                inputS.close();
            }
        }
        catch (IOException iOException) {}
    }

    void loadEvent() throws Exception {
        this.eventDefSource = new LinkEventDefSource(this.layoutXmlFile);
        this.eventDefSource.load();
    }

    public Iterator getLayouts() {
        if (this.maskatDef == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.maskatDef.getTypedChildren(LayoutDef.class);
    }

    void writeLayout(Writer writer) throws XMLStreamException, CloneNotSupportedException {
        LayoutDefXmlSerializer serializer = new LayoutDefXmlSerializer((MaskatDef)this.maskatDef.clone(), writer);
        serializer.write();
    }

    String[] writeEvent() throws Exception {
        return this.eventDefSource.save();
    }
}

