/*
 * Decompiled with CFR 0.152.
 */
package org.maskat.framework.screendef;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.maskat.framework.IBasicDefVisitor;
import org.maskat.framework.eventdef.IEventDefSource;
import org.maskat.framework.screendef.BasicDefVisitorForSimilarName;
import org.maskat.framework.screendef.ContainerDef;
import org.maskat.framework.screendef.IComponentDef;
import org.maskat.framework.screendef.MaskatDef;
import org.maskat.framework.screendef.RadioDef;
import org.maskat.framework.screendef.RadioGroupDef;
import org.maskat.framework.screendef.RadioMemberDef;

public class LayoutDef
extends ContainerDef {
    private String objs = "";
    private String refParentHTML;
    private IEventDefSource layoutEvtDefSrc;
    private MaskatDef maskatDef;

    public void setAppropriateNameForComponent(IComponentDef comp) {
        String originalName = comp.getName();
        BasicDefVisitorForSimilarName visitor = new BasicDefVisitorForSimilarName(originalName);
        this.accept(visitor);
        if (visitor.hasResult()) {
            int i = 1;
            String suggestName = String.valueOf(originalName) + i;
            while (visitor.resultContains(suggestName)) {
                suggestName = String.valueOf(originalName) + ++i;
            }
            comp.setName(suggestName);
        }
    }

    public IEventDefSource getLayoutEvtDefSrc() {
        return this.layoutEvtDefSrc;
    }

    public void setLayoutEvtDefSrc(IEventDefSource layoutEvtDefSrc) {
        this.layoutEvtDefSrc = layoutEvtDefSrc;
    }

    public LayoutDef getLayoutDef() {
        return this;
    }

    public String getRefParentHTML() {
        return this.refParentHTML;
    }

    public void setRefParentHTML(String refParentHTML) {
        this.refParentHTML = refParentHTML;
    }

    public MaskatDef getMaskatDef() {
        return this.maskatDef;
    }

    public void setMaskatDef(MaskatDef maskatDef) {
        this.maskatDef = maskatDef;
    }

    public String getObjs() {
        return this.objs;
    }

    public void addObjs(String objs) {
        this.objs = String.valueOf(this.objs) + objs + ",";
    }

    public void unpackRadioGroup() {
        Iterator it = this.getTypedChildren(RadioGroupDef.class);
        if (it == null) {
            return;
        }
        final HashMap<String, String> nameToGroupMap = new HashMap<String, String>();
        while (it.hasNext()) {
            RadioGroupDef rg = (RadioGroupDef)it.next();
            String groupName = rg.getName();
            Iterator memberIt = rg.getTypedChildren(RadioMemberDef.class);
            while (memberIt != null && memberIt.hasNext()) {
                RadioMemberDef member = (RadioMemberDef)memberIt.next();
                if (member.getRef() == null) continue;
                nameToGroupMap.put(member.getRef(), groupName);
            }
        }
        if (nameToGroupMap.size() > 0) {
            this.accept(new IBasicDefVisitor(){

                public void visit(Object def) {
                    if (def instanceof RadioDef) {
                        RadioDef radioDef = (RadioDef)def;
                        radioDef.setGroup((String)nameToGroupMap.get(radioDef.getName()));
                    }
                }
            });
        }
    }

    public void packRadioGroup() {
        final HashMap<String, RadioGroupDef> radioGroupMap = new HashMap<String, RadioGroupDef>();
        Iterator it = this.getTypedChildren(RadioGroupDef.class);
        while (it != null && it.hasNext()) {
            RadioGroupDef rgDef = (RadioGroupDef)it.next();
            rgDef.removeAllByType(RadioMemberDef.class);
            radioGroupMap.put(rgDef.getName(), rgDef);
        }
        this.accept(new IBasicDefVisitor(){

            public void visit(Object def) {
                if (def instanceof RadioDef) {
                    RadioDef radioDef = (RadioDef)def;
                    String group = radioDef.getGroup();
                    if (group == null || "".equals(group)) {
                        return;
                    }
                    RadioGroupDef radioGroup = (RadioGroupDef)radioGroupMap.get(group);
                    if (radioGroup == null) {
                        radioGroup = new RadioGroupDef();
                        radioGroup.setName(group);
                        radioGroupMap.put(group, radioGroup);
                    }
                    radioGroup.addMember(radioDef.getName());
                }
            }
        });
        ArrayList<RadioGroupDef> radioGroupToDel = new ArrayList<RadioGroupDef>();
        Iterator it2 = this.getTypedChildren(RadioGroupDef.class);
        while (it2 != null && it2.hasNext()) {
            RadioGroupDef rgDef = (RadioGroupDef)it2.next();
            Iterator rgChildIt = rgDef.getAllChildren();
            if (rgChildIt != null && rgChildIt.hasNext()) continue;
            radioGroupToDel.add(rgDef);
        }
        int i = 0;
        while (i < radioGroupToDel.size()) {
            this.removeChild(radioGroupToDel.get(i));
            ++i;
        }
    }

    public RadioGroupDef findRadioGroupDef(String group) {
        Iterator it = this.getTypedChildren(RadioGroupDef.class);
        while (it != null && it.hasNext()) {
            RadioGroupDef rgd = (RadioGroupDef)it.next();
            if (rgd.getName() == null || !rgd.getName().equals(group)) continue;
            return rgd;
        }
        return null;
    }

    public RadioGroupDef createRadioGroupDef(String group) {
        RadioGroupDef newOne = new RadioGroupDef();
        newOne.setName(group);
        this.addChildToIdx(newOne, 0);
        return newOne;
    }

    public void removeRadioMemberFromGroup(String groupName, String memberName) {
        if (groupName == null || memberName == null) {
            return;
        }
        RadioGroupDef rgd = this.findRadioGroupDef(groupName);
        if (rgd == null) {
            return;
        }
        RadioMemberDef rmd = null;
        Iterator it = rgd.getTypedChildren(RadioMemberDef.class);
        while (it != null && it.hasNext()) {
            rmd = (RadioMemberDef)it.next();
            if (memberName.equals(rmd.getRef())) break;
        }
        if (rmd != null) {
            rgd.removeChild(rmd);
        }
    }
}

