/*
 * Decompiled with CFR 0.152.
 */
package org.maskat.framework.eventdef.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.xmlbeans.XmlException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.maskat.framework.eventdef.xml.EventDefParser;
import org.maskat.ide.MaskatIDEUtil;
import org.maskat.ide.MaskatProjectPropertyPage;
import org.maskat.xml.xmlbeans.InstToXsd;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TelegramSchemaGenerator {
    public static void generate(InputStream eventDef, IProject project, IPath path) throws CoreException, TransformerException, ParserConfigurationException, SAXException, IOException, XmlException {
        NodeList list = EventDefParser.genTeleInstanceFromEventDef(eventDef, "org/maskat/framework/eventdef/xml/ruleSplitByTele.xsl");
        if (list != null) {
            int i = 0;
            while (i < list.getLength()) {
                Node node = list.item(i);
                String componentID = node.getAttributes().getNamedItem("component").getNodeValue();
                String eventID = node.getAttributes().getNamedItem("event").getNodeValue();
                String nodeName = node.getNodeName();
                String fileName = String.valueOf(componentID) + "_" + eventID + "_" + nodeName + ".xsd";
                Node teleNode = node.getChildNodes().item(0);
                if (teleNode != null) {
                    ByteArrayOutputStream bo = new ByteArrayOutputStream(512);
                    try {
                        String targetPath = project.getPersistentProperty(MaskatProjectPropertyPage.SCHEMA_FOLDER_PROPERTY);
                        if (targetPath == null || "".equals(targetPath.trim())) {
                            targetPath = "schema";
                        }
                        String folderName = String.valueOf(targetPath) + "\\" + componentID + "\\" + eventID + "\\" + nodeName + "\\";
                        MaskatIDEUtil.createFolder(project, folderName);
                        IFile outputFile = project.getFile(String.valueOf(folderName) + fileName);
                        if (!outputFile.exists()) {
                            outputFile.create((InputStream)new ByteArrayInputStream(new byte[0]), false, null);
                        }
                        InstToXsd.transfer(bo, teleNode);
                        String xsdStr = bo.toString("UTF-8");
                        outputFile.setContents((InputStream)new ByteArrayInputStream(xsdStr.getBytes("UTF-8")), false, false, null);
                    }
                    finally {
                        bo.close();
                    }
                }
                ++i;
            }
        }
    }
}

