/*
 * Decompiled with CFR 0.152.
 */
package org.maskat.framework.eventdef.xml;

import java.io.Writer;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.maskat.framework.BasicDef;
import org.maskat.framework.IBasicDef;
import org.maskat.framework.eventdef.Bind;
import org.maskat.framework.eventdef.Component;
import org.maskat.framework.eventdef.Event;
import org.maskat.framework.eventdef.EventRef;
import org.maskat.framework.eventdef.Header;
import org.maskat.framework.eventdef.Layout;
import org.maskat.framework.eventdef.Param;
import org.maskat.framework.eventdef.RemoteUrl;
import org.maskat.framework.eventdef.Result;
import org.maskat.framework.eventdef.Source;
import org.maskat.framework.eventdef.Target;
import org.maskat.framework.screendef.DescDef;
import org.maskat.xml.DefXmlSerializer;

public class EventDefXmlSerializer
extends DefXmlSerializer {
    public EventDefXmlSerializer(Object def, Writer writer) {
        super(def, writer);
    }

    protected void customizeWrite(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeDTD("<!DOCTYPE eventDef SYSTEM \"eventDef.dtd\">");
    }

    protected String getElementName(Object def) {
        if (def instanceof DescDef) {
            return "desc";
        }
        if (def instanceof Layout) {
            return "eventDef";
        }
        if (def instanceof RemoteUrl) {
            return "remoteUrl";
        }
        if (def instanceof Header) {
            return "header";
        }
        if (def instanceof Component) {
            return "component";
        }
        if (def instanceof EventRef) {
            return "eventRef";
        }
        if (def instanceof Event) {
            return "event";
        }
        if (def instanceof Param) {
            return "param";
        }
        if (def instanceof Source) {
            return "source";
        }
        if (def instanceof Bind) {
            return "bind";
        }
        if (def instanceof Result) {
            return "result";
        }
        if (def instanceof Target) {
            return "target";
        }
        return null;
    }

    protected void writeDefAttribute(XMLStreamWriter writer, Object def) throws XMLStreamException {
        BasicDef theDef;
        if (def instanceof Layout) {
            theDef = (Layout)def;
            EventDefXmlSerializer.writeOneAttribute(writer, "id", ((Layout)theDef).getId());
        }
        if (def instanceof RemoteUrl) {
            theDef = (RemoteUrl)def;
            EventDefXmlSerializer.writeOneAttribute(writer, "url", ((RemoteUrl)theDef).getUrl());
        }
        if (def instanceof Header) {
            theDef = (Header)def;
            EventDefXmlSerializer.writeOneAttribute(writer, "name", ((Header)theDef).getName());
            EventDefXmlSerializer.writeOneAttribute(writer, "value", ((Header)theDef).getValue());
        }
        if (def instanceof Component) {
            theDef = (Component)def;
            EventDefXmlSerializer.writeOneAttribute(writer, "id", ((Component)theDef).getId());
        }
        if (def instanceof EventRef) {
            theDef = (EventRef)def;
            EventDefXmlSerializer.writeOneAttribute(writer, "id", ((EventRef)theDef).getRefid());
        }
        if (def instanceof Event) {
            theDef = (Event)def;
            EventDefXmlSerializer.writeOneAttribute(writer, "id", ((Event)theDef).getId());
            EventDefXmlSerializer.writeOneAttribute(writer, "ref", ((Event)theDef).getRef());
            EventDefXmlSerializer.writeOneAttribute(writer, "confirmDialog", ((Event)theDef).getConfirmDialog());
            EventDefXmlSerializer.writeOneAttribute(writer, "start", ((Event)theDef).getStart());
            EventDefXmlSerializer.writeOneAttribute(writer, "before", ((Event)theDef).getBefore());
            EventDefXmlSerializer.writeOneAttribute(writer, "after", ((Event)theDef).getAfter());
            EventDefXmlSerializer.writeOneAttribute(writer, "finish", ((Event)theDef).getFinish());
            EventDefXmlSerializer.writeOneAttribute(writer, "endDialog", ((Event)theDef).getEndDialog());
            EventDefXmlSerializer.writeOneAttribute(writer, "type", ((Event)theDef).getType());
            EventDefXmlSerializer.writeOneAttribute(writer, "async", ((Event)theDef).getAsync());
            EventDefXmlSerializer.writeOneAttribute(writer, "remoteUrl", ((Event)theDef).getRemoteUrl());
            EventDefXmlSerializer.writeOneAttribute(writer, "timeout", ((Event)theDef).getTimeout());
            EventDefXmlSerializer.writeOneAttribute(writer, "onTimeoutError", ((Event)theDef).getOnTimeoutError());
        }
        if (def instanceof Param) {
            theDef = (Param)def;
            EventDefXmlSerializer.writeOneAttribute(writer, "rootNode", ((Param)theDef).getRootNode());
            EventDefXmlSerializer.writeOneAttribute(writer, "ns", ((Param)theDef).getNs());
            EventDefXmlSerializer.writeOneAttribute(writer, "soap", ((Param)theDef).getSoap());
        }
        if (def instanceof Source) {
            theDef = (Source)def;
            EventDefXmlSerializer.writeOneAttribute(writer, "obj", ((Source)theDef).getObj());
            EventDefXmlSerializer.writeOneAttribute(writer, "node", ((Source)theDef).getNode());
            EventDefXmlSerializer.writeOneAttribute(writer, "idxRef", ((Source)theDef).getIdxRef());
            EventDefXmlSerializer.writeOneAttribute(writer, "childNode", ((Source)theDef).getChildNode());
            EventDefXmlSerializer.writeOneAttribute(writer, "fromkey", ((Source)theDef).getFromkey());
            EventDefXmlSerializer.writeOneAttribute(writer, "type", ((Source)theDef).getType());
            EventDefXmlSerializer.writeOneAttribute(writer, "desc", ((Source)theDef).getDesc());
            EventDefXmlSerializer.writeOneAttribute(writer, "min", ((Source)theDef).getMin());
            EventDefXmlSerializer.writeOneAttribute(writer, "max", ((Source)theDef).getMax());
            EventDefXmlSerializer.writeOneAttribute(writer, "regexp", ((Source)theDef).getRegexp());
            EventDefXmlSerializer.writeOneAttribute(writer, "teleType", ((Source)theDef).getTeleType());
            EventDefXmlSerializer.writeOneAttribute(writer, "sendBlankElement", ((Source)theDef).getSendBlankElement());
        }
        if (def instanceof Bind) {
            theDef = (Bind)def;
            EventDefXmlSerializer.writeOneAttribute(writer, "fromkey", ((Bind)theDef).getFromkey());
            EventDefXmlSerializer.writeOneAttribute(writer, "tokey", ((Bind)theDef).getTokey());
            EventDefXmlSerializer.writeOneAttribute(writer, "node", ((Bind)theDef).getNode());
            EventDefXmlSerializer.writeOneAttribute(writer, "sendBlankElement", ((Bind)theDef).getSendBlankElement());
        }
        if (def instanceof Result) {
            theDef = (Result)def;
            EventDefXmlSerializer.writeOneAttribute(writer, "rootNode", ((Result)theDef).getRootNode());
            EventDefXmlSerializer.writeOneAttribute(writer, "onErrorTele", ((Result)theDef).getOnErrorTele());
            EventDefXmlSerializer.writeOneAttribute(writer, "soap", ((Result)theDef).getSoap());
        }
        if (def instanceof Target) {
            theDef = (Target)def;
            EventDefXmlSerializer.writeOneAttribute(writer, "out", ((Target)theDef).getOut());
            EventDefXmlSerializer.writeOneAttribute(writer, "in", ((Target)theDef).getIn());
            EventDefXmlSerializer.writeOneAttribute(writer, "inkey", ((Target)theDef).getInkey());
            EventDefXmlSerializer.writeOneAttribute(writer, "type", ((Target)theDef).getType());
            EventDefXmlSerializer.writeOneAttribute(writer, "teleType", ((Target)theDef).getTeleType());
            EventDefXmlSerializer.writeOneAttribute(writer, "workType", ((Target)theDef).getWorkType());
        }
    }

    private boolean isNotEmpty(String str) {
        return str != null && !str.trim().equals("");
    }

    private boolean isBindEmpty(Bind bind) {
        return !this.isNotEmpty(bind.getSendBlankElement()) && !this.isNotEmpty(bind.getNode()) && !this.isNotEmpty(bind.getFromkey()) && !this.isNotEmpty(bind.getTokey());
    }

    protected void writeObj(XMLStreamWriter writer, Object def, int hierarchyLvl) throws XMLStreamException {
        Object obj;
        Iterator it;
        boolean hasChildToOutput;
        boolean hasChildren;
        boolean hasAttributes;
        Bind bind;
        Header header;
        if (def instanceof Header && !this.isNotEmpty((header = (Header)def).getName()) && !this.isNotEmpty(header.getValue())) {
            return;
        }
        if (def instanceof Bind && this.isBindEmpty(bind = (Bind)def)) {
            return;
        }
        if (def instanceof Source) {
            Source source = (Source)def;
            hasAttributes = false;
            if (this.isNotEmpty(source.getObj()) || this.isNotEmpty(source.getNode()) || this.isNotEmpty(source.getIdxRef()) || this.isNotEmpty(source.getChildNode()) || this.isNotEmpty(source.getFromkey()) || this.isNotEmpty(source.getType()) || this.isNotEmpty(source.getDesc()) || this.isNotEmpty(source.getMin()) || this.isNotEmpty(source.getMax()) || this.isNotEmpty(source.getRegexp()) || this.isNotEmpty(source.getTeleType()) || this.isNotEmpty(source.getSendBlankElement())) {
                hasAttributes = true;
            }
            hasChildren = source.getAllChildren() != null;
            hasChildToOutput = false;
            if (hasChildren) {
                it = source.getAllChildren();
                while (it.hasNext()) {
                    obj = it.next();
                    if (obj instanceof Bind) {
                        if (this.isBindEmpty((Bind)obj)) continue;
                        hasChildToOutput = true;
                        break;
                    }
                    hasChildToOutput = true;
                    break;
                }
            }
            if (!hasAttributes && !hasChildToOutput) {
                return;
            }
        }
        if (def instanceof Target) {
            Target target = (Target)def;
            hasAttributes = false;
            if (this.isNotEmpty(target.getOut()) || this.isNotEmpty(target.getIn()) || this.isNotEmpty(target.getInkey()) || this.isNotEmpty(target.getType()) || this.isNotEmpty(target.getTeleType()) || this.isNotEmpty(target.getWorkType())) {
                hasAttributes = true;
            }
            hasChildren = target.getAllChildren() != null;
            hasChildToOutput = false;
            if (hasChildren) {
                it = target.getAllChildren();
                while (it.hasNext()) {
                    obj = it.next();
                    if (obj instanceof Bind) {
                        if (this.isBindEmpty((Bind)obj)) continue;
                        hasChildToOutput = true;
                        break;
                    }
                    hasChildToOutput = true;
                    break;
                }
            }
            if (!hasAttributes && !hasChildToOutput) {
                return;
            }
        }
        writer.writeCharacters("\n");
        this.writeIndent(writer, hierarchyLvl);
        writer.writeStartElement(this.getElementName(def));
        this.writeDefAttribute(writer, def);
        if (def instanceof DescDef) {
            writer.writeCData(((DescDef)def).getComment());
        }
        boolean hasChildren2 = false;
        if (def instanceof BasicDef) {
            Iterator it2 = ((IBasicDef)def).getAllChildren();
            while (it2 != null && it2.hasNext()) {
                hasChildren2 = true;
                Object next = it2.next();
                this.writeObj(writer, next, hierarchyLvl + 1);
            }
        }
        if (hasChildren2) {
            writer.writeCharacters("\n");
            this.writeIndent(writer, hierarchyLvl);
        }
        writer.writeEndElement();
    }
}

