/*
 * Decompiled with CFR 0.152.
 */
package org.maskat.framework;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.maskat.framework.DefChildList;
import org.maskat.framework.IBasicDef;
import org.maskat.framework.IBasicDefVisitor;
import org.maskat.framework.NoRemoveIterator;
import org.maskat.framework.screendef.DescDef;

public abstract class BasicDef
implements IBasicDef {
    private IBasicDef parentDef;
    private DefChildList children;

    public boolean contentEquals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BasicDef)) {
            return false;
        }
        BasicDef o = (BasicDef)obj;
        List oChildren = o.getUnmodifiableChildren();
        List thisChildren = this.getUnmodifiableChildren();
        if (oChildren == null && thisChildren != null) {
            return false;
        }
        if (thisChildren == null && oChildren != null) {
            return false;
        }
        if (thisChildren != null) {
            return thisChildren.equals(oChildren);
        }
        return true;
    }

    public IBasicDef getParentDef() {
        return this.parentDef;
    }

    public Iterator getTypedChildren(Class clazz) {
        if (this.children == null) {
            return null;
        }
        return this.children.childItr(clazz);
    }

    public Iterator getAllChildren() {
        if (this.children == null) {
            return null;
        }
        return new NoRemoveIterator(this.children.iterator());
    }

    public List getUnmodifiableChildren() {
        if (this.children == null) {
            return null;
        }
        return Collections.unmodifiableList(this.children);
    }

    public void addChild(Object child) {
        if (child == null) {
            throw new IllegalArgumentException("BasicDef should not have a null child element");
        }
        if (this.children == null) {
            this.children = new DefChildList();
        }
        if (child == this) {
            throw new IllegalArgumentException("Could not add an object as his own child");
        }
        if (this.children.contains(child)) {
            throw new IllegalStateException("object already exists");
        }
        if (child instanceof BasicDef) {
            ((BasicDef)child).parentDef = this;
        }
        this.children.add(child);
    }

    public int getChildIdx(Object child) {
        if (this.children == null) {
            return -1;
        }
        return this.children.indexOf(child);
    }

    public void addChildToIdx(Object child, int idx) {
        if (this.children == null) {
            this.children = new DefChildList();
        }
        if (child == this) {
            throw new IllegalArgumentException("Could not add an object as his own child");
        }
        if (this.children.contains(child)) {
            throw new IllegalStateException("object already exists");
        }
        if (child instanceof BasicDef) {
            ((BasicDef)child).parentDef = this;
        }
        this.children.add(idx, child);
    }

    public void addDesc(String desc) {
        DescDef descDef = new DescDef();
        descDef.setComment(desc);
        this.addChild(descDef);
    }

    public void removeChild(Object obj) {
        if (this.children == null) {
            return;
        }
        this.children.remove(obj);
    }

    public Object getChildByTypeIdx(Class clazz, int idx) {
        if (idx < 0) {
            throw new IllegalArgumentException("parameter [idx] should be >= 0.(" + idx + ")");
        }
        if (this.children == null || this.children.size() <= idx) {
            return null;
        }
        Iterator it = this.children.iterator();
        while (it != null && it.hasNext()) {
            Object obj = it.next();
            if (!clazz.isInstance(obj)) continue;
            if (idx == 0) {
                return obj;
            }
            --idx;
        }
        return null;
    }

    public boolean removeChildByTypeIdx(Class clazz, int idx) {
        if (idx < 0) {
            throw new IllegalArgumentException("parameter [idx] should be >= 0.(" + idx + ")");
        }
        if (this.children == null || this.children.size() <= idx) {
            return false;
        }
        Iterator it = this.children.iterator();
        while (it != null && it.hasNext()) {
            Object obj = it.next();
            if (!clazz.isInstance(obj)) continue;
            if (idx == 0) {
                it.remove();
                return true;
            }
            --idx;
        }
        return false;
    }

    public void removeAllChildren() {
        if (this.children == null) {
            return;
        }
        this.children.clear();
    }

    public void removeAllByType(Class clazz) {
        if (this.children == null) {
            return;
        }
        Iterator it = this.children.iterator();
        while (it != null && it.hasNext()) {
            Object obj = it.next();
            if (!clazz.isInstance(obj)) continue;
            it.remove();
        }
    }

    public void accept(IBasicDefVisitor visitor) {
        if (this.children == null) {
            return;
        }
        for (Object next : this.children) {
            if (next == null) continue;
            visitor.visit(next);
            if (!(next instanceof IBasicDef)) continue;
            IBasicDef basicDef = (IBasicDef)next;
            basicDef.accept(visitor);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        BasicDef obj = (BasicDef)super.clone();
        obj.children = new DefChildList();
        obj.parentDef = null;
        Iterator it = this.getAllChildren();
        while (it != null && it.hasNext()) {
            Object def = it.next();
            if (def instanceof BasicDef) {
                obj.addChild(((BasicDef)def).clone());
                continue;
            }
            obj.addChild(def);
        }
        return obj;
    }
}

