/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.PopUpHelper;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.internal.UITimer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;

public class ToolTipHelper
extends PopUpHelper {
    private UITimer timer;
    private IFigure currentTipSource;

    public ToolTipHelper(Control c) {
        super(c);
        this.getLightweightSystem().getRootFigure().setBorder(new LineBorder());
        this.getShell().setBackground(ColorConstants.tooltipBackground);
        this.getShell().setForeground(ColorConstants.tooltipForeground);
    }

    private Point computeWindowLocation(IFigure tip, int eventX, int eventY) {
        Rectangle clientArea = this.control.getDisplay().getClientArea();
        Point preferredLocation = new Point(eventX, eventY + 26);
        Dimension tipSize = this.getLightweightSystem().getRootFigure().getPreferredSize();
        if (preferredLocation.y + tipSize.height > clientArea.height) {
            preferredLocation.y = eventY - tipSize.height;
        }
        if (preferredLocation.x + tip.getSize().width > clientArea.width) {
            preferredLocation.x -= preferredLocation.x + tipSize.width - clientArea.width;
        }
        return preferredLocation;
    }

    public void displayToolTipNear(IFigure hoverSource, IFigure tip, int eventX, int eventY) {
        if (tip != null && hoverSource != this.currentTipSource) {
            this.getLightweightSystem().setContents(tip);
            Point displayPoint = this.computeWindowLocation(tip, eventX, eventY);
            Dimension tipSize = this.getLightweightSystem().getRootFigure().getPreferredSize();
            this.setShellBounds(displayPoint.x, displayPoint.y, tipSize.width, tipSize.height);
            this.show();
            this.currentTipSource = hoverSource;
            this.timer = new UITimer();
            this.timer.scheduleRepeatedly(new Runnable(){

                public void run() {
                    ToolTipHelper.this.hide();
                    ToolTipHelper.this.timer.cancel();
                }
            }, 5000, 5000);
        }
    }

    public void dispose() {
        if (this.isShowing()) {
            this.timer.cancel();
            this.hide();
        }
        this.getShell().dispose();
    }

    protected void hookShellListeners() {
        this.getShell().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                ToolTipHelper.this.hide();
                ToolTipHelper.this.currentTipSource = null;
                ToolTipHelper.this.timer.cancel();
            }
        });
    }

    public void updateToolTip(IFigure figureUnderMouse, IFigure tip, int eventX, int eventY) {
        if (figureUnderMouse == null && this.isShowing()) {
            this.hide();
            this.timer.cancel();
        }
        if (this.isShowing() && figureUnderMouse != this.currentTipSource) {
            this.hide();
            this.timer.cancel();
            this.displayToolTipNear(figureUnderMouse, tip, eventX, eventY);
        } else if (!this.isShowing() && figureUnderMouse != this.currentTipSource) {
            this.currentTipSource = null;
        }
    }
}

