/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.List;
import org.eclipse.draw2d.AnchorListener;
import org.eclipse.draw2d.ArrowLocator;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.DelegatingLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class PolylineConnection
extends Polyline
implements Connection,
AnchorListener {
    private ConnectionAnchor startAnchor;
    private ConnectionAnchor endAnchor;
    private ConnectionRouter connectionRouter = ConnectionRouter.NULL;
    private RotatableDecoration startArrow;
    private RotatableDecoration endArrow;

    public PolylineConnection() {
        this.setLayoutManager(new DelegatingLayout());
        this.addPoint(new Point(0, 0));
        this.addPoint(new Point(100, 100));
    }

    public void addNotify() {
        super.addNotify();
        this.hookSourceAnchor();
        this.hookTargetAnchor();
    }

    public void anchorMoved(ConnectionAnchor anchor) {
        this.revalidate();
    }

    public Rectangle getBounds() {
        if (this.bounds == null) {
            super.getBounds();
            int i = 0;
            while (i < this.getChildren().size()) {
                IFigure child = (IFigure)this.getChildren().get(i);
                this.bounds.union(child.getBounds());
                ++i;
            }
        }
        return this.bounds;
    }

    public ConnectionRouter getConnectionRouter() {
        return this.connectionRouter;
    }

    public Object getRoutingConstraint() {
        if (this.getConnectionRouter() != null) {
            return (List)this.getConnectionRouter().getConstraint(this);
        }
        return null;
    }

    public ConnectionAnchor getSourceAnchor() {
        return this.startAnchor;
    }

    protected RotatableDecoration getSourceDecoration() {
        return this.startArrow;
    }

    public ConnectionAnchor getTargetAnchor() {
        return this.endAnchor;
    }

    protected RotatableDecoration getTargetDecoration() {
        return this.endArrow;
    }

    private void hookSourceAnchor() {
        if (this.getSourceAnchor() != null) {
            this.getSourceAnchor().addAnchorListener(this);
        }
    }

    private void hookTargetAnchor() {
        if (this.getTargetAnchor() != null) {
            this.getTargetAnchor().addAnchorListener(this);
        }
    }

    public void layout() {
        if (this.getSourceAnchor() != null && this.getTargetAnchor() != null) {
            this.getConnectionRouter().route(this);
        }
        super.layout();
        this.bounds = null;
        this.repaint();
        this.fireMoved();
    }

    public void removeNotify() {
        this.unhookSourceAnchor();
        this.unhookTargetAnchor();
        this.getConnectionRouter().remove(this);
        super.removeNotify();
    }

    public void setConnectionRouter(ConnectionRouter cr) {
        if (cr == null) {
            cr = ConnectionRouter.NULL;
        }
        if (this.connectionRouter != cr) {
            this.connectionRouter.remove(this);
            ConnectionRouter old = this.connectionRouter;
            this.connectionRouter = cr;
            this.firePropertyChange("connectionRouter", old, cr);
            this.revalidate();
        }
    }

    public void setRoutingConstraint(Object cons) {
        if (this.getConnectionRouter() != null) {
            this.getConnectionRouter().setConstraint(this, cons);
        }
        this.revalidate();
    }

    public void setSourceAnchor(ConnectionAnchor anchor) {
        this.unhookSourceAnchor();
        this.getConnectionRouter().invalidate(this);
        this.startAnchor = anchor;
        if (this.getParent() != null) {
            this.hookSourceAnchor();
        }
        this.revalidate();
    }

    public void setSourceDecoration(RotatableDecoration dec) {
        if (this.getSourceDecoration() != null) {
            this.remove(this.getSourceDecoration());
        }
        this.startArrow = dec;
        if (dec != null) {
            this.add((IFigure)dec, new ArrowLocator(this, 2));
        }
    }

    public void setTargetAnchor(ConnectionAnchor anchor) {
        this.unhookTargetAnchor();
        this.getConnectionRouter().invalidate(this);
        this.endAnchor = anchor;
        if (this.getParent() != null) {
            this.hookTargetAnchor();
        }
        this.revalidate();
    }

    public void setTargetDecoration(RotatableDecoration dec) {
        if (this.getTargetDecoration() != null) {
            this.remove(this.getTargetDecoration());
        }
        this.endArrow = dec;
        if (dec != null) {
            this.add((IFigure)dec, new ArrowLocator(this, 3));
        }
    }

    private void unhookSourceAnchor() {
        if (this.getSourceAnchor() != null) {
            this.getSourceAnchor().removeAnchorListener(this);
        }
    }

    private void unhookTargetAnchor() {
        if (this.getTargetAnchor() != null) {
            this.getTargetAnchor().removeAnchorListener(this);
        }
    }
}

