/*
 * Decompiled with CFR 0.152.
 */
package latte.view;

import latte.action.AllAction;
import latte.model.LMFigure;
import latte.view.LVClassDiag;
import latte.view.LVConst;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;

public abstract class LVFigure
extends RectangleFigure
implements MouseListener,
MouseMotionListener {
    LVClassDiag parent_ = null;
    LMFigure lmFig_ = null;
    protected int charHeight_ = 12;
    protected static int SPACE = 2;
    private static AddingConnection addingConn_ = new AddingConnection();

    public LVFigure(LVClassDiag parent, LMFigure lmFig) {
        this.parent_ = parent;
        this.lmFig_ = lmFig;
        this.setForegroundColor(LVConst.foreColor_);
        this.setBackgroundColor(LVConst.backColor_);
        this.setLocation(lmFig.getPoint());
        this.setSize(this.computeSize());
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public abstract Dimension computeSize();

    public LMFigure getLmFig() {
        return this.lmFig_;
    }

    public void updateFigure() {
        int x = this.lmFig_.getPoint().x + this.getParent().getBounds().x;
        int y = this.lmFig_.getPoint().y + this.getParent().getBounds().y;
        this.setLocation(new Point(x, y));
        if (this.lmFig_.isSelected()) {
            this.setBackgroundColor(LVConst.selectedBackColor_);
        } else {
            this.setBackgroundColor(LVConst.backColor_);
        }
    }

    public static AddingConnection getAddingConn() {
        return addingConn_;
    }

    public void mousePressed(MouseEvent me) {
        this.parent_.setPopupMenu(2);
        this.getParent().handleMousePressed(me);
        AllAction.SELECT_NONE.execute(null);
        AllAction.SELECT_DEF.execute(this.lmFig_);
        if (this.parent_.getMode() == 1) {
            this.parent_.getDraw2dView().remove((IFigure)this);
            this.parent_.getDraw2dView().add((IFigure)this);
        } else {
            addingConn_.start(this, me.getLocation());
        }
    }

    public void mouseReleased(MouseEvent me) {
        this.parent_.setPopupMenu(1);
        this.getParent().handleMouseReleased(me);
        addingConn_.end();
    }

    public void mouseDoubleClicked(MouseEvent me) {
        this.getParent().handleMouseDoubleClicked(me);
    }

    public void mouseDragged(MouseEvent me) {
        this.getParent().handleMouseDragged(me);
    }

    public void mouseMoved(MouseEvent me) {
        this.getParent().handleMouseMoved(me);
    }

    public void mouseEntered(MouseEvent me) {
        this.getParent().handleMouseEntered(me);
        if (addingConn_.isToFigCandidate(this)) {
            addingConn_.setToFig(this);
            AllAction.SELECT_DEF.execute(this.getLmFig());
        }
    }

    public void mouseExited(MouseEvent me) {
        this.getParent().handleMouseExited(me);
        if (addingConn_.isToFigCandidate(this)) {
            addingConn_.setToFig(null);
            AllAction.SELECT_NONE.execute(this.getLmFig());
        }
    }

    public void mouseHover(MouseEvent me) {
        this.getParent().handleMouseHover(me);
    }

    static class AddingConnection
    extends PolylineConnection {
        static IFigure parent_ = null;
        private LVFigure fromFig_ = null;
        private LVFigure toFig_ = null;

        AddingConnection() {
            this.setForegroundColor(LVConst.foreColor_);
        }

        public void start(LVFigure figure, Point p) {
            parent_ = figure.getParent();
            this.fromFig_ = figure;
            this.toFig_ = null;
            this.setStart(p);
            this.setEnd(p);
            parent_.add((IFigure)this, 0);
        }

        public void move(Point p) {
            if (this.fromFig_ != null) {
                this.setEnd(p);
            }
        }

        public void end() {
            if (this.fromFig_ != null) {
                parent_.remove((IFigure)this);
                if (this.toFig_ != null) {
                    AllAction.ADD_RELATION.execute(new Object[]{this.fromFig_.getLmFig(), this.toFig_.getLmFig()});
                }
                this.fromFig_ = null;
                this.toFig_ = null;
            }
        }

        public boolean isToFigCandidate(LVFigure fig) {
            return this.fromFig_ != null && this.fromFig_ != fig;
        }

        public void setToFig(LVFigure figure) {
            this.toFig_ = figure;
        }
    }
}

