/*
 * Decompiled with CFR 0.152.
 */
package latte.view;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import latte.Latte;
import latte.model.LMChangedEvent;
import latte.model.LMDiag;
import latte.view.DropTargetEnabler;
import latte.view.LVClassDiag;
import latte.view.LVDiag;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class LVDiagFolder {
    private Latte latte_ = null;
    private TabFolder folder_ = null;
    private ArrayList diagList_ = new ArrayList();

    public LVDiagFolder(Latte latte, Composite parent) {
        this.latte_ = latte;
        this.folder_ = new TabFolder(parent, 0);
        new DropTargetEnabler(this.latte_, this, (Control)this.folder_);
    }

    public void showDiag(LMDiag lmDiag) {
        Iterator ite = ((AbstractList)this.diagList_).iterator();
        while (ite.hasNext()) {
            LVClassDiag diag = (LVClassDiag)ite.next();
            if (diag.getLmDiag() != lmDiag) continue;
            TabItem[] items = new TabItem[]{diag.getTabItem()};
            this.folder_.setSelection(items);
            return;
        }
        this.createDiag(lmDiag);
    }

    private void createDiag(LMDiag lmDiag) {
        LVClassDiag diag = new LVClassDiag(this.latte_, lmDiag);
        this.diagList_.add(diag);
        this.folder_.setSelection(new TabItem[]{diag.getTabItem()});
    }

    public LVClassDiag getCurDiag() {
        TabItem[] items = this.folder_.getSelection();
        if (items.length == 0) {
            return null;
        }
        Iterator ite = ((AbstractList)this.diagList_).iterator();
        while (ite.hasNext()) {
            LVClassDiag diag = (LVClassDiag)ite.next();
            if (diag.getTabItem() != items[0]) continue;
            return diag;
        }
        return null;
    }

    public void updateDiag(LMChangedEvent lmce) {
        switch (lmce.getChangedType()) {
            case 0: {
                Iterator i = ((AbstractList)this.diagList_).iterator();
                while (i.hasNext()) {
                    LVDiag diag = (LVDiag)i.next();
                    diag.dispose();
                }
                this.diagList_.clear();
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                if (this.getCurDiag() == null) break;
                this.getCurDiag().updateDiag(lmce);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 21: 
            case 22: 
            case 23: {
                Iterator it = ((AbstractList)this.diagList_).iterator();
                while (it.hasNext()) {
                    LVDiag diag = (LVDiag)it.next();
                    diag.updateDiag(lmce);
                }
                break;
            }
        }
    }

    private void removeAllDiag() {
        Iterator ite = ((AbstractList)this.diagList_).iterator();
        while (ite.hasNext()) {
            LVClassDiag diag = (LVClassDiag)ite.next();
            diag.dispose();
        }
    }

    public TabFolder getFolder() {
        return this.folder_;
    }
}

