/*
 * Decompiled with CFR 0.152.
 */
package latte.view;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import latte.Latte;
import latte.action.AllAction;
import latte.model.LMAttribute;
import latte.model.LMChangedEvent;
import latte.model.LMClass;
import latte.model.LMDefinition;
import latte.model.LMDiag;
import latte.model.LMFigure;
import latte.model.LMInterface;
import latte.model.LMMethod;
import latte.model.LMRelation;
import latte.view.LVClassDiagListener;
import latte.view.LVClassFigure;
import latte.view.LVDiag;
import latte.view.LVFigure;
import latte.view.LVInterfaceFigure;
import latte.view.LVRelation;
import latte.view.LVUtil;
import org.eclipse.draw2d.IFigure;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class LVClassDiag
extends LVDiag {
    private ArrayList figureList_ = new ArrayList();
    private ArrayList relationList_ = new ArrayList();
    private LVRelation selectedLVRel_ = null;
    private Menu defaultPopupMenu = this.createDefaultPopupMenu();
    private Menu associationPopupMenu = this.createAssociationPopupMenu();
    public static final int POPUPMENU_NONE = 1;
    public static final int POPUPMENU_DEFAULT = 2;
    public static final int POPUPMENU_ASSOCIATION = 3;

    public LVClassDiag(Latte latte, LMDiag lmDiag) {
        super(latte, lmDiag);
        Iterator ite = ((AbstractList)lmDiag.getLmFiguresList()).iterator();
        while (ite.hasNext()) {
            LMFigure fig = (LMFigure)ite.next();
            this.addFigure(fig);
        }
        ite = ((AbstractList)latte.getLatteData().getLmRelList()).iterator();
        while (ite.hasNext()) {
            LMRelation rel = (LMRelation)ite.next();
            LVFigure fromFig = this.getLvfigByLmdef(rel.getFrom());
            LVFigure toFig = this.getLvfigByLmdef(rel.getTo());
            if (fromFig == null || toFig == null) continue;
            this.addRelation(rel);
        }
        new LVClassDiagListener(this);
    }

    Image getTabImage() {
        return AllAction.ADD_CLASS_DIAGRAM.getImage();
    }

    public void setPopupMenu(int menu) {
        switch (menu) {
            case 1: {
                this.getSwtView().setMenu(null);
                break;
            }
            case 2: {
                this.getSwtView().setMenu(this.defaultPopupMenu);
                break;
            }
            case 3: {
                this.getSwtView().setMenu(this.associationPopupMenu);
            }
        }
    }

    private Menu createDefaultPopupMenu() {
        Menu menu = new Menu((Control)this.getSwtView());
        LVUtil.createMenuItem(menu, AllAction.EDIT_CUT);
        LVUtil.createMenuItem(menu, AllAction.EDIT_COPY);
        LVUtil.createMenuItem(menu, AllAction.EDIT_PASTE);
        LVUtil.createMenuItem(menu, AllAction.EDIT_DELETE);
        return menu;
    }

    private Menu createAssociationPopupMenu() {
        Menu menu = new Menu((Control)this.getSwtView());
        LVUtil.createMenuItem(menu, AllAction.NAVIGATABLE_FALSE);
        LVUtil.createMenuItem(menu, AllAction.NAVIGATABLE_TRUE);
        new MenuItem(menu, 2);
        LVUtil.createMenuItem(menu, AllAction.CONTAINER_NONE);
        LVUtil.createMenuItem(menu, AllAction.CONTAINER_AGGREGATION);
        LVUtil.createMenuItem(menu, AllAction.CONTAINER_COMPOSITION);
        new MenuItem(menu, 2);
        LVUtil.createMenuItem(menu, AllAction.EDIT_CUT);
        LVUtil.createMenuItem(menu, AllAction.EDIT_COPY);
        LVUtil.createMenuItem(menu, AllAction.EDIT_PASTE);
        LVUtil.createMenuItem(menu, AllAction.EDIT_DELETE);
        return menu;
    }

    public void updateDiag(LMChangedEvent lmce) {
        switch (lmce.getChangedType()) {
            case 1: {
                LMDefinition def = (LMDefinition)lmce.getElement();
                LMDefinition parent = def.getParent();
                if (this.getLvfigByLmdef(parent) == null) break;
                this.getLvfigByLmdef(parent).updateFigure();
                break;
            }
            case 2: {
                LMDefinition def = (LMDefinition)lmce.getElement();
                if (def instanceof LMDiag) {
                    if (def != this.getLmDiag()) break;
                    this.setTabText(def.getName());
                    break;
                }
                LVFigure lvFig = this.getLvfigByLmdef(def);
                if (lvFig == null) break;
                lvFig.updateFigure();
                break;
            }
            case 3: {
                LVFigure lvFig;
                LMDefinition def = (LMDefinition)lmce.getElement();
                LMDefinition parent = lmce.getParent();
                if (def instanceof LMDiag) {
                    if (def != this.getLmDiag()) break;
                    this.dispose();
                    break;
                }
                if (def instanceof LMClass || def instanceof LMInterface) {
                    LVFigure lvFig2 = this.getLvfigByLmdef(def);
                    if (lvFig2 == null) break;
                    LMFigure fig = lvFig2.getLmFig();
                    this.removeFigure(fig);
                    this.removeRelation(fig);
                    break;
                }
                if (!(def instanceof LMAttribute) && !(def instanceof LMMethod) || (lvFig = this.getLvfigByLmdef(parent)) == null) break;
                lvFig.updateFigure();
                break;
            }
            case 11: {
                this.addFigure((LMFigure)lmce.getElement());
                this.addRelation((LMFigure)lmce.getElement());
                break;
            }
            case 12: {
                LMFigure lmFig = (LMFigure)lmce.getElement();
                if (lmFig != null) {
                    this.getLvfigByLmdef(lmFig.getLmDef()).updateFigure();
                    break;
                }
                Iterator ite = ((AbstractList)this.getFigureList()).iterator();
                while (ite.hasNext()) {
                    ((LVFigure)((Object)ite.next())).updateFigure();
                }
                break;
            }
            case 13: {
                this.removeFigure((LMFigure)lmce.getElement());
                this.removeRelation((LMFigure)lmce.getElement());
                break;
            }
            case 21: {
                this.addRelation((LMRelation)lmce.getElement());
                break;
            }
            case 22: {
                LMRelation lmRel = (LMRelation)lmce.getElement();
                if (lmRel != null) {
                    LVRelation lvRel = this.getLvrelByLmrel(lmRel);
                    if (lvRel == null) break;
                    lvRel.updateFigure();
                    break;
                }
                Iterator ite = ((AbstractList)this.getRelationList()).iterator();
                while (ite.hasNext()) {
                    ((LVRelation)((Object)ite.next())).updateFigure();
                }
                break;
            }
            case 23: {
                LVRelation lvRel = this.getLvrelByLmrel((LMRelation)lmce.getElement());
                if (lvRel == null) break;
                this.removeRelation(lvRel);
            }
        }
    }

    private void addRelation(LMFigure figure) {
        Iterator ite = ((AbstractList)this.getLatte().getLatteData().getLmRelList()).iterator();
        while (ite.hasNext()) {
            LMRelation rel = (LMRelation)ite.next();
            LMDefinition def = figure.getLmDef();
            if (rel.getFrom() == def && this.isExist(rel.getTo())) {
                this.addRelation(rel);
            }
            if (rel.getTo() != def || !this.isExist(rel.getFrom())) continue;
            this.addRelation(rel);
        }
    }

    void removeRelation(LMFigure lmFig) {
        List list = this.getDraw2dView().getChildren();
        ArrayList<IFigure> delRels = new ArrayList<IFigure>();
        LMDefinition lmDef = lmFig.getLmDef();
        Iterator ite = list.iterator();
        while (ite.hasNext()) {
            LVRelation lvRel;
            LMRelation lmRel;
            IFigure fig = (IFigure)ite.next();
            if (!(fig instanceof LVRelation) || (lmRel = (lvRel = (LVRelation)fig).getLmRel()).getFrom() != lmDef && lmRel.getTo() != lmDef) continue;
            delRels.add(fig);
        }
        ite = ((AbstractList)delRels).iterator();
        while (ite.hasNext()) {
            LVRelation lvRel = (LVRelation)((Object)ite.next());
            this.removeRelation(lvRel);
        }
    }

    private void removeRelation(LVRelation lvRel) {
        this.getDraw2dView().remove((IFigure)lvRel);
        ((AbstractCollection)this.relationList_).remove((Object)lvRel);
        lvRel.erase();
    }

    private void addRelation(LMRelation rel) {
        LVFigure fromLvFig = this.getLvfigByLmdef(rel.getFrom());
        LVFigure toLvFig = this.getLvfigByLmdef(rel.getTo());
        if (fromLvFig != null && toLvFig != null) {
            LVRelation conn = new LVRelation(this, rel, fromLvFig, toLvFig);
            this.getDraw2dView().add((IFigure)conn);
            this.relationList_.add(conn);
        }
    }

    void createDiagModeBar() {
        ToolBar toolbar = new ToolBar(this.getTabItemComposite(), 0x800000);
        LVUtil.createToolbarItem(toolbar, 16, AllAction.MODE_SELECTION, true);
        LVUtil.createToolbarItem(toolbar, 16, AllAction.MODE_ASSOCIATION);
        LVUtil.createToolbarItem(toolbar, 16, AllAction.MODE_GENELIZATION);
        LVUtil.createToolbarItem(toolbar, 16, AllAction.MODE_DEPENDENCY);
        LVUtil.createToolbarItem(toolbar, 16, AllAction.MODE_IMPLEMENTATION);
        LVUtil.createToolbarItem(toolbar, 16, AllAction.MODE_NOTELINK);
        new ToolItem(toolbar, 2);
        LVUtil.createToolbarItem(toolbar, 8, AllAction.ADD_NOTE);
    }

    public void addFigure(LMFigure lmFig) {
        LVFigure lvFig = null;
        if (lmFig.getLmDef() instanceof LMClass) {
            lvFig = new LVClassFigure(this, lmFig);
        } else if (lmFig.getLmDef() instanceof LMInterface) {
            lvFig = new LVInterfaceFigure(this, lmFig);
        } else {
            throw new IllegalArgumentException("\u30b5\u30dd\u30fc\u30c8\u3057\u3066\u306a\u3044\u30d5\u30a3\u30ae\u30a2\u3092\u8ffd\u52a0\u3057\u307e\u3057\u305f");
        }
        this.getDraw2dView().add((IFigure)lvFig);
        this.figureList_.add(lvFig);
    }

    public void removeFigure(LMFigure lmFig) {
        LVFigure lvFig = this.getLvfigByLmfig(lmFig);
        this.getDraw2dView().remove((IFigure)lvFig);
        ((AbstractCollection)this.figureList_).remove((Object)lvFig);
        lvFig.erase();
    }

    public ArrayList getFigureList() {
        return this.figureList_;
    }

    LVFigure getLvfigByLmdef(LMDefinition lmDef) {
        return this.getLvfigByLmdef(lmDef, false);
    }

    LVFigure getLvfigByLmdef(LMDefinition lmDef, boolean isSearchChild) {
        Iterator ite = ((AbstractList)this.getFigureList()).iterator();
        while (ite.hasNext()) {
            Iterator i;
            LVFigure lvFig = (LVFigure)((Object)ite.next());
            if (lvFig.getLmFig().getLmDef() == lmDef) {
                return lvFig;
            }
            if (!isSearchChild) continue;
            LMDefinition lmFigDef = lvFig.getLmFig().getLmDef();
            if (lmFigDef instanceof LMClass) {
                i = ((AbstractList)((LMClass)lmFigDef).getAttributes()).iterator();
                while (i.hasNext()) {
                    if (lmDef != i.next()) continue;
                    return lvFig;
                }
            }
            if (!(lmFigDef instanceof LMClass) && !(lmFigDef instanceof LMInterface)) continue;
            i = ((AbstractList)((LMClass)lmFigDef).getMethodes()).iterator();
            while (i.hasNext()) {
                if (lmDef != i.next()) continue;
                return lvFig;
            }
        }
        return null;
    }

    LVFigure getLvfigByLmfig(LMFigure lmFig) {
        Iterator ite = ((AbstractList)this.getFigureList()).iterator();
        while (ite.hasNext()) {
            LVFigure lvFig = (LVFigure)((Object)ite.next());
            if (lvFig.getLmFig() != lmFig) continue;
            return lvFig;
        }
        return null;
    }

    LVRelation getLvrelByLmrel(LMRelation lmRel) {
        Iterator ite = ((AbstractList)this.getRelationList()).iterator();
        while (ite.hasNext()) {
            LVRelation lvRel = (LVRelation)((Object)ite.next());
            if (lvRel.getLmRel() != lmRel) continue;
            return lvRel;
        }
        return null;
    }

    boolean isExist(LMDefinition lmDef) {
        Iterator ite = ((AbstractList)this.getFigureList()).iterator();
        while (ite.hasNext()) {
            LVFigure lvFig = (LVFigure)((Object)ite.next());
            if (lvFig.getLmFig().getLmDef() != lmDef) continue;
            return true;
        }
        return false;
    }

    public ArrayList getRelationList() {
        return this.relationList_;
    }

    public LVRelation getSelectedLVRel() {
        return this.selectedLVRel_;
    }

    public void setSelectedLVRel(LVRelation relation) {
        this.selectedLVRel_ = relation;
    }
}

