/*
 * Decompiled with CFR 0.152.
 */
package latte.view;

import java.util.AbstractList;
import java.util.Iterator;
import latte.Latte;
import latte.action.AllAction;
import latte.model.LMDiag;
import latte.model.LMFigure;
import latte.util.DebugUtil;
import latte.view.LVDiagFolder;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;

public class DropTargetEnabler
implements DropTargetListener {
    private Latte latte_ = null;
    private LVDiagFolder latteDiagFolder_ = null;
    private static Transfer[] TYPE = new Transfer[]{TextTransfer.getInstance()};
    private static int OPERATION = 7;

    public DropTargetEnabler(Latte latte, LVDiagFolder folder, Control control) {
        this.latte_ = latte;
        this.latteDiagFolder_ = folder;
        DropTarget target = new DropTarget(control, OPERATION);
        target.setTransfer(TYPE);
        target.addDropListener((DropTargetListener)this);
    }

    public void dragEnter(DropTargetEvent event) {
        System.out.println(DebugUtil.location());
        LMDiag diag = this.latteDiagFolder_.getCurDiag().getLmDiag();
        Iterator ite = ((AbstractList)diag.getLmFiguresList()).iterator();
        while (ite.hasNext()) {
            LMFigure link = (LMFigure)ite.next();
            if (link.getLmDef() != this.latte_.getLatteData().getSelectedElement()) continue;
            event.detail = 0;
            return;
        }
    }

    public void dragOver(DropTargetEvent event) {
        event.feedback = 25;
    }

    public void dragLeave(DropTargetEvent event) {
        System.out.println("dragLeave");
    }

    public void dragOperationChanged(DropTargetEvent event) {
        System.out.println("dragOperationChanged");
        if (event.detail == 16) {
            event.detail = 4;
        }
    }

    public void dropAccept(DropTargetEvent event) {
        System.out.println("dropAccept");
    }

    public void drop(DropTargetEvent event) {
        System.out.print("drop:");
        if (event.data == null) {
            event.detail = 0;
            System.out.println("none");
            return;
        }
        System.out.println((String)event.data);
        Canvas c = this.latte_.getMainForm().getDiagFolder().getCurDiag().getSwtView();
        Point p = c.toControl(new Point(event.x, event.y));
        AllAction.ADD_FIGURE.execute(p);
    }
}

