/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.AttributeMap;
import org.apache.xerces.dom.ChildNode;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.dom.DeepNodeListImpl;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.apache.xerces.dom.ElementDefinitionImpl;
import org.apache.xerces.dom.NamedNodeMapImpl;
import org.apache.xerces.dom.ParentNode;
import org.apache.xerces.dom3.Node3;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ElementImpl
extends ParentNode
implements Element {
    static final long serialVersionUID = 3717253516652722278L;
    protected String name;
    protected AttributeMap attributes;

    public ElementImpl(CoreDocumentImpl coreDocumentImpl, String string) {
        super(coreDocumentImpl);
        this.name = string;
        this.needsSyncData(true);
    }

    protected ElementImpl() {
    }

    public short getNodeType() {
        return 1;
    }

    public String getNodeName() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.name;
    }

    public NamedNodeMap getAttributes() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            this.attributes = new AttributeMap(this, null);
        }
        return this.attributes;
    }

    public Node cloneNode(boolean bl) {
        ElementImpl elementImpl = (ElementImpl)super.cloneNode(bl);
        if (this.attributes != null) {
            elementImpl.attributes = (AttributeMap)this.attributes.cloneMap(elementImpl);
        }
        return elementImpl;
    }

    void setOwnerDocument(CoreDocumentImpl coreDocumentImpl) {
        super.setOwnerDocument(coreDocumentImpl);
        if (this.attributes != null) {
            this.attributes.setOwnerDocument(coreDocumentImpl);
        }
    }

    public String getAttribute(String string) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            return "";
        }
        Attr attr = (Attr)this.attributes.getNamedItem(string);
        return attr == null ? "" : attr.getValue();
    }

    public Attr getAttributeNode(String string) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            return null;
        }
        return (Attr)this.attributes.getNamedItem(string);
    }

    public NodeList getElementsByTagName(String string) {
        return new DeepNodeListImpl(this, string);
    }

    public String getTagName() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.name;
    }

    public void normalize() {
        if (this.isNormalized()) {
            return;
        }
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        ChildNode childNode = this.firstChild;
        while (childNode != null) {
            ChildNode childNode2 = childNode.nextSibling;
            if (childNode.getNodeType() == 3) {
                if (childNode2 != null && childNode2.getNodeType() == 3) {
                    ((Text)((Object)childNode)).appendData(childNode2.getNodeValue());
                    this.removeChild(childNode2);
                    childNode2 = childNode;
                } else if (childNode.getNodeValue().length() == 0) {
                    this.removeChild(childNode);
                }
            } else if (childNode.getNodeType() == 1) {
                childNode.normalize();
            }
            childNode = childNode2;
        }
        if (this.attributes != null) {
            int n = 0;
            while (n < this.attributes.getLength()) {
                Node node = this.attributes.item(n);
                node.normalize();
                ++n;
            }
        }
        this.isNormalized(true);
    }

    public void removeAttribute(String string) {
        if (this.ownerDocument.errorChecking && this.isReadOnly()) {
            String string2 = DOMMessageFormatter.formatMessage("NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, string2);
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            return;
        }
        this.attributes.safeRemoveNamedItem(string);
    }

    public Attr removeAttributeNode(Attr attr) throws DOMException {
        if (this.ownerDocument.errorChecking && this.isReadOnly()) {
            String string = DOMMessageFormatter.formatMessage("NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, string);
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            String string = DOMMessageFormatter.formatMessage("NOT_FOUND_ERR", null);
            throw new DOMException(8, string);
        }
        return (Attr)this.attributes.removeNamedItem(attr.getName());
    }

    public void setAttribute(String string, String string2) {
        Attr attr;
        if (this.ownerDocument.errorChecking && this.isReadOnly()) {
            String string3 = DOMMessageFormatter.formatMessage("NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, string3);
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if ((attr = this.getAttributeNode(string)) == null) {
            attr = this.getOwnerDocument().createAttribute(string);
            if (this.attributes == null) {
                this.attributes = new AttributeMap(this, null);
            }
            attr.setNodeValue(string2);
            this.attributes.setNamedItem(attr);
        } else {
            attr.setNodeValue(string2);
        }
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.ownerDocument.errorChecking) {
            if (this.isReadOnly()) {
                String string = DOMMessageFormatter.formatMessage("NO_MODIFICATION_ALLOWED_ERR", null);
                throw new DOMException(7, string);
            }
            if (attr.getOwnerDocument() != this.ownerDocument) {
                String string = DOMMessageFormatter.formatMessage("WRONG_DOCUMENT_ERR", null);
                throw new DOMException(4, string);
            }
        }
        if (this.attributes == null) {
            this.attributes = new AttributeMap(this, null);
        }
        return (Attr)this.attributes.setNamedItem(attr);
    }

    public String getAttributeNS(String string, String string2) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            return "";
        }
        Attr attr = (Attr)this.attributes.getNamedItemNS(string, string2);
        return attr == null ? "" : attr.getValue();
    }

    public void setAttributeNS(String string, String string2, String string3) {
        Attr attr;
        if (this.ownerDocument.errorChecking && this.isReadOnly()) {
            String string4 = DOMMessageFormatter.formatMessage("NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, string4);
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if ((attr = this.getAttributeNodeNS(string, string2)) == null) {
            attr = this.getOwnerDocument().createAttributeNS(string, string2);
            if (this.attributes == null) {
                this.attributes = new AttributeMap(this, null);
            }
            attr.setNodeValue(string3);
            this.attributes.setNamedItemNS(attr);
        } else {
            attr.setNodeValue(string3);
        }
    }

    public void removeAttributeNS(String string, String string2) {
        if (this.ownerDocument.errorChecking && this.isReadOnly()) {
            String string3 = DOMMessageFormatter.formatMessage("NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, string3);
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            return;
        }
        this.attributes.safeRemoveNamedItemNS(string, string2);
    }

    public Attr getAttributeNodeNS(String string, String string2) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            return null;
        }
        return (Attr)this.attributes.getNamedItemNS(string, string2);
    }

    public Attr setAttributeNodeNS(Attr attr) throws DOMException {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.ownerDocument.errorChecking) {
            if (this.isReadOnly()) {
                String string = DOMMessageFormatter.formatMessage("NO_MODIFICATION_ALLOWED_ERR", null);
                throw new DOMException(7, string);
            }
            if (attr.getOwnerDocument() != this.ownerDocument) {
                String string = DOMMessageFormatter.formatMessage("WRONG_DOCUMENT_ERR", null);
                throw new DOMException(4, string);
            }
        }
        if (this.attributes == null) {
            this.attributes = new AttributeMap(this, null);
        }
        return (Attr)this.attributes.setNamedItemNS(attr);
    }

    public boolean hasAttributes() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.attributes != null && this.attributes.getLength() != 0;
    }

    public boolean hasAttribute(String string) {
        return this.getAttributeNode(string) != null;
    }

    public boolean hasAttributeNS(String string, String string2) {
        return this.getAttributeNodeNS(string, string2) != null;
    }

    public NodeList getElementsByTagNameNS(String string, String string2) {
        return new DeepNodeListImpl(this, string, string2);
    }

    public boolean isEqualNode(Node node, boolean bl) {
        if (!super.isEqualNode(node, bl)) {
            return false;
        }
        boolean bl2 = this.hasAttributes();
        if (bl2 != ((Element)node).hasAttributes()) {
            return false;
        }
        if (bl2) {
            NamedNodeMap namedNodeMap = this.getAttributes();
            NamedNodeMap namedNodeMap2 = ((Element)node).getAttributes();
            int n = namedNodeMap.getLength();
            if (n != namedNodeMap2.getLength()) {
                return false;
            }
            int n2 = 0;
            while (n2 < n) {
                Node node2;
                Node node3 = namedNodeMap.item(n2);
                if (node3.getLocalName() == null ? (node2 = namedNodeMap2.getNamedItem(node3.getNodeName())) == null || !((Node3)node3).isEqualNode(node2, true) : (node2 = namedNodeMap2.getNamedItemNS(node3.getNamespaceURI(), node3.getLocalName())) == null || !((Node3)node3).isEqualNode(node2, bl)) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public void setReadOnly(boolean bl, boolean bl2) {
        super.setReadOnly(bl, bl2);
        if (this.attributes != null) {
            this.attributes.setReadOnly(bl, true);
        }
    }

    protected void synchronizeData() {
        this.needsSyncData(false);
        boolean bl = this.ownerDocument.getMutationEvents();
        this.ownerDocument.setMutationEvents(false);
        this.setupDefaultAttributes();
        this.ownerDocument.setMutationEvents(bl);
    }

    protected void setupDefaultAttributes() {
        NamedNodeMapImpl namedNodeMapImpl = this.getDefaultAttributes();
        if (namedNodeMapImpl != null) {
            this.attributes = new AttributeMap(this, namedNodeMapImpl);
        }
    }

    protected void reconcileDefaultAttributes() {
        NamedNodeMapImpl namedNodeMapImpl = this.getDefaultAttributes();
        if (namedNodeMapImpl != null) {
            this.attributes.reconcileDefaults(namedNodeMapImpl);
        }
    }

    protected NamedNodeMapImpl getDefaultAttributes() {
        DocumentTypeImpl documentTypeImpl = (DocumentTypeImpl)this.ownerDocument.getDoctype();
        if (documentTypeImpl == null) {
            return null;
        }
        ElementDefinitionImpl elementDefinitionImpl = (ElementDefinitionImpl)documentTypeImpl.getElements().getNamedItem(this.getNodeName());
        if (elementDefinitionImpl == null) {
            return null;
        }
        return (NamedNodeMapImpl)elementDefinitionImpl.getAttributes();
    }
}

