/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

class EventTable {
    int[] types;
    Listener[] listeners;
    int level;

    EventTable() {
    }

    public void hook(int eventType, Listener listener) {
        if (this.types == null) {
            this.types = new int[4];
        }
        if (this.listeners == null) {
            this.listeners = new Listener[4];
        }
        int length = this.types.length;
        int index = length - 1;
        while (index >= 0) {
            if (this.types[index] != 0) break;
            --index;
        }
        if (++index == length) {
            if (this.level == 0) {
                index = 0;
                int i = 0;
                while (i < this.types.length) {
                    if (this.types[i] != 0) {
                        this.types[index] = this.types[i];
                        this.listeners[index] = this.listeners[i];
                        ++index;
                    }
                    ++i;
                }
                i = index;
                while (i < this.types.length) {
                    this.types[i] = 0;
                    this.listeners[i] = null;
                    ++i;
                }
            }
            if (index == length) {
                int[] newTypes = new int[length + 4];
                System.arraycopy(this.types, 0, newTypes, 0, length);
                this.types = newTypes;
                Listener[] newListeners = new Listener[length + 4];
                System.arraycopy(this.listeners, 0, newListeners, 0, length);
                this.listeners = newListeners;
            }
        }
        this.types[index] = eventType;
        this.listeners[index] = listener;
    }

    public boolean hooks(int eventType) {
        if (this.types == null) {
            return false;
        }
        int i = 0;
        while (i < this.types.length) {
            if (this.types[i] == eventType) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void sendEvent(Event event) {
        if (this.types == null) {
            return;
        }
        ++this.level;
        try {
            int i = 0;
            while (i < this.types.length) {
                Listener listener;
                if (this.types[i] == event.type && (listener = this.listeners[i]) != null) {
                    listener.handleEvent(event);
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            --this.level;
            throw throwable;
        }
        Object var4_6 = null;
        --this.level;
    }

    public int size() {
        if (this.types == null) {
            return 0;
        }
        int count = 0;
        int i = 0;
        while (i < this.types.length) {
            if (this.types[i] != 0) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    void remove(int index) {
        if (this.level == 0) {
            int end = this.types.length - 1;
            System.arraycopy(this.types, index + 1, this.types, index, end - index);
            System.arraycopy(this.listeners, index + 1, this.listeners, index, end - index);
            index = end;
        }
        this.types[index] = 0;
        this.listeners[index] = null;
    }

    public void unhook(int eventType, Listener listener) {
        if (this.types == null) {
            return;
        }
        int i = 0;
        while (i < this.types.length) {
            if (this.types[i] == eventType && this.listeners[i] == listener) {
                this.remove(i);
                return;
            }
            ++i;
        }
    }

    public void unhook(int eventType, SWTEventListener listener) {
        if (this.types == null) {
            return;
        }
        int i = 0;
        while (i < this.types.length) {
            TypedListener typedListener;
            if (this.types[i] == eventType && this.listeners[i] instanceof TypedListener && (typedListener = (TypedListener)this.listeners[i]).getEventListener() == listener) {
                this.remove(i);
                return;
            }
            ++i;
        }
    }
}

