/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;

public class SashForm
extends Composite {
    public int SASH_WIDTH = 3;
    private static final int DRAG_MINIMUM = 20;
    private int orientation = 256;
    private Sash[] sashes = new Sash[0];
    private Control[] controls = new Control[0];
    private Control maxControl = null;
    private Listener sashListener;
    private static final String LAYOUT_RATIO = "layout ratio";

    public SashForm(Composite parent, int style) {
        super(parent, SashForm.checkStyle(style));
        if ((style & 0x200) != 0) {
            this.orientation = 512;
        }
        this.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                SashForm.this.layout(true);
            }
        });
        this.sashListener = new Listener(){

            public void handleEvent(Event e) {
                SashForm.this.onDragSash(e);
            }
        };
    }

    private static int checkStyle(int style) {
        int mask = 2048;
        return style & mask;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        boolean vertical;
        this.checkWidget();
        Control[] controls = this.getControls(true);
        if (controls.length == 0) {
            return new Point(wHint, hHint);
        }
        int width = 0;
        int height = 0;
        boolean bl = vertical = this.orientation == 512;
        if (vertical) {
            height += (controls.length - 1) * this.SASH_WIDTH;
        } else {
            width += (controls.length - 1) * this.SASH_WIDTH;
        }
        int i = 0;
        while (i < controls.length) {
            Point size;
            if (vertical) {
                size = controls[i].computeSize(wHint, -1);
                height += size.y;
                width = Math.max(width, size.x);
            } else {
                size = controls[i].computeSize(-1, hHint);
                width += size.x;
                height = Math.max(height, size.y);
            }
            ++i;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public Control getMaximizedControl() {
        return this.maxControl;
    }

    public int[] getWeights() {
        this.checkWidget();
        Control[] cArray = this.getControls(false);
        float[] ratios = new float[cArray.length];
        int i = 0;
        while (i < cArray.length) {
            Float ratio = (Float)cArray[i].getData(LAYOUT_RATIO);
            ratios[i] = ratio != null ? ratio.floatValue() : 0.2f;
            ++i;
        }
        int[] weights = new int[cArray.length];
        int i2 = 0;
        while (i2 < weights.length) {
            weights[i2] = (int)(ratios[i2] * 1000.0f);
            ++i2;
        }
        return weights;
    }

    private Control[] getControls(boolean onlyVisible) {
        Control[] children = this.getChildren();
        Control[] controls = new Control[]{};
        int i = 0;
        while (i < children.length) {
            if (!(children[i] instanceof Sash || onlyVisible && !children[i].getVisible())) {
                Control[] newControls = new Control[controls.length + 1];
                System.arraycopy(controls, 0, newControls, 0, controls.length);
                newControls[controls.length] = children[i];
                controls = newControls;
            }
            ++i;
        }
        return controls;
    }

    public void layout(boolean changed) {
        int i;
        Sash[] newSashes;
        this.checkWidget();
        Rectangle area = this.getClientArea();
        if (area.width == 0 || area.height == 0) {
            return;
        }
        Control[] newControls = this.getControls(true);
        if (this.controls.length == 0 && newControls.length == 0) {
            return;
        }
        this.controls = newControls;
        if (this.maxControl != null && !this.maxControl.isDisposed()) {
            int i2 = 0;
            while (i2 < this.controls.length) {
                if (this.controls[i2] != this.maxControl) {
                    this.controls[i2].setBounds(-200, -200, 0, 0);
                } else {
                    this.controls[i2].setBounds(area);
                }
                ++i2;
            }
            return;
        }
        if (this.sashes.length < this.controls.length - 1) {
            newSashes = new Sash[this.controls.length - 1];
            System.arraycopy(this.sashes, 0, newSashes, 0, this.sashes.length);
            int sashOrientation = this.orientation == 256 ? 512 : 256;
            i = this.sashes.length;
            while (i < newSashes.length) {
                newSashes[i] = new Sash(this, sashOrientation);
                newSashes[i].addListener(13, this.sashListener);
                ++i;
            }
            this.sashes = newSashes;
        }
        if (this.sashes.length > this.controls.length - 1) {
            if (this.controls.length == 0) {
                int i3 = 0;
                while (i3 < this.sashes.length) {
                    this.sashes[i3].dispose();
                    ++i3;
                }
                this.sashes = new Sash[0];
            } else {
                newSashes = new Sash[this.controls.length - 1];
                System.arraycopy(this.sashes, 0, newSashes, 0, newSashes.length);
                int i4 = this.controls.length - 1;
                while (i4 < this.sashes.length) {
                    this.sashes[i4].dispose();
                    ++i4;
                }
                this.sashes = newSashes;
            }
        }
        if (this.controls.length == 0) {
            return;
        }
        float[] ratios = new float[this.controls.length];
        float total = 0.0f;
        i = 0;
        while (i < this.controls.length) {
            Float ratio = (Float)this.controls[i].getData(LAYOUT_RATIO);
            ratios[i] = ratio != null ? ratio.floatValue() : 0.2f;
            total += ratios[i];
            ++i;
        }
        total = this.orientation == 256 ? (total += (float)this.sashes.length * ((float)this.SASH_WIDTH / (float)area.width)) : (total += (float)this.sashes.length * ((float)this.SASH_WIDTH / (float)area.height));
        if (this.orientation == 256) {
            int width = (int)(ratios[0] / total * (float)area.width);
            int x = area.x;
            this.controls[0].setBounds(x, area.y, width, area.height);
            x += width;
            int i5 = 1;
            while (i5 < this.controls.length - 1) {
                this.sashes[i5 - 1].setBounds(x, area.y, this.SASH_WIDTH, area.height);
                width = (int)(ratios[i5] / total * (float)area.width);
                this.controls[i5].setBounds(x += this.SASH_WIDTH, area.y, width, area.height);
                x += width;
                ++i5;
            }
            if (this.controls.length > 1) {
                this.sashes[this.sashes.length - 1].setBounds(x, area.y, this.SASH_WIDTH, area.height);
                width = area.width - (x += this.SASH_WIDTH);
                this.controls[this.controls.length - 1].setBounds(x, area.y, width, area.height);
            }
        } else {
            int height = (int)(ratios[0] / total * (float)area.height);
            int y = area.y;
            this.controls[0].setBounds(area.x, y, area.width, height);
            y += height;
            int i6 = 1;
            while (i6 < this.controls.length - 1) {
                this.sashes[i6 - 1].setBounds(area.x, y, area.width, this.SASH_WIDTH);
                height = (int)(ratios[i6] / total * (float)area.height);
                this.controls[i6].setBounds(area.x, y += this.SASH_WIDTH, area.width, height);
                y += height;
                ++i6;
            }
            if (this.controls.length > 1) {
                this.sashes[this.sashes.length - 1].setBounds(area.x, y, area.width, this.SASH_WIDTH);
                height = area.height - (y += this.SASH_WIDTH);
                this.controls[this.controls.length - 1].setBounds(area.x, y, area.width, height);
            }
        }
    }

    private void onDragSash(Event event) {
        if (event.detail == 1) {
            Rectangle area = this.getClientArea();
            if (this.orientation == 256) {
                event.x = Math.min(Math.max(20, event.x), area.width - 20);
            } else {
                event.y = Math.min(Math.max(20, event.y), area.height - 20);
            }
            return;
        }
        Sash sash = (Sash)event.widget;
        int sashIndex = -1;
        int i = 0;
        while (i < this.sashes.length) {
            if (this.sashes[i] == sash) {
                sashIndex = i;
                break;
            }
            ++i;
        }
        if (sashIndex == -1) {
            return;
        }
        Control c1 = this.controls[sashIndex];
        Control c2 = this.controls[sashIndex + 1];
        Rectangle b1 = c1.getBounds();
        Rectangle b2 = c2.getBounds();
        Rectangle sashBounds = sash.getBounds();
        Rectangle area = this.getClientArea();
        if (this.orientation == 256) {
            int shift = event.x - sashBounds.x;
            b1.width += shift;
            b2.x += shift;
            b2.width -= shift;
            if (b1.width < 20 || b2.width < 20) {
                return;
            }
            c1.setData(LAYOUT_RATIO, new Float((float)b1.width / (float)area.width));
            c2.setData(LAYOUT_RATIO, new Float((float)b2.width / (float)area.width));
        } else {
            int shift = event.y - sashBounds.y;
            b1.height += shift;
            b2.y += shift;
            b2.height -= shift;
            if (b1.height < 20 || b2.height < 20) {
                return;
            }
            c1.setData(LAYOUT_RATIO, new Float((float)b1.height / (float)area.height));
            c2.setData(LAYOUT_RATIO, new Float((float)b2.height / (float)area.height));
        }
        c1.setBounds(b1);
        sash.setBounds(event.x, event.y, event.width, event.height);
        c2.setBounds(b2);
    }

    public void setOrientation(int orientation) {
        this.checkWidget();
        if (this.orientation == orientation) {
            return;
        }
        if (orientation != 256 && orientation != 512) {
            SWT.error(5);
        }
        this.orientation = orientation;
        int sashOrientation = orientation == 256 ? 512 : 256;
        int i = 0;
        while (i < this.sashes.length) {
            this.sashes[i].dispose();
            this.sashes[i] = new Sash(this, sashOrientation);
            this.sashes[i].addListener(13, this.sashListener);
            ++i;
        }
        this.layout();
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    public void setMaximizedControl(Control control) {
        this.checkWidget();
        if (control == null) {
            if (this.maxControl != null) {
                this.maxControl = null;
                this.layout();
                int i = 0;
                while (i < this.sashes.length) {
                    this.sashes[i].setVisible(true);
                    ++i;
                }
            }
            return;
        }
        int i = 0;
        while (i < this.sashes.length) {
            this.sashes[i].setVisible(false);
            ++i;
        }
        this.maxControl = control;
        this.layout();
    }

    public void setWeights(int[] weights) {
        this.checkWidget();
        Control[] cArray = this.getControls(false);
        if (weights == null || weights.length != cArray.length) {
            SWT.error(5);
        }
        int total = 0;
        int i = 0;
        while (i < weights.length) {
            if (weights[i] < 0) {
                SWT.error(5);
            }
            total += weights[i];
            ++i;
        }
        if (total == 0) {
            SWT.error(5);
        }
        i = 0;
        while (i < cArray.length) {
            cArray[i].setData(LAYOUT_RATIO, new Float((float)weights[i] / (float)total));
            ++i;
        }
        this.layout();
    }
}

