/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.font;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import sun.awt.font.Bidi;
import sun.awt.font.ExtendedTextLabel;
import sun.awt.font.ExtendedTextSourceLabel;
import sun.awt.font.StandardTextSource;
import sun.awt.font.TextLabel;
import sun.awt.font.TextSourceLabel;

public class TextLabelFactory {
    private FontRenderContext frc;
    private char[] text;
    private Bidi bidi;
    private Bidi lineBidi;
    private int lineStart;
    private int lineLimit;

    public TextLabelFactory(FontRenderContext fontRenderContext, char[] cArray, Bidi bidi) {
        this.frc = fontRenderContext;
        this.text = cArray;
        this.bidi = bidi;
        this.lineBidi = bidi;
        this.lineStart = 0;
        this.lineLimit = cArray.length;
    }

    public FontRenderContext getFontRenderContext() {
        return this.frc;
    }

    public char[] getText() {
        return this.text;
    }

    public Bidi getParagraphBidi() {
        return this.bidi;
    }

    public Bidi getLineBidi() {
        return this.lineBidi;
    }

    public int getLineStart() {
        return this.lineStart;
    }

    public int getLineLimit() {
        return this.lineLimit;
    }

    public void setLineContext(int n, int n2) {
        this.lineStart = n;
        this.lineLimit = n2;
        if (this.bidi != null) {
            this.lineBidi = this.bidi.createLineBidi(n, n2);
        }
    }

    public ExtendedTextLabel createExtended(Font font, LineMetrics lineMetrics, int n, int n2) {
        if (n >= n2 || n < this.lineStart || n2 > this.lineLimit) {
            throw new IllegalArgumentException("bad start: " + n + " or limit: " + n2);
        }
        int n3 = this.lineBidi == null ? 0 : this.lineBidi.getLevelAt(n - this.lineStart);
        int n4 = this.lineBidi == null || this.lineBidi.isDirectionLTR() ? 0 : 1;
        StandardTextSource standardTextSource = new StandardTextSource(this.text, n, n2 - n, this.lineStart, this.lineLimit - this.lineStart, n3, n4, font, this.frc, lineMetrics);
        return new ExtendedTextSourceLabel(standardTextSource);
    }

    public TextLabel createSimple(Font font, LineMetrics lineMetrics, int n, int n2) {
        if (n >= n2 || n < this.lineStart || n2 > this.lineLimit) {
            throw new IllegalArgumentException("bad start: " + n + " or limit: " + n2);
        }
        int n3 = this.lineBidi == null ? 0 : this.lineBidi.getLevelAt(n - this.lineStart);
        int n4 = this.lineBidi == null || this.lineBidi.isDirectionLTR() ? 0 : 1;
        StandardTextSource standardTextSource = new StandardTextSource(this.text, n, n2 - n, this.lineStart, this.lineLimit - this.lineStart, n3, n4, font, this.frc, lineMetrics);
        return new TextSourceLabel(standardTextSource);
    }
}

