/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.Serializable;
import javax.swing.text.TabStop;

public class TabSet
implements Serializable {
    private TabStop[] tabs;

    public TabSet(TabStop[] tabStopArray) {
        if (tabStopArray != null) {
            int n = tabStopArray.length;
            this.tabs = new TabStop[n];
            System.arraycopy(tabStopArray, 0, this.tabs, 0, n);
        } else {
            this.tabs = null;
        }
    }

    public int getTabCount() {
        return this.tabs == null ? 0 : this.tabs.length;
    }

    public TabStop getTab(int n) {
        int n2 = this.getTabCount();
        if (n < 0 || n >= n2) {
            throw new IllegalArgumentException(n + " is outside the range of tabs");
        }
        return this.tabs[n];
    }

    public TabStop getTabAfter(float f) {
        int n = this.getTabIndexAfter(f);
        return n == -1 ? null : this.tabs[n];
    }

    public int getTabIndex(TabStop tabStop) {
        int n = this.getTabCount() - 1;
        while (n >= 0) {
            if (this.getTab(n) == tabStop) {
                return n;
            }
            --n;
        }
        return -1;
    }

    public int getTabIndexAfter(float f) {
        int n = 0;
        int n2 = this.getTabCount();
        while (n != n2) {
            int n3 = (n2 - n) / 2 + n;
            if (f > this.tabs[n3].getPosition()) {
                if (n == n3) {
                    n = n2;
                    continue;
                }
                n = n3;
                continue;
            }
            if (n3 == 0 || f > this.tabs[n3 - 1].getPosition()) {
                return n3;
            }
            n2 = n3;
        }
        return -1;
    }

    public String toString() {
        int n = this.getTabCount();
        StringBuffer stringBuffer = new StringBuffer("[ ");
        int n2 = 0;
        while (n2 < n) {
            if (n2 > 0) {
                stringBuffer.append(" - ");
            }
            stringBuffer.append(this.getTab(n2).toString());
            ++n2;
        }
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }
}

