/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.WindowConstants;

public class JDialog
extends Dialog
implements WindowConstants,
Accessible,
RootPaneContainer {
    private int defaultCloseOperation = 1;
    protected JRootPane rootPane;
    protected boolean rootPaneCheckingEnabled = false;
    protected AccessibleContext accessibleContext = null;

    public JDialog() {
        this((Frame)null, false);
    }

    public JDialog(Frame frame) {
        this(frame, false);
    }

    public JDialog(Frame frame, boolean bl) {
        this(frame, null, bl);
    }

    public JDialog(Frame frame, String string) {
        this(frame, string, false);
    }

    public JDialog(Frame frame, String string, boolean bl) {
        super(frame == null ? SwingUtilities.getSharedOwnerFrame() : frame, string, bl);
        this.dialogInit();
    }

    public JDialog(Dialog dialog) {
        this(dialog, false);
    }

    public JDialog(Dialog dialog, boolean bl) {
        this(dialog, null, bl);
    }

    public JDialog(Dialog dialog, String string) {
        this(dialog, string, false);
    }

    public JDialog(Dialog dialog, String string, boolean bl) {
        super(dialog, string, bl);
        this.dialogInit();
    }

    protected void dialogInit() {
        this.enableEvents(72L);
        this.setRootPane(this.createRootPane());
        this.setRootPaneCheckingEnabled(true);
    }

    protected JRootPane createRootPane() {
        return new JRootPane();
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (!keyEvent.isConsumed()) {
            JComponent.processKeyBindingsForAllComponents(keyEvent, this, keyEvent.getID() == 401);
        }
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            switch (this.defaultCloseOperation) {
                case 1: {
                    this.setVisible(false);
                    break;
                }
                case 2: {
                    this.setVisible(false);
                    this.dispose();
                    break;
                }
            }
        }
    }

    public void setDefaultCloseOperation(int n) {
        this.defaultCloseOperation = n;
    }

    public int getDefaultCloseOperation() {
        return this.defaultCloseOperation;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void setJMenuBar(JMenuBar jMenuBar) {
        this.getRootPane().setMenuBar(jMenuBar);
    }

    public JMenuBar getJMenuBar() {
        return this.getRootPane().getMenuBar();
    }

    protected boolean isRootPaneCheckingEnabled() {
        return this.rootPaneCheckingEnabled;
    }

    protected void setRootPaneCheckingEnabled(boolean bl) {
        this.rootPaneCheckingEnabled = bl;
    }

    private Error createRootPaneException(String string) {
        String string2 = this.getClass().getName();
        return new Error("Do not use " + string2 + "." + string + "() use " + string2 + ".getContentPane()." + string + "() instead");
    }

    protected void addImpl(Component component, Object object, int n) {
        if (this.isRootPaneCheckingEnabled()) {
            throw this.createRootPaneException("add");
        }
        super.addImpl(component, object, n);
    }

    public void remove(Component component) {
        if (component == this.rootPane) {
            super.remove(component);
        } else {
            this.getContentPane().remove(component);
        }
    }

    public void setLayout(LayoutManager layoutManager) {
        if (this.isRootPaneCheckingEnabled()) {
            throw this.createRootPaneException("setLayout");
        }
        super.setLayout(layoutManager);
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    protected void setRootPane(JRootPane jRootPane) {
        if (this.rootPane != null) {
            this.remove(this.rootPane);
        }
        this.rootPane = jRootPane;
        if (this.rootPane != null) {
            boolean bl = this.isRootPaneCheckingEnabled();
            try {
                this.setRootPaneCheckingEnabled(false);
                this.add((Component)this.rootPane, "Center");
                Object var4_3 = null;
                this.setRootPaneCheckingEnabled(bl);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.setRootPaneCheckingEnabled(bl);
                throw throwable;
            }
        }
    }

    public Container getContentPane() {
        return this.getRootPane().getContentPane();
    }

    public void setContentPane(Container container) {
        this.getRootPane().setContentPane(container);
    }

    public JLayeredPane getLayeredPane() {
        return this.getRootPane().getLayeredPane();
    }

    public void setLayeredPane(JLayeredPane jLayeredPane) {
        this.getRootPane().setLayeredPane(jLayeredPane);
    }

    public Component getGlassPane() {
        return this.getRootPane().getGlassPane();
    }

    public void setGlassPane(Component component) {
        this.getRootPane().setGlassPane(component);
    }

    public void setLocationRelativeTo(Component component) {
        Serializable serializable;
        Serializable serializable2 = null;
        if (component != null) {
            if (component instanceof Window || component instanceof Applet) {
                serializable2 = (Container)component;
            } else {
                serializable = component.getParent();
                while (serializable != null) {
                    if (serializable instanceof Window || serializable instanceof Applet) {
                        serializable2 = serializable;
                        break;
                    }
                    serializable = ((Component)serializable).getParent();
                }
            }
        }
        if (component != null && !component.isShowing() || serializable2 == null || !serializable2.isShowing()) {
            serializable = this.getSize();
            Dimension dimension = this.getToolkit().getScreenSize();
            this.setLocation((dimension.width - ((Dimension)serializable).width) / 2, (dimension.height - ((Dimension)serializable).height) / 2);
        } else {
            Serializable serializable3;
            Point point;
            serializable = component.getSize();
            if (serializable2 instanceof Applet) {
                point = component.getLocationOnScreen();
            } else {
                point = new Point(0, 0);
                serializable3 = component;
                while (serializable3 != null) {
                    Point point2 = ((Component)serializable3).getLocation();
                    point.x += point2.x;
                    point.y += point2.y;
                    if (serializable3 == serializable2) break;
                    serializable3 = ((Component)serializable3).getParent();
                }
            }
            serializable3 = this.getBounds();
            int n = point.x + (((Dimension)serializable).width - ((Rectangle)serializable3).width >> 1);
            int n2 = point.y + (((Dimension)serializable).height - ((Rectangle)serializable3).height >> 1);
            Dimension dimension = this.getToolkit().getScreenSize();
            if (n2 + ((Rectangle)serializable3).height > dimension.height) {
                n2 = dimension.height - ((Rectangle)serializable3).height;
                int n3 = n = point.x < dimension.width >> 1 ? point.x + ((Dimension)serializable).width : point.x - ((Rectangle)serializable3).width;
            }
            if (n + ((Rectangle)serializable3).width > dimension.width) {
                n = dimension.width - ((Rectangle)serializable3).width;
            }
            if (n < 0) {
                n = 0;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            this.setLocation(n, n2);
        }
    }

    protected String paramString() {
        String string = this.defaultCloseOperation == 1 ? "HIDE_ON_CLOSE" : (this.defaultCloseOperation == 2 ? "DISPOSE_ON_CLOSE" : (this.defaultCloseOperation == 0 ? "DO_NOTHING_ON_CLOSE" : ""));
        String string2 = this.rootPane != null ? this.rootPane.toString() : "";
        String string3 = this.rootPaneCheckingEnabled ? "true" : "false";
        return super.paramString() + ",defaultCloseOperation=" + string + ",rootPane=" + string2 + ",rootPaneCheckingEnabled=" + string3;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJDialog();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJDialog
    extends Dialog.AccessibleAWTDialog {
        protected AccessibleJDialog() {
        }

        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (JDialog.this.getTitle() == null) {
                return super.getAccessibleName();
            }
            return JDialog.this.getTitle();
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (JDialog.this.isResizable()) {
                accessibleStateSet.add(AccessibleState.RESIZABLE);
            }
            if (JDialog.this.getFocusOwner() != null) {
                accessibleStateSet.add(AccessibleState.ACTIVE);
            }
            if (JDialog.this.isModal()) {
                accessibleStateSet.add(AccessibleState.MODAL);
            }
            return accessibleStateSet;
        }
    }
}

