//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * `[gA2 LN^ړ
 * @author Junpee
 */

#include <LampBasic.h>
#include <Framework/System/SceneFramework.h>
#include <Graphics/Scene/Scene.h>
#include <Graphics/SceneNode/SceneNodeManager.h>
#include <Animation/System/AnimationManager.h>
#include <Animation/System/Animation.h>
#include <Input/Pad/PS2Pad.h>

// Lamp̃l[Xy[XLɂ
using namespace Lamp;

//------------------------------------------------------------------------------
// NX`Aʏ̓wb_t@CɊi[
//------------------------------------------------------------------------------
/**
 * `[gA2 LN^ړ
 */
class Tutorial2_CharacterMove : public SceneFramework{
public:
	/**
	 * RXgN^
	 */
	Tutorial2_CharacterMove();

	/**
	 * 
	 * @return ɐtrueԂ
	 */
	virtual bool initialize();

	/**
	 * s
	 */
	virtual void run();

protected:
	// LN^ړm[h
	SceneNode* characterMoveNode_;
	// LN^]m[h
	SceneNode* characterRotationNode_;
	// Aj[V
	Animation* animation_;

};
//------------------------------------------------------------------------------
// vOGg|Cg
//------------------------------------------------------------------------------
// C֐
int WINAPI WinMain(
	HINSTANCE instance, HINSTANCE previousInstance, LPSTR command, int show){
	Tutorial2_CharacterMove tutorial;
	return tutorial.execute(instance);
}
//------------------------------------------------------------------------------
// NX
//------------------------------------------------------------------------------
// RXgN^
Tutorial2_CharacterMove::Tutorial2_CharacterMove() :
	SceneFramework("Tutorial2_CharacterMove"),
	characterMoveNode_(NULL), characterRotationNode_(NULL){
}
//------------------------------------------------------------------------------
// 
bool Tutorial2_CharacterMove::initialize(){
	// V[̃[h
	if(!loadScene("../Media/Tutorial.bsn")){ return false; }
	// ړm[h̎擾
	characterMoveNode_ =
		scene_->getSceneNodeManager()->search("MakotoMove");
	// ]m[h̎擾
	characterRotationNode_ =
		scene_->getSceneNodeManager()->search("MakotoRotation");
	// Aj[V̎擾
	animation_ = animationManager_->search("Tutorial");
	return true;
}
//------------------------------------------------------------------------------
// s
void Tutorial2_CharacterMove::run(){
	Vector3 addPosition(Vector3::zero);
	float moveSpeed = 0.4f;
	// pbh͏
	if(pad_ != NULL){
		Point2f leftAxis = pad_->getLeftAxis();
		leftAxis *= moveSpeed;
		addPosition += Vector3(leftAxis.x, 0.f, leftAxis.y);
	}

	// L[{[h͏
	if(keyboard_->pressed(Keyboard::keyUp)){ addPosition.z -= moveSpeed; }
	if(keyboard_->pressed(Keyboard::keyDown)){ addPosition.z += moveSpeed; }
	if(keyboard_->pressed(Keyboard::keyRight)){ addPosition.x += moveSpeed; }
	if(keyboard_->pressed(Keyboard::keyLeft)){ addPosition.x -= moveSpeed; }

	// ʒu̐ݒ
	Vector3 position = characterMoveNode_->getTranslation();
	position += addPosition;
	characterMoveNode_->setTranslation(position);

	// ]ƃAj[V̐ݒ
	if(!addPosition.isZero()){
		characterRotationNode_->setRotationXYZ(Vector3(0.f,
			Math::atan2(addPosition.x, addPosition.z), 0.f));
		if(animation_->getSequence() != 0){ animation_->setSequence(0); }
	}else{
		if(animation_->getSequence() != 3){ animation_->setSequence(3); }
	}
}
//------------------------------------------------------------------------------
