//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * `[gA1 V[̃[h
 * @author Junpee
 */

#include <LampBasic.h>
#include <Framework/System/SceneFramework.h>

// Lamp̃l[Xy[XLɂ
using namespace Lamp;

//------------------------------------------------------------------------------
// NX`Aʏ̓wb_t@CɊi[
//------------------------------------------------------------------------------
/**
 * `[gA1 V[̃[h
 */
class Tutorial1_LoadScene : public SceneFramework{
public:
	/**
	 * RXgN^
	 */
	Tutorial1_LoadScene();

	/**
	 * 
	 * @return ɐtrueԂ
	 */
	virtual bool initialize();

};
//------------------------------------------------------------------------------
// vOGg|Cg
//------------------------------------------------------------------------------
// C֐
int WINAPI WinMain(
	HINSTANCE instance, HINSTANCE previousInstance, LPSTR command, int show){
	Tutorial1_LoadScene tutorial;
	return tutorial.execute(instance);
}
//------------------------------------------------------------------------------
// NX
//------------------------------------------------------------------------------
// RXgN^
Tutorial1_LoadScene::Tutorial1_LoadScene() :
	SceneFramework("Tutorial1_LoadScene"){
}
//------------------------------------------------------------------------------
// 
bool Tutorial1_LoadScene::initialize(){
	// V[̃[h
	if(!loadScene("../Media/Tutorial.bsn")){ return false; }
	D3DXMATRIX lightView;
	D3DXVECTOR3 lightPos(-60.f, -60.f, 0.f);
	D3DXVECTOR3 lightLookAt(0.f, 0.f, 0.f);
	D3DXVECTOR3 lightUp(0.f, 1.f, 0.f);
	D3DXMatrixLookAtLH(&lightView, &lightPos, &lightLookAt, &lightUp);
	DebugOut("LightView\n");
	for(int i = 0; i < 4; i++){
		for(int j = 0; j < 4; j++){
			DebugOut("%f ", lightView(j, i));
		}
		DebugOut("\n");
	}
	D3DXMATRIX lightProj;
//	D3DXMatrixOrthoLH(&lightProj, 200.f, 200.f, 1.f, 9999.f);
	D3DXMatrixPerspectiveFovLH(&lightProj, Math::toRadian(120.f), 1.f, 1.f, 999.f);
	DebugOut("LightProj\n");
	for(int i = 0; i < 4; i++){
		for(int j = 0; j < 4; j++){
			DebugOut("%f ", lightProj(j, i));
		}
		DebugOut("\n");
	}
	Matrix44 matrix;
	matrix.setScale(1.f, 2.f, 1.f);
	matrix.addTranslation(10.f, 10.f, 10.f);
	DebugOut((matrix * Vector3::zero).toString() + "\n");
	matrix.invert();
	matrix.transpose();
	matrix.invert();
	DebugOut((matrix * Vector3::unitY).toString() + "\n");
	return true;
}
//------------------------------------------------------------------------------
