//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * XeNX`gX[^wb_
 * @author Junpee
 */

#ifndef X_TEXTURE_TRANSLATOR_H_
#define X_TEXTURE_TRANSLATOR_H_

// Lamp̃l[Xy[XLɂ
using namespace Lamp;

namespace Lamp{
class FilePath;
class Scene;
class Texture;
}

//------------------------------------------------------------------------------
/**
 * XeNX`gX[^
 */
class XTextureTranslator{
public:
	/**
	 * RXgN^
	 */
	XTextureTranslator();

	/**
	 * fXgN^
	 */
	virtual ~XTextureTranslator();

	/**
	 * ϊ
	 * @param xFilePath Xt@CpX
	 * @param scene V[
	 * @param name O
	 * @param texturePath eNX`pX
	 * @return true
	 */
	virtual bool translate(const FilePath& xFilePath,
		Scene* scene, const String& name, const String& texturePath);

	/**
	 * eNX`̎擾
	 * @return eNX`
	 */
	virtual Texture* getTexture() const{ return texture_; }

	/// eNX`TtBbNX
	static const String textureSuffix;
	/// sN`TtBbNX
	static const String pictureSuffix;

private:
	// Rs[RXgN^̉B
	XTextureTranslator(const XTextureTranslator& copy);

	// Rs[̉B
	void operator =(const XTextureTranslator& copy);

	// D3DeNX`
	Direct3DTexture* d3dTexture_;
	// eNX`
	Texture* texture_;

};

//------------------------------------------------------------------------------
#endif // End of X_TEXTURE_TRANSLATOR_H_
//------------------------------------------------------------------------------

