//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * XbVgX[^wb_
 * @author Junpee
 */

#ifndef X_MESH_TRANSLATOR_H_
#define X_MESH_TRANSLATOR_H_

// Lamp̃l[Xy[XLɂ
using namespace Lamp;

namespace Lamp{
class FilePath;
class Scene;
class SceneNode;
class Model;
}

//------------------------------------------------------------------------------
/**
 * XbVgX[^
 */
class XMeshTranslator{
public:
	/**
	 * RXgN^
	 */
	XMeshTranslator();

	/**
	 * fXgN^
	 */
	virtual ~XMeshTranslator();

	/**
	 * Xt@C̕ϊ
	 * @param xFilePath Xt@CpX
	 * @param scene V[
	 * @return true
	 */
	virtual bool translateXFile(const FilePath& xFilePath, Scene* scene);

	/// V[m[hTtBbNX
	static const String sceneNodeSuffix;
	/// fTtBbNX
	static const String modelSuffix;
	/// bVTtBbNX
	static const String meshSuffix;
	/// bVf[^TtBbNX
	static const String meshDataSuffix;

private:
	// f̏
	virtual void initializeModel();

	// Agr[g̉
	virtual bool analyzeAttribute();

	// _Lq̉
	virtual bool analyzeDeclaration();

	// bV̉
	virtual bool analyzeMesh(const FilePath& xFilePath,
		const D3DXATTRIBUTERANGE& attribute, const D3DXMATERIAL& material);

	// Rs[RXgN^̉B
	XMeshTranslator(const XMeshTranslator& copy);

	// Rs[̉B
	void operator =(const XMeshTranslator& copy);

	// XbV
	Direct3DXMesh* xMesh_;
	// X}eA
	Direct3DXBuffer* xMaterialsBuffer_;
	// X}eA
	u_int xMaterialCount_;
	// Agr[g
	D3DXATTRIBUTERANGE* xAttributes_;
	// Agr[g
	u_int xAttributeCount_;

	// _TCY
	u_int vertexSize_;
	// ʒuItZbg
	int positionOffset_;
	// @ItZbg
	int normalOffset_;
	// UVItZbg
	int uvOffset_;

	// V[
	Scene* scene_;
	// O
	String name_;
	// V[m[h
	SceneNode* sceneNode_;
	// f
	Model* model_;
};

//------------------------------------------------------------------------------
#endif // End of X_MESH_TRANSLATOR_H_
//------------------------------------------------------------------------------

