//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * X}eAgX[^wb_
 * @author Junpee
 */

#ifndef X_MATERIAL_TRANSLATOR_H_
#define X_MATERIAL_TRANSLATOR_H_

// Lamp̃l[Xy[XLɂ
using namespace Lamp;

namespace Lamp{
class FilePath;
class Scene;
class Material;
}

//------------------------------------------------------------------------------
/**
 * X}eAgX[^
 */
class XMaterialTranslator{
public:
	/**
	 * RXgN^
	 */
	XMaterialTranslator();

	/**
	 * fXgN^
	 */
	virtual ~XMaterialTranslator();

	/**
	 * ϊ
	 * @param xFilePath Xt@CpX
	 * @param scene V[
	 * @param name O
	 * @param xMaterial X}eA
	 * @return true
	 */
	virtual bool translate(const FilePath& xFilePath,
		Scene* scene, const String& name, const D3DXMATERIAL& xMaterial);

	/**
	 * }eA̎擾
	 * @return }eA
	 */
	virtual Material* getMaterial() const{ return material_; }

	/// }eATtBbNX
	static const String materialSuffix;

private:
	// OvfJ[ւ̕ϊ
	virtual Color3f convertColor3f(const D3DCOLORVALUE& d3dColor){
		return Color3f(d3dColor.r, d3dColor.g, d3dColor.b);
	}

	// Rs[RXgN^̉B
	XMaterialTranslator(const XMaterialTranslator& copy);

	// Rs[̉B
	void operator =(const XMaterialTranslator& copy);

	// }eA
	Material* material_;
};

//------------------------------------------------------------------------------
#endif // End of X_MATERIAL_TRANSLATOR_H_
//------------------------------------------------------------------------------

