//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * X}eAgX[^
 * @author Junpee
 */

#include <LampBasic.h>
#include "XTranslator/XMaterialTranslator.h"
#include "XTranslator/XTextureTranslator.h"
#include <Core/InputOutput/FilePath.h>
#include <Graphics/Scene/Scene.h>
#include <Graphics/Material/MaterialManager.h>

/// }eATtBbNX
const String XMaterialTranslator::materialSuffix = "Material";

//------------------------------------------------------------------------------
// RXgN^
XMaterialTranslator::XMaterialTranslator() : material_(NULL){
}
//------------------------------------------------------------------------------
// fXgN^
XMaterialTranslator::~XMaterialTranslator(){
}
//------------------------------------------------------------------------------
// ϊ
bool XMaterialTranslator::translate(const FilePath& xFilePath,
	Scene* scene, const String& name, const D3DXMATERIAL& xMaterial){
	// }eA쐬
	MaterialManager* materialManager = scene->getMaterialManager();
	String materialName = materialManager->rename(name + materialSuffix);
	BasicMaterial* material =
		materialManager->createBasicMaterial(materialName);
	material_ = material;

	// }eA̕ϊ
	const D3DMaterial& d3dMaterial = xMaterial.MatD3D;
	material->setDiffuseColor(convertColor3f(d3dMaterial.Diffuse));
	float alpha = d3dMaterial.Diffuse.a;
	// lɃAt@0ݒ肳Ăf[^܂ɂ̂
	// 0̏ꍇ1ɂĂ
	if(alpha == 0.f){ alpha = 1.f; }
	material->setAlpha(alpha);
	if(Math::abs(alpha - 1.f) > Math::epsilon){
		material->setBlendMode(Material::blendModeAdd);
	}
	// Xt@Cɂ͏ɃArGgF̂ŔZbg
	Color3f ambient = convertColor3f(d3dMaterial.Ambient);
	Assert(ambient == Color3f::black);
	material->setAmbientColor(Color3f::white);
	material->setSpecularColor(convertColor3f(d3dMaterial.Specular));
	material->setSpecularPower(d3dMaterial.Power);
	material->setEmissiveColor(convertColor3f(d3dMaterial.Emissive));

	// eNX`ϊ
	XTextureTranslator xTextureTranslator;
	if(!xTextureTranslator.translate(
		xFilePath, scene, name, String(xMaterial.pTextureFilename))){
		return false;
	}
	material->setBaseTexture(xTextureTranslator.getTexture());

	return true;
}
//------------------------------------------------------------------------------
