//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Xt@CRo[^
 * @author Junpee
 */

#include <LampBasic.h>
#include <System/XFileConverter.h>
#include <Core/InputOutput/FilePath.h>
#include <Input/Joystick/Joystick.h>
#include <Framework/Utility/PS2PadCameraController.h>
#include <Graphics/System/LampGraphics.h>
#include <Graphics/Renderer/Renderer.h>
#include <Graphics/Camera/CameraManager.h>
#include <Graphics/SceneNode/SceneNode.h>
#include <Graphics/MeshData/MeshDataManager.h>
#include <Graphics/Light/LightManager.h>
#include <Graphics/SceneFilter/SceneFilter.h>
#include <Graphics/InputOutput/TextSceneSaver.h>
#include "XTranslator/XMeshTranslator.h"

//------------------------------------------------------------------------------
// vOGg|Cg
//------------------------------------------------------------------------------
// C֐
int WINAPI WinMain(
	HINSTANCE instance, HINSTANCE previousInstance, LPSTR command, int show){
	String commandString(command);
	XFileConverter converter(commandString);
	return converter.execute(instance);
}
//------------------------------------------------------------------------------
// Aj
//------------------------------------------------------------------------------
// RXgN^
XFileConverter::XFileConverter(const String& command) :
	BasicFramework("XFileConverter"), command_(command), renderer_(NULL),
	scene_(NULL), camera_(NULL), pointLight_(NULL), cameraController_(NULL){
}
//------------------------------------------------------------------------------
// fXgN^
XFileConverter::~XFileConverter(){
}
//------------------------------------------------------------------------------
// t[[N\bh
//------------------------------------------------------------------------------
// 
bool XFileConverter::initialize(){
	// ̉
	if(command_.isEmpty()){
		ErrorOut("XFileConverter::initialize() ܂");
		return false;
	}
	// Xt@C
	String xFileName = command_;
	FilePath xFilePath(xFileName);

	// _
	renderer_ = new Renderer();
	// JRg[
	cameraController_ = new PS2PadCameraController();
	cameraController_->searchJoystick();
	// V[̍쐬
	scene_ = LampGraphics::createScene(xFilePath.getName());

	// Xt@C̃Ro[g
	XMeshTranslator xMeshTranslator_;
	if(!xMeshTranslator_.translateXFile(xFilePath, scene_)){
		ErrorOut("XFileConverter::initialize() Xt@C̃[hɎs܂");
		return false;
	}

	// V[tB^
	SceneFilter sceneFilter(scene_);
	// sN`pX̕ύX
	if(!sceneFilter.filter("ChangePicturePath pictures/")){
		ErrorOut("XFileConverter::initialize() "
			"sN`pX̕ύXɎs܂");
		return false;
	}
	// oEfBO{bNXZo
	if(!sceneFilter.filter("CalculateBoundingBox")){
		ErrorOut("XFileConverter::initialize() "
			"oEfBO{bNX̎ZoɎs܂");
		return false;
	}
	// oEfBOXtBAZo
	if(!sceneFilter.filter("CalculateBoundingSphere")){
		ErrorOut("XFileConverter::initialize() "
			"oEfBOXtBA̎ZoɎs܂");
		return false;
	}
	// V[̘_`FbN
	if(!sceneFilter.filter("SceneLogicCheck")){
		ErrorOut("XFileConverter::initialize() "
			"V[̘_`FbNɎs܂");
		return false;
	}

	// V[̏óA̓pXƓɏo͂
	String fileName = xFilePath.getFolderPath() + xFilePath.getName() + ".tsn";
	TextSceneSaver* textSceneSaver = new TextSceneSaver();
	textSceneSaver->save(fileName, scene_);
	delete textSceneSaver;

	// J̍쐬
	camera_ = scene_->getCameraManager()->createCamera("camera");
	scene_->setCurrentCamera(camera_);
	cameraController_->setCamera(camera_);
	// J̎Zo
	float distance = 2.f;
	MeshDataManager* meshDataManager = scene_->getMeshDataManager();
	int meshDataCount = meshDataManager->getCount();
	for(int i = 0; i < meshDataCount; i++){
		MeshData* meshData = meshDataManager->get(i);
		float radius = meshData->getBoundingSphere().getRadius();
		if(radius > distance){ distance = radius; }
	}
	camera_->setTransformation(
		Vector3::zero, Vector3(0.f, distance * 0.5f, distance * 1.5f));

	// Cg̍쐬
	LightManager* lightManager = scene_->getLightManager();
	Color3f lightColor(1.f, 1.f, 1.f);
	directionalLight_ =
		lightManager->createDirectionalLight("directionalLight");
	directionalLight_->setDirection(Vector3(-1.f, -1.f, -1.f));
	directionalLight_->setColor(lightColor);
	scene_->getRootNode()->addSceneLeaf(directionalLight_);
	pointLight_ = lightManager->createPointLight("pointLight");
	pointLight_->setColor(lightColor);
	pointLight_->setEnabled(false);
	scene_->getRootNode()->addSceneLeaf(pointLight_);
	return true;
}
//------------------------------------------------------------------------------
// n
void XFileConverter::finalize(){
	// JRg[̔j
	SafeDelete(cameraController_);
	// V[̔j
	scene_->clear();
	LampGraphics::destroyScene(scene_);
	// _̔j
	SafeDelete(renderer_);
}
//------------------------------------------------------------------------------
// s
void XFileConverter::run(){
	// J
	cameraController_->control();
	Joystick* cameraPad = cameraController_->getJoystick();
	if(cameraPad != NULL){
		if(cameraPad->buttonDown(0)){
			bool enabled = directionalLight_->isEnabled();
			directionalLight_->setEnabled(!enabled);
			pointLight_->setEnabled(enabled);
		}
	}
	pointLight_->setPosition(camera_->getPosition());
}
//------------------------------------------------------------------------------
// _O
void XFileConverter::renderSetup(){
	// go[XAɃJ̐ݒIĂKv
	scene_->traverse();
	// _O
	renderer_->renderingSetup(scene_);
}
//------------------------------------------------------------------------------
// _O
void XFileConverter::render(){
	// _O
	renderer_->rendering();
}
//------------------------------------------------------------------------------
// `
void XFileConverter::drawInformation(){
	BasicFramework::drawInformation();
}
//------------------------------------------------------------------------------
