//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * V[r[
 * @author Junpee
 */

#include "stdafx.h"
#include "SceneViewer.h"
#include <Core/Utility/StringTokenizer.h>
#include <Core/InputOutput/FilePath.h>
#include <Graphics/Enumeration/GraphicsDeviceEnumeration.h>
#include <Framework/Utility/FirstPersonCameraController.h>
#include <Graphics/SceneNode/SceneNode.h>
#include <Graphics/Light/LightManager.h>
#include <Graphics/Camera/Camera.h>
#include <Animation/System/Animation.h>

//------------------------------------------------------------------------------
// vOGg|Cg
int WINAPI WinMain(
	HINSTANCE instance, HINSTANCE previousInstance, LPSTR command, int show){
	SceneViewer sceneViewer;
	return sceneViewer.execute(instance);
}
//------------------------------------------------------------------------------
// RXgN^
SceneViewer::SceneViewer() : SceneFramework("SceneViewer"), pointLight_(NULL){
	// EBhE쐬p[^ύX
	createWindowParameter_.createWidth_ = 1024;
	createWindowParameter_.createHeight_ = 768;
	GraphicsDeviceEnumeration* enumeration =
		GraphicsDeviceEnumeration::getInstance();
	enumeration->setMinimumDepthBits(24);
	enumeration->setMinimumBackBufferAlphaChannelBits(8);
}
//------------------------------------------------------------------------------
// 
bool SceneViewer::initialize(){
	// R}hC
	String command(GetCommandLine());
	StringTokenizer tokenizer(command);
	String sceneName;
	while(tokenizer.hasMoreTokens()){
		String token = tokenizer.getNextToken();
		if(token == "-bgm"){
			// bgm̓ǂݍ
			if(!tokenizer.hasMoreTokens()){ return false; }
			bgmName_ = tokenizer.getNextToken();
//		}else if(token == "-information"){
			// CtH[Vxw
//			if(!tokenizer.hasMoreTokens()){ return false; }
//			if(!tokenizer.getNextToken().parseInt(&drawInformationMode_)){
//				return false;
//			}
		}else{
			// SĈႦ΃V[
			sceneName = token;
		}
	}
	if(sceneName.getSize() != 0){
		if(!loadScene(sceneName)){ return false; }
	}
	// Cg̍쐬
	LightManager* lightManager = scene_->getLightManager();
	if(lightManager->getCount() == 0){
		Color3f lightColor(1.f, 1.f, 1.f);
		pointLight_ = lightManager->createPointLight("pointLight");
		pointLight_->setColor(lightColor);
		scene_->getRootNode()->addSceneLeaf(pointLight_);
	}
	return true;
}
//------------------------------------------------------------------------------
// s
void SceneViewer::run(){
	if(pointLight_ != NULL){
		pointLight_->setPosition(camera_->getPosition());
	}
	if(animation_ != NULL){
		int sequenceCount = animation_->getSequenceCount();
		int sequence = animation_->getSequence();
		if(keyboard_->down(Keyboard::keyN)){
			sequence++;
			if(sequence == sequenceCount){ sequence = 0; }
			animation_->setSequence(sequence);
		}
		if(keyboard_->down(Keyboard::keyB)){
			sequence--;
			if(sequence == -1){ sequence = sequenceCount - 1; }
			animation_->setSequence(sequence);
		}
	}
}
//------------------------------------------------------------------------------
// V[̃[h
bool SceneViewer::loadScene(const String& sceneName){
	if(!SceneFramework::loadScene(sceneName)){ return false; }
	// ^CgύX
	String windowTitle("SceneViewer " + sceneName_);
	::SetWindowText(windowHandle_, windowTitle.getBytes());
	// BGM炷
	if(bgmName_ == ""){ return true; }
	FilePath bgmFilePath(bgmName_);
	if(!bgmFilePath.existFile()){ return true; }
	PlaySound(NULL, NULL, 0);
	PlaySound(bgmFilePath.getPath().getBytes(),
		NULL, SND_ASYNC | SND_FILENAME | SND_LOOP);
	return true;
}
//------------------------------------------------------------------------------
